/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectsProblemsModel;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.internal.navigator.resources.workbench.ResourceExtensionLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class NestedProjectsLabelProvider
extends ResourceExtensionLabelProvider {
    private IResourceChangeListener refreshSeveritiesOnProblemMarkerChange;
    private NestedProjectsProblemsModel model;
    private CompletableFuture<NestedProjectsProblemsModel> refreshModelJob;
    private volatile boolean isDisposed;

    @Override
    public void init(ICommonContentExtensionSite aConfig) {
        super.init(aConfig);
        this.model = new NestedProjectsProblemsModel();
        this.refreshModelJob = this.refreshSeverities();
        this.refreshSeveritiesOnProblemMarkerChange = event -> {
            if (event.getDelta() == null) {
                return;
            }
            MarkerManager markerManager = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
            try {
                event.getDelta().accept(delta -> {
                    IMarkerDelta[] markerDeltas;
                    IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                    int n = markerDeltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource;
                        IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                        if (markerManager.isSubtype(markerDelta.getType(), "org.eclipse.core.resources.problemmarker") && (resource = markerDelta.getResource()) != null) {
                            this.model.markDirty(resource);
                        }
                        ++n2;
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
            if (this.model.isDirty()) {
                this.refreshModelJob = this.refreshSeverities();
                this.refreshModelJob.thenAccept(model -> {
                    if (!this.isDisposed) {
                        Object[] toUpdate = model.getResourcesWithModifiedSeverity().toArray();
                        LabelProviderChangedEvent evt = new LabelProviderChangedEvent((IBaseLabelProvider)this, toUpdate);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fireLabelProviderChanged(evt));
                    }
                });
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
    }

    public void dispose() {
        this.isDisposed = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
        super.dispose();
    }

    private CompletableFuture<NestedProjectsProblemsModel> refreshSeverities() {
        return CompletableFuture.supplyAsync(() -> {
            this.model.refreshModel();
            return this.model;
        });
    }

    protected String decorateText(String input, Object element) {
        super.decorateText(input, element);
        if (!(element instanceof IProject)) {
            return input;
        }
        IProject project = (IProject)element;
        IPath location = project.getLocation();
        if (location == null) {
            return input;
        }
        String lastSegment = location.lastSegment();
        if (lastSegment == null) {
            return input;
        }
        if (!lastSegment.equals(project.getName())) {
            return NLS.bind((String)WorkbenchNavigatorMessages.NestedProjectLabelProvider_nestedProjectLabel, (Object)input, (Object)lastSegment);
        }
        return input;
    }

    @Override
    protected int getHighestProblemSeverity(IResource resource) {
        int problemSeverity = super.getHighestProblemSeverity(resource);
        if (resource instanceof IContainer && problemSeverity < 2) {
            try {
                CompletableFuture<NestedProjectsProblemsModel> problemsModelSnapshot = this.refreshModelJob;
                if (problemsModelSnapshot != null) {
                    problemSeverity = Math.max(problemSeverity, problemsModelSnapshot.get(50L, TimeUnit.MILLISECONDS).getMaxSeverityIncludingNestedProjects(resource));
                }
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException | RuntimeException | ExecutionException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
        }
        return problemSeverity;
    }
}

