/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.utils.MarkerConfig;
import org.eclipse.tm4e.ui.internal.utils.MarkerUtils;
import org.eclipse.tm4e.ui.internal.widgets.ColumnSelectionAdapter;
import org.eclipse.tm4e.ui.internal.widgets.ColumnViewerComparator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class TaskTagsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.TaskTagsPreferencePage";
    private final Set<MarkerConfig> markerConfigs = PreferenceHelper.loadMarkerConfigs();
    private TableViewer markerConfigsTable = (TableViewer)NullSafetyHelper.lazyNonNull();

    public TaskTagsPreferencePage() {
        this.setDescription(TMUIMessages.TaskTagsPreferencePage_description);
    }

    protected Control createContents(@Nullable Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Table table = new Table(parent, 68356);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.markerConfigsTable = new TableViewer(table);
        this.markerConfigsTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.markerConfigsTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(@Nullable Object inputElement) {
                return inputElement == null ? new MarkerConfig[]{} : ((Collection)inputElement).toArray();
            }
        });
        ColumnViewerComparator tableColumnSorter = new ColumnViewerComparator();
        this.markerConfigsTable.setComparator((ViewerComparator)tableColumnSorter);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(TMUIMessages.TaskTagsPreferencePage_column_tag);
        column1.setWidth(this.computeMinimumColumnWidth("1234567890"));
        column1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column1, this.markerConfigsTable, 0, tableColumnSorter));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(TMUIMessages.TaskTagsPreferencePage_column_type);
        column2.setWidth(column1.getWidth());
        column2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column2, this.markerConfigsTable, 1, tableColumnSorter));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(TMUIMessages.TaskTagsPreferencePage_column_level);
        column3.setWidth(column1.getWidth());
        column3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column3, this.markerConfigsTable, 2, tableColumnSorter));
        table.setSortColumn(column1);
        table.setSortDirection(tableColumnSorter.getDirection());
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        buttons.setLayout((Layout)new GridLayout());
        Button newTagButton = new Button(buttons, 8);
        newTagButton.setText(TMUIMessages.Button_new);
        newTagButton.setLayoutData((Object)new GridData(768));
        newTagButton.addListener(13, e -> {
            MarkerConfigEditDialog dlg = new MarkerConfigEditDialog(this.getShell(), null);
            if (dlg.open() == 0) {
                this.markerConfigs.add((MarkerConfig)NullSafetyHelper.castNonNull((Object)dlg.markerConfig));
                this.markerConfigsTable.refresh();
            }
        });
        Button editTagButton = new Button(buttons, 8);
        editTagButton.setText(TMUIMessages.Button_edit);
        editTagButton.setLayoutData((Object)new GridData(768));
        editTagButton.addListener(13, e -> {
            MarkerConfigEditDialog dlg;
            MarkerConfig selection = (MarkerConfig)((IStructuredSelection)this.markerConfigsTable.getSelection()).getFirstElement();
            if (selection != null && (dlg = new MarkerConfigEditDialog(this.getShell(), selection)).open() == 0 && !selection.equals(dlg.markerConfig)) {
                this.markerConfigs.remove(selection);
                this.markerConfigs.add((MarkerConfig)NullSafetyHelper.castNonNull((Object)dlg.markerConfig));
                this.markerConfigsTable.refresh();
            }
        });
        Button removeTagButton = new Button(buttons, 8);
        removeTagButton.setText(TMUIMessages.Button_remove);
        removeTagButton.setLayoutData((Object)new GridData(768));
        removeTagButton.addListener(13, e -> {
            MarkerConfig selection = (MarkerConfig)((IStructuredSelection)this.markerConfigsTable.getSelection()).getFirstElement();
            if (selection != null) {
                this.markerConfigs.remove(selection);
                this.markerConfigsTable.refresh();
            }
        });
        this.applyDialogFont(parent);
        this.markerConfigsTable.setInput(this.markerConfigs);
        return parent;
    }

    private int computeMinimumColumnWidth(String string) {
        GC gc = new GC((Drawable)this.getShell());
        try {
            gc.setFont(JFaceResources.getDialogFont());
            int n = gc.stringExtent((String)string).x + 20;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public void init(@Nullable IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.markerConfigs.clear();
        this.markerConfigs.addAll(MarkerConfig.getDefaults());
        this.markerConfigsTable.refresh();
    }

    public boolean performOk() {
        PreferenceHelper.saveMarkerConfigs(this.markerConfigs);
        MarkerUtils.reloadMarkerConfigs();
        return true;
    }

    private final class MarkerConfigEditDialog
    extends TitleAreaDialog {
        @Nullable MarkerConfig markerConfig;
        Text txtTag;
        Combo cmbType;
        Label lblLevel;
        Combo cmbLevel;

        MarkerConfigEditDialog(@Nullable Shell parentShell, MarkerConfig markerConfig) {
            super(parentShell);
            this.txtTag = (Text)NullSafetyHelper.lazyNonNull();
            this.cmbType = (Combo)NullSafetyHelper.lazyNonNull();
            this.lblLevel = (Label)NullSafetyHelper.lazyNonNull();
            this.cmbLevel = (Combo)NullSafetyHelper.lazyNonNull();
            this.markerConfig = markerConfig;
        }

        public void create() {
            super.create();
            if (this.markerConfig == null) {
                this.getShell().setText(TMUIMessages.TaskTagsPreferencePage_addTagDialog_windowTitle);
                this.setTitle(TMUIMessages.TaskTagsPreferencePage_addTagDialog_header);
                this.setMessage(TMUIMessages.TaskTagsPreferencePage_addTagDialog_message, 1);
            } else {
                this.getShell().setText(TMUIMessages.TaskTagsPreferencePage_editTagDialog_windowTitle);
                this.setTitle(TMUIMessages.TaskTagsPreferencePage_editTagDialog_header);
                this.setMessage(TMUIMessages.TaskTagsPreferencePage_editTagDialog_message, 1);
            }
            this.validateInput(null);
        }

        protected void okPressed() {
            this.markerConfig = switch (MarkerConfig.Type.valueOf(this.cmbType.getText())) {
                case MarkerConfig.Type.PROBLEM -> new MarkerConfig.ProblemMarkerConfig(this.txtTag.getText(), MarkerConfig.ProblemSeverity.valueOf(this.cmbLevel.getText()));
                case MarkerConfig.Type.TASK -> new MarkerConfig.TaskMarkerConfig(this.txtTag.getText(), MarkerConfig.TaskPriority.valueOf(this.cmbLevel.getText()));
                default -> throw new IncompatibleClassChangeError();
            };
            super.okPressed();
        }

        void validateInput(@Nullable Event e) {
            Button btn = this.getButton(0);
            if (btn == null) {
                return;
            }
            btn.setEnabled(!this.txtTag.getText().isBlank() && this.cmbType.getSelectionIndex() > -1 && this.cmbLevel.getSelectionIndex() > -1);
        }

        protected Control createDialogArea(@Nullable Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            this.createTagText(container);
            this.createTypeCombo(container);
            this.createLevel(container);
            MarkerConfig markerConfig = this.markerConfig;
            if (markerConfig != null) {
                this.txtTag.setText(markerConfig.tag);
                this.cmbType.setText(markerConfig.type.name());
                this.cmbLevel.setText(switch (markerConfig.type) {
                    case MarkerConfig.Type.PROBLEM -> markerConfig.asProblemMarkerConfig().severity.name();
                    case MarkerConfig.Type.TASK -> markerConfig.asTaskMarkerConfig().priority.name();
                    default -> throw new IncompatibleClassChangeError();
                });
            } else {
                this.cmbType.setText(MarkerConfig.Type.TASK.name());
                this.cmbLevel.setText(MarkerConfig.TaskPriority.NORMAL.name());
            }
            return area;
        }

        void createTagText(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(TMUIMessages.TaskTagsPreferencePage_column_tag);
            this.txtTag = new Text(parent, 2048);
            GridData layoutData = new GridData();
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.horizontalAlignment = 4;
            this.txtTag.setLayoutData((Object)layoutData);
            this.txtTag.addListener(24, this::validateInput);
        }

        void createTypeCombo(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(TMUIMessages.TaskTagsPreferencePage_column_type);
            this.cmbType = new Combo(parent, 8);
            this.cmbType.setItems((String[])Stream.of(MarkerConfig.Type.values()).map(Enum::name).toArray(String[]::new));
            this.cmbType.addListener(24, e -> {
                if (!this.cmbType.getText().isBlank()) {
                    switch (MarkerConfig.Type.valueOf(this.cmbType.getText())) {
                        case PROBLEM: {
                            this.lblLevel.setText("Severity");
                            this.cmbLevel.setItems((String[])Stream.of(MarkerConfig.ProblemSeverity.values()).map(Enum::name).toArray(String[]::new));
                            break;
                        }
                        case TASK: {
                            this.lblLevel.setText("Priority");
                            this.cmbLevel.setItems((String[])Stream.of(MarkerConfig.TaskPriority.values()).map(Enum::name).toArray(String[]::new));
                        }
                    }
                }
                this.validateInput(null);
            });
        }

        void createLevel(Composite parent) {
            this.lblLevel = new Label(parent, 0);
            GridData layoutData = new GridData();
            layoutData.widthHint = TaskTagsPreferencePage.this.computeMinimumColumnWidth("1234567890");
            layoutData.horizontalAlignment = 4;
            this.lblLevel.setLayoutData((Object)layoutData);
            this.cmbLevel = new Combo(parent, 8);
            this.cmbLevel.addListener(24, this::validateInput);
        }

        public boolean isHelpAvailable() {
            return false;
        }
    }

    private static final class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            return null;
        }

        public @Nullable String getText(@Nullable Object element) {
            return this.getColumnText(element, 0);
        }

        public @Nullable String getColumnText(@Nullable Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            MarkerConfig item = (MarkerConfig)element;
            return switch (columnIndex) {
                case 0 -> item.tag;
                case 1 -> String.valueOf(item.type.name().charAt(0)) + item.type.name().substring(1).toLowerCase();
                case 2 -> {
                    switch (item.type) {
                        case PROBLEM: {
                            yield item.asProblemMarkerConfig().severity.toString();
                        }
                        case TASK: {
                            yield item.asTaskMarkerConfig().priority.toString();
                        }
                    }
                    throw new IncompatibleClassChangeError();
                }
                default -> "";
            };
        }
    }
}

