/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions.commands;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.services.extensions.commands.ArgumentsUtils;
import org.eclipse.lemminx.services.extensions.commands.IXMLCommandService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public abstract class AbstractDOMDocumentCommandHandler
implements IXMLCommandService.IDelegateCommandHandler {
    private final IXMLDocumentProvider documentProvider;

    public AbstractDOMDocumentCommandHandler(IXMLDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
    }

    @Override
    public final Object executeCommand(ExecuteCommandParams params, SharedSettings sharedSettings, CancelChecker cancelChecker) throws Exception {
        TextDocumentIdentifier identifier = ArgumentsUtils.getArgAt(params, 0, TextDocumentIdentifier.class);
        String uri = identifier.getUri();
        DOMDocument document = this.documentProvider.getDocument(uri);
        if (document == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' cannot find the DOM document with the URI '%s'.", params.getCommand(), uri));
        }
        return this.executeCommand(document, params, sharedSettings, cancelChecker);
    }

    protected abstract Object executeCommand(DOMDocument var1, ExecuteCommandParams var2, SharedSettings var3, CancelChecker var4) throws Exception;
}

