/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings.capabilities;

import java.util.Optional;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DynamicRegistrationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;

public class ClientCapabilitiesWrapper {
    private boolean v3Supported;
    public ClientCapabilities capabilities;
    private final ExtendedClientCapabilities extendedCapabilities;

    public ClientCapabilitiesWrapper() {
        this(new ClientCapabilities(), null);
    }

    public ClientCapabilitiesWrapper(ClientCapabilities capabilities, ExtendedClientCapabilities extendedCapabilities) {
        this.capabilities = capabilities;
        this.v3Supported = capabilities != null ? capabilities.getTextDocument() != null : false;
        this.extendedCapabilities = extendedCapabilities;
    }

    public boolean isCompletionDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getCompletion());
    }

    public boolean isLinkDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getDocumentLink());
    }

    public boolean isColorDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getColorProvider());
    }

    public boolean isRangeFoldingDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getFoldingRange());
    }

    public boolean isDocumentSyncDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getSynchronization());
    }

    public boolean isFormattingDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getFormatting());
    }

    public boolean isRangeFormattingDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getRangeFormatting());
    }

    public boolean isRenameDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getRename());
    }

    public boolean isDocumentSymbolDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getDocumentSymbol());
    }

    public boolean isCodeLensDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getCodeLens());
    }

    public boolean isDefinitionDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getDefinition());
    }

    public boolean isTypeDefinitionDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getTypeDefinition());
    }

    public boolean isReferencesDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getReferences());
    }

    public boolean isCodeActionDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getCodeAction());
    }

    public boolean isHoverDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getHover());
    }

    public boolean isDocumentHighlightDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getDocumentHighlight());
    }

    public boolean isSelectionRangeDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getSelectionRange());
    }

    public boolean isDidChangeWatchedFilesRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.capabilities.getWorkspace().getDidChangeWatchedFiles());
    }

    public boolean isLinkedEditingRangeDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported(this.getTextDocument().getLinkedEditingRange());
    }

    private boolean isDynamicRegistrationSupported(DynamicRegistrationCapabilities capability) {
        return capability != null && capability.getDynamicRegistration() != null && capability.getDynamicRegistration() != false;
    }

    public TextDocumentClientCapabilities getTextDocument() {
        return this.capabilities.getTextDocument();
    }

    public ExtendedClientCapabilities getExtendedCapabilities() {
        return this.extendedCapabilities;
    }

    public boolean isWorkspaceFoldersSupported() {
        return Optional.ofNullable(this.capabilities).map(ClientCapabilities::getWorkspace).map(WorkspaceClientCapabilities::getWorkspaceFolders).filter(Boolean.TRUE::equals).isPresent();
    }

    public boolean shouldLanguageServerExitOnShutdown() {
        if (this.extendedCapabilities == null) {
            return false;
        }
        return this.extendedCapabilities.shouldLanguageServerExitOnShutdown();
    }

    public boolean isWorkDoneProgressSupported() {
        return this.v3Supported && this.capabilities.getWindow() != null && this.capabilities.getWindow().getWorkDoneProgress() != null && this.capabilities.getWindow().getWorkDoneProgress() != false;
    }
}

