import type * as html from 'vscode-html-languageservice';
export * from './baseParse';
export { PugDocument } from './pugDocument';
export interface LanguageService extends ReturnType<typeof getLanguageService> {
}
export declare function getLanguageService(htmlLs: html.LanguageService): {
    parsePugDocument: (pugCode: string) => {
        htmlDocument: html.HTMLDocument;
        docs: import("@volar/language-service/lib/utils/featureWorkers").DocumentsAndMap;
        htmlCode: string;
        mappings: import("@volar/language-service").Mapping<any>[];
        pugTextDocument: html.TextDocument;
        error: {
            code: string;
            msg: string;
            line: number;
            column: number;
            filename: string;
        } | undefined;
        ast: import("./baseParse").Node | undefined;
        emptyLineEnds: number[];
    };
    doComplete: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position, serviceContext: import("@volar/language-service").LanguageServiceContext, documentContext?: html.DocumentContext, options?: html.CompletionConfiguration) => Promise<html.CompletionList | undefined>;
    findDocumentHighlights: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position) => html.DocumentHighlight[] | undefined;
    findDocumentLinks: (pugDoc: import("./pugDocument").PugDocument, docContext: html.DocumentContext) => html.DocumentLink[];
    doHover: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position, options?: html.HoverSettings) => html.Hover | undefined;
    createScanner: (pugDoc: import("./pugDocument").PugDocument, initialOffset?: number) => html.Scanner | undefined;
    getSelectionRanges: (pugDoc: import("./pugDocument").PugDocument, posArr: html.Position[]) => html.SelectionRange[];
    doQuoteComplete: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position, options?: html.CompletionConfiguration) => string | null | undefined;
    getFoldingRanges: (pugDoc: import("./pugDocument").PugDocument) => html.FoldingRange[];
};
//# sourceMappingURL=languageService.d.ts.map