/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.basic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.sitemap.Mapview;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.basic.internal.render.AbstractWidgetRenderer;
import org.openhab.ui.basic.render.RenderException;
import org.openhab.ui.basic.render.WidgetRenderer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class MapviewRenderer
extends AbstractWidgetRenderer {
    private static final String MAP_URL = "//www.openstreetmap.org/export/embed.html?bbox=%lonminus%,%latminus%,%lonplus%,%latplus%&marker=%lat%,%lon%";
    private static final double MAP_ZOOM = 0.01;

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Mapview;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Mapview mapview = (Mapview)w;
        String snippet = this.getSnippet("mapview");
        snippet = this.preprocessSnippet(snippet, (Widget)mapview);
        snippet = this.processColor(w, snippet);
        State state = this.itemUIRegistry.getState((Widget)mapview);
        if (state instanceof PointType) {
            PointType pointState = (PointType)state;
            double latitude = pointState.getLatitude().doubleValue();
            double longitude = pointState.getLongitude().doubleValue();
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)MAP_URL);
            snippet = StringUtils.replace((String)snippet, (String)"%lat%", (String)Double.toString(latitude));
            snippet = StringUtils.replace((String)snippet, (String)"%lon%", (String)Double.toString(longitude));
            snippet = StringUtils.replace((String)snippet, (String)"%lonminus%", (String)Double.toString(longitude - 0.01));
            snippet = StringUtils.replace((String)snippet, (String)"%lonplus%", (String)Double.toString(longitude + 0.01));
            snippet = StringUtils.replace((String)snippet, (String)"%latminus%", (String)Double.toString(latitude - 0.01));
            snippet = StringUtils.replace((String)snippet, (String)"%latplus%", (String)Double.toString(latitude + 0.01));
        } else {
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)"images/map-marker-off.png");
        }
        snippet = StringUtils.replace((String)snippet, (String)"%map_url%", (String)MAP_URL);
        snippet = StringUtils.replace((String)snippet, (String)"%map_zoom%", (String)Double.toString(0.01));
        int height = mapview.getHeight();
        if (height == 0) {
            height = 4;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%height%", (String)Integer.toString(height *= 36));
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

