/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.geometry.PolySweepMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LayerCoverageJob
extends Job {
    private Cell curCell;
    private Job parentJob;
    private int mode;
    private GeometryHandler tree;
    public static final int AREA = 0;
    public static final int MERGE = 1;
    public static final int IMPLANT = 2;
    public static final int NETWORK = 3;
    private final int function;
    private List deleteList;
    private HashMap originalPolygons = new HashMap();
    private Highlighter highlighter;
    private GeometryOnNetwork geoms;
    private Rectangle2D bBox;

    public static GeometryOnNetwork listGeometryOnNetworks(Cell cell, HashSet nets, boolean startJob, int mode) {
        if (cell == null || nets == null || nets.isEmpty()) {
            return null;
        }
        double lambda = 1.0;
        GeometryOnNetwork geoms = new GeometryOnNetwork(cell, nets, lambda, startJob);
        LayerCoverageJob job = new LayerCoverageJob(null, Job.Type.EXAMINE, cell, 3, mode, null, geoms, null);
        if (startJob) {
            job.startJob();
        } else {
            ((Job)job).doIt();
        }
        return geoms;
    }

    public LayerCoverageJob(Job parentJob, Job.Type jobType, Cell cell, int func, int mode, Highlighter highlighter, GeometryOnNetwork geoms, Rectangle2D bBox) {
        super("Layer Coverage on " + cell, User.getUserTool(), jobType, null, null, Job.Priority.USER);
        this.parentJob = parentJob;
        this.curCell = cell;
        this.mode = mode;
        this.tree = GeometryHandler.createGeometryHandler(mode, this.curCell.getTechnology().getNumLayers(), this.curCell.getBounds());
        this.function = func;
        this.deleteList = new ArrayList();
        this.highlighter = highlighter;
        this.geoms = geoms;
        this.bBox = bBox;
        if (func == 0 && this.geoms == null) {
            this.geoms = new GeometryOnNetwork(this.curCell, null, 1.0, true);
        }
        this.setReportExecutionFlag(true);
    }

    public boolean doIt() {
        LayerVisitor visitor = new LayerVisitor(this.parentJob, this.tree, this.deleteList, this.function, this.originalPolygons, this.geoms != null ? this.geoms.nets : null, this.bBox);
        HierarchyEnumerator.enumerateCell(this.curCell, VarContext.globalContext, visitor);
        this.tree.postProcess(true);
        switch (this.function) {
            case 1: 
            case 2: {
                if (this.highlighter != null) {
                    this.highlighter.clear();
                }
                boolean noNewNodes = true;
                boolean isMerge = this.function == 1;
                PolyBase polyB = null;
                Iterator it = this.tree.getKeyIterator();
                while (it.hasNext()) {
                    Layer layer = (Layer)it.next();
                    Collection set = this.tree.getObjects(layer, !isMerge, true);
                    Set polySet = this.function == 2 ? (Set)this.originalPolygons.get(layer) : null;
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        Rectangle2D rect;
                        Point2D[] points;
                        if (this.mode == 1) {
                            PolyQTree.PolyNode qNode = (PolyQTree.PolyNode)i.next();
                            points = qNode.getPoints(false);
                            if (polySet != null) {
                                polyB = new PolyBase(points);
                                polyB.roundPoints();
                            }
                            rect = qNode.getBounds2D();
                        } else {
                            polyB = (PolyBase)i.next();
                            points = polyB.getPoints();
                            rect = polyB.getBounds2D();
                        }
                        if (polySet != null) {
                            Object[] array = polySet.toArray();
                            boolean foundOrigPoly = false;
                            for (int j = 0; j < array.length && !(foundOrigPoly = polyB.polySame((PolyBase)array[j])); ++j) {
                            }
                            if (foundOrigPoly) continue;
                        }
                        Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                        PrimitiveNode priNode = layer.getPureLayerNode();
                        NodeInst node = NodeInst.makeInstance(priNode, center, rect.getWidth(), rect.getHeight(), this.curCell);
                        if (this.highlighter != null) {
                            this.highlighter.addElectricObject(node, this.curCell);
                        }
                        if (isMerge) {
                            node.newVar(NodeInst.TRACE, (Object)points);
                        } else {
                            node.setHardSelect();
                        }
                        noNewNodes = false;
                    }
                }
                if (this.highlighter != null) {
                    this.highlighter.finished();
                }
                it = this.deleteList.iterator();
                while (it.hasNext()) {
                    NodeInst node = (NodeInst)it.next();
                    node.kill();
                }
                if (!noNewNodes) break;
                System.out.println("No new areas added");
                break;
            }
            case 0: 
            case 3: {
                double lambdaSqr = 1.0;
                Rectangle2D bbox = this.curCell.getBounds();
                double totalArea = bbox.getHeight() * bbox.getWidth() / lambdaSqr;
                ArrayList list = new ArrayList(this.tree.getKeySet());
                Collections.sort(list, Layer.layerSort);
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Layer layer = (Layer)it.next();
                    Collection set = this.tree.getObjects(layer, false, true);
                    double layerArea = 0.0;
                    double perimeter = 0.0;
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        if (this.mode == 1) {
                            PolyQTree.PolyNode area = (PolyQTree.PolyNode)i.next();
                            layerArea += area.getArea();
                            perimeter += area.getPerimeter();
                            continue;
                        }
                        PolyBase poly = (PolyBase)i.next();
                        layerArea += poly.getArea();
                        perimeter += poly.getPerimeter();
                    }
                    layerArea /= lambdaSqr;
                    perimeter /= 2.0;
                    if (this.geoms != null) {
                        this.geoms.addLayer(layer, layerArea, perimeter);
                        continue;
                    }
                    System.out.println("Layer " + layer.getName() + " covers " + TextUtils.formatDouble(layerArea) + " square lambda (" + TextUtils.formatDouble(layerArea / totalArea * 100.0, 2) + "%)");
                }
                this.geoms.setTotalArea(totalArea);
                if (this.geoms != null) {
                    this.geoms.print();
                    break;
                }
                System.out.println("Cell is " + TextUtils.formatDouble(totalArea, 2) + " square lambda");
                break;
            }
            default: {
                System.out.println("Error in LayerCoverageJob: function not implemented");
            }
        }
        return true;
    }

    public static class GeometryOnNetwork {
        public final Cell cell;
        protected Set nets;
        private double lambda;
        private boolean printable;
        private ArrayList layers;
        private ArrayList areas;
        private ArrayList halfPerimeters;
        private double totalWire;
        private double totalArea;

        protected GeometryOnNetwork(Cell cell, Set nets, double lambda, boolean printable) {
            this.cell = cell;
            this.nets = nets;
            this.lambda = lambda;
            this.layers = new ArrayList();
            this.areas = new ArrayList();
            this.halfPerimeters = new ArrayList();
            this.printable = printable;
            this.totalWire = 0.0;
            this.totalArea = 0.0;
        }

        public double getTotalWireLength() {
            return this.totalWire;
        }

        protected void setTotalArea(double area) {
            this.totalArea = area;
        }

        private void addLayer(Layer layer, double area, double halfperimeter) {
            this.layers.add(layer);
            this.areas.add(new Double(area));
            this.halfPerimeters.add(new Double(halfperimeter));
            Layer.Function func = layer.getFunction();
            if (func.isPoly() && !func.isGatePoly() || func.isMetal()) {
                this.totalWire += halfperimeter;
            }
        }

        public boolean analyzeCoverage(Rectangle2D bbox, ErrorLogger errorLogger) {
            this.totalArea = bbox.getHeight() * bbox.getWidth() / (this.lambda * this.lambda);
            boolean foundError = false;
            for (int i = 0; i < this.layers.size(); ++i) {
                double minV;
                Layer layer = (Layer)this.layers.get(i);
                Double area = (Double)this.areas.get(i);
                double percentage = area / this.totalArea * 100.0;
                if (!(percentage < (minV = layer.getAreaCoverage()))) continue;
                String msg = "Error area coverage " + layer.getName() + " min value = " + minV + " actual value = " + percentage;
                ErrorLogger.MessageLog err = errorLogger.logError(msg, this.cell, layer.getIndex());
                PolyBase poly = new PolyBase(bbox);
                err.addPoly(poly, true, this.cell);
                foundError = true;
            }
            return foundError;
        }

        public void print() {
            if (!this.printable) {
                return;
            }
            if (this.nets != null) {
                Iterator it = this.nets.iterator();
                while (it.hasNext()) {
                    Network net = (Network)it.next();
                    System.out.println("For " + net + " in " + this.cell + ":");
                }
            }
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = (Layer)this.layers.get(i);
                Double area = (Double)this.areas.get(i);
                Double halfperim = (Double)this.halfPerimeters.get(i);
                double layerArea = area;
                System.out.println("\tLayer " + layer.getName() + ":\t area " + TextUtils.formatDouble(layerArea) + "(" + TextUtils.formatDouble(layerArea / this.totalArea * 100.0, 2) + "%)" + "\t half-perimeter " + TextUtils.formatDouble(halfperim) + "\t ratio " + TextUtils.formatDouble(area / halfperim));
            }
            if (this.totalWire > 0.0) {
                System.out.println("Total wire length = " + TextUtils.formatDouble(this.totalWire / this.lambda));
            }
            if (this.totalArea > 0.0) {
                System.out.println("Total cell area = " + TextUtils.formatDouble(this.totalArea, 2));
            }
        }
    }

    private static class LayerVisitor
    extends HierarchyEnumerator.Visitor {
        private Job parentJob;
        private GeometryHandler tree;
        private int mode;
        private List deleteList;
        private final int function;
        private HashMap originalPolygons;
        private Set netSet;
        private Rectangle2D origBBox;
        private Area origBBoxArea;

        private static boolean isValidFunction(Layer.Function func, int function) {
            switch (function) {
                case 1: 
                case 3: {
                    return true;
                }
                case 2: {
                    return func.isSubstrate();
                }
                case 0: {
                    if (Main.LOCALDEBUGFLAG) {
                        return true;
                    }
                    return func.isPoly() || func.isMetal();
                }
            }
            return false;
        }

        public LayerVisitor(Job job, GeometryHandler t, List delList, int func, HashMap original, Set netSet, Rectangle2D bBox) {
            this.parentJob = job;
            this.tree = t;
            this.deleteList = delList;
            this.function = func;
            this.originalPolygons = original;
            this.netSet = netSet;
            this.origBBox = bBox;
            Area area = this.origBBoxArea = bBox != null ? new Area(this.origBBox) : null;
            this.mode = t instanceof PolySweepMerge ? 2 : (t instanceof PolyMerge ? 0 : 1);
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        private boolean doesIntersectBoundingBox(Rectangle2D rect, HierarchyEnumerator.CellInfo info) {
            if (this.origBBox == null) {
                return true;
            }
            PolyBase polyRect = new PolyBase(rect);
            polyRect.transform(info.getTransformToRoot());
            rect = polyRect.getBounds2D();
            return rect.intersects(this.origBBox);
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.parentJob != null && this.parentJob.checkAbort()) {
                return false;
            }
            Cell curCell = info.getCell();
            Netlist netlist = info.getNetlist();
            if (!this.doesIntersectBoundingBox(curCell.getBounds(), info)) {
                return false;
            }
            boolean found = this.netSet == null;
            Iterator it = netlist.getNetworks();
            while (!found && it.hasNext()) {
                Network aNet;
                Network parentNet = aNet = (Network)it.next();
                HierarchyEnumerator.CellInfo cinfo = info;
                boolean netFound = false;
                while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                    parentNet = cinfo.getNetworkInParent(parentNet);
                    cinfo = cinfo.getParentInfo();
                }
                found = netFound;
            }
            if (!found) {
                return false;
            }
            it = curCell.getArcs();
            while (it.hasNext()) {
                ArcInst arc = (ArcInst)it.next();
                int width = netlist.getBusWidth(arc);
                found = this.netSet == null;
                for (int i = 0; !found && i < width; ++i) {
                    Network parentNet = netlist.getNetwork(arc, i);
                    HierarchyEnumerator.CellInfo cinfo = info;
                    boolean netFound = false;
                    while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                    }
                    found = netFound;
                }
                if (!found) continue;
                ArcProto arcType = arc.getProto();
                Technology tech = arcType.getTechnology();
                Poly[] polyList = tech.getShapeOfArc(arc);
                for (int i = 0; i < polyList.length; ++i) {
                    Poly poly = polyList[i];
                    Layer layer = poly.getLayer();
                    Layer.Function func = layer.getFunction();
                    boolean value = LayerVisitor.isValidFunction(func, this.function);
                    if (!value) continue;
                    poly.transform(info.getTransformToRoot());
                    poly.roundPoints();
                    this.storeOriginalPolygons(layer, poly);
                    Shape pnode = LayerVisitor.cropGeometry(poly, this.origBBoxArea);
                    if (pnode == null) continue;
                    if (this.mode == 1) {
                        pnode = new PolyQTree.PolyNode(poly);
                    }
                    this.tree.add(layer, pnode, this.function == 3);
                }
            }
            return true;
        }

        private void storeOriginalPolygons(Layer layer, PolyBase poly) {
            if (this.function != 2) {
                return;
            }
            HashSet<PolyBase> polySet = (HashSet<PolyBase>)this.originalPolygons.get(layer);
            if (polySet == null) {
                polySet = new HashSet<PolyBase>();
                this.originalPolygons.put(layer, polySet);
            }
            polySet.add(poly);
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst node = no.getNodeInst();
            boolean found = this.netSet == null;
            NodeProto np = node.getProto();
            if (NodeInst.isSpecialNode(node)) {
                return false;
            }
            boolean inside = this.doesIntersectBoundingBox(node.getBounds(), info);
            if (np instanceof Cell) {
                return inside;
            }
            if (!inside) {
                return false;
            }
            Iterator pIt = node.getPortInsts();
            while (!found && pIt.hasNext()) {
                Network oNet;
                PortInst pi = (PortInst)pIt.next();
                PortProto subPP = pi.getPortProto();
                Network parentNet = oNet = info.getNetlist().getNetwork(node, subPP, 0);
                HierarchyEnumerator.CellInfo cinfo = info;
                boolean netFound = false;
                while (!(netFound = this.netSet.contains(parentNet)) && cinfo.getParentInst() != null) {
                    parentNet = cinfo.getNetworkInParent(parentNet);
                    cinfo = cinfo.getParentInfo();
                }
                found = netFound;
            }
            if (!found) {
                return false;
            }
            if (node.isPrimtiveSubstrateNode()) {
                this.deleteList.add(node);
                return false;
            }
            Technology tech = np.getTechnology();
            Poly[] polyList = tech.getShapeOfNode(node);
            AffineTransform transform = node.rotateOut();
            for (int i = 0; i < polyList.length; ++i) {
                Poly poly = polyList[i];
                Layer layer = poly.getLayer();
                Layer.Function func = layer.getFunction();
                boolean value = LayerVisitor.isValidFunction(func, this.function);
                if (!value || poly.getPoints().length < 3) continue;
                poly.transform(transform);
                poly.transform(info.getTransformToRoot());
                poly.roundPoints();
                this.storeOriginalPolygons(layer, poly);
                Shape pnode = LayerVisitor.cropGeometry(poly, this.origBBoxArea);
                if (pnode == null) continue;
                if (this.mode == 1) {
                    pnode = new PolyQTree.PolyNode(pnode);
                }
                this.tree.add(layer, pnode, this.function == 3);
            }
            return true;
        }

        private static Shape cropGeometry(Shape origGeom, Area bBoxArea) {
            Shape pnode = origGeom;
            if (bBoxArea != null) {
                Area tmpA = new Area(pnode);
                tmpA.intersect(bBoxArea);
                if (tmpA.isEmpty()) {
                    return null;
                }
                pnode = tmpA;
            }
            return pnode;
        }
    }
}

