/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ArtworkLook;
import com.sun.electric.tool.user.dialogs.Attributes;
import com.sun.electric.tool.user.dialogs.AttributesTable;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GetInfoArc
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoArc theDialog = null;
    private static ArcInst shownArc = null;
    private static Preferences prefs = Preferences.userNodeForPackage(GetInfoArc.class);
    private String initialName;
    private double initialWidth;
    private boolean initialEasyToSelect;
    private boolean initialRigid;
    private boolean initialFixedAngle;
    private boolean initialSlidable;
    private int initialExtension;
    private int initialDirectional;
    private int initialNegated;
    private String initialColor;
    private EditWindow wnd;
    private AttributesTable attributesTable;
    private List allAttributes;
    private boolean needReload = false;
    private boolean bigger;
    private JLabel angle;
    private JButton apply;
    private JButton attributes;
    private JScrollPane attributesPane;
    private JLabel busSize;
    private JButton cancel;
    private JButton colorAndPattern;
    private JComboBox directionality;
    private JCheckBox easyToSelect;
    private JComboBox extension;
    private JCheckBox fixedAngle;
    private JLabel headLoc;
    private JLabel headNode;
    private JButton headSee;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel length;
    private JButton moreLess;
    private JTextField name;
    private JButton nameProperties;
    private JComboBox negation;
    private JLabel network;
    private JButton ok;
    private JCheckBox rigid;
    private JCheckBox slidable;
    private JLabel tailLoc;
    private JLabel tailNode;
    private JButton tailSee;
    private JLabel type;
    private JTextField width;

    public static void showDialog() {
        if (theDialog == null) {
            TopLevel jf = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame() : null;
            theDialog = new GetInfoArc((Frame)jf, false);
        }
        theDialog.loadInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (this.needReload) {
            this.needReload = false;
            this.loadInfo();
            return;
        }
        if (e.objectChanged(shownArc)) {
            this.loadInfo();
        }
    }

    private GetInfoArc(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        Undo.addDatabaseChangeListener(this);
        this.bigger = prefs.getBoolean("GetInfoArc-bigger", false);
        int buttonSelected = prefs.getInt("GetInfoNode-buttonSelected", 0);
        if (!this.bigger) {
            this.getContentPane().remove(this.jPanel2);
            this.getContentPane().remove(this.jPanel3);
            this.getContentPane().remove(this.attributesPane);
            this.moreLess.setText("More");
            this.pack();
        } else {
            this.moreLess.setText("Less");
        }
        this.negation.addItem("None");
        this.negation.addItem("Head");
        this.negation.addItem("Tail");
        this.negation.addItem("Both");
        this.extension.addItem("Both ends");
        this.extension.addItem("Neither end");
        this.extension.addItem("Head only");
        this.extension.addItem("Tail only");
        this.directionality.addItem("None");
        this.directionality.addItem("Head and Body");
        this.directionality.addItem("Tail and Body");
        this.directionality.addItem("Body only");
        this.directionality.addItem("Head/Tail/Body");
        this.allAttributes = new ArrayList();
        this.attributesTable = new AttributesTable(null, true, false, false);
        this.attributesPane.setViewportView(this.attributesTable);
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    protected void loadInfo() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GetInfoArc.this.doLoadInfo();
                }
            });
            return;
        }
        this.doLoadInfo();
    }

    private void doLoadInfo() {
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        if (this.wnd == null) {
            this.disableDialog();
            return;
        }
        ArcInst ai = null;
        int arcCount = 0;
        Iterator it = this.wnd.getHighlighter().getHighlights().iterator();
        while (it.hasNext()) {
            ElectricObject eobj;
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
            ai = (ArcInst)eobj;
            ++arcCount;
        }
        if (arcCount > 1) {
            ai = null;
        }
        if (ai == null) {
            if (shownArc != null) {
                this.disableDialog();
            }
            return;
        }
        if (!Job.acquireExamineLock(false)) {
            this.needReload = true;
            this.disableDialog();
            return;
        }
        try {
            this.focusClearOnTextField(this.name);
            this.name.setEditable(true);
            this.width.setEditable(true);
            this.easyToSelect.setEnabled(true);
            this.rigid.setEnabled(true);
            this.fixedAngle.setEnabled(true);
            this.slidable.setEnabled(true);
            this.directionality.setEnabled(true);
            this.extension.setEnabled(true);
            this.negation.setEnabled(true);
            this.headSee.setEnabled(true);
            this.tailSee.setEnabled(true);
            this.apply.setEnabled(true);
            this.attributes.setEnabled(true);
            this.initialName = ai.getName();
            this.initialWidth = ai.getWidth();
            this.initialEasyToSelect = !ai.isHardSelect();
            this.initialRigid = ai.isRigid();
            this.initialFixedAngle = ai.isFixedAngle();
            this.initialSlidable = ai.isSlidable();
            this.initialNegated = 0;
            if (ai.isHeadNegated()) {
                this.initialNegated = ai.isTailNegated() ? 3 : 1;
            } else if (ai.isTailNegated()) {
                this.initialNegated = 2;
            }
            this.initialExtension = 0;
            if (!ai.isHeadExtended()) {
                this.initialExtension = !ai.isTailExtended() ? 1 : 3;
            } else if (!ai.isTailExtended()) {
                this.initialExtension = 2;
            }
            this.initialDirectional = 0;
            if (ai.isBodyArrowed() && ai.isHeadArrowed() && !ai.isTailArrowed()) {
                this.initialDirectional = 1;
            }
            if (ai.isBodyArrowed() && !ai.isHeadArrowed() && ai.isTailArrowed()) {
                this.initialDirectional = 2;
            }
            if (ai.isBodyArrowed() && !ai.isHeadArrowed() && !ai.isTailArrowed()) {
                this.initialDirectional = 3;
            }
            if (ai.isBodyArrowed() && ai.isHeadArrowed() && ai.isTailArrowed()) {
                this.initialDirectional = 4;
            }
            this.type.setText(ai.getProto().describe());
            Netlist netlist = ai.getParent().acquireUserNetlist();
            int busWidth = 1;
            String netName = "UNKNOWN";
            if (netlist != null) {
                busWidth = netlist.getBusWidth(ai);
                netName = netlist.getNetworkName(ai);
                if (netName != null && netName.length() > 80) {
                    netName = netName.substring(0, 80) + "...";
                }
            }
            this.network.setText(netName);
            this.name.setText(this.initialName);
            this.width.setText(TextUtils.formatDouble(this.initialWidth - ai.getProto().getWidthOffset()));
            this.length.setText(TextUtils.formatDouble(ai.getLength()));
            this.busSize.setText(Integer.toString(busWidth));
            this.angle.setText("Angle: " + TextUtils.formatDouble((double)ai.getAngle() / 10.0));
            this.easyToSelect.setSelected(this.initialEasyToSelect);
            this.headNode.setText(ai.getHeadPortInst().getNodeInst().describe(true));
            EPoint headPt = ai.getHeadLocation();
            this.headLoc.setText("(" + ((Point2D)headPt).getX() + "," + ((Point2D)headPt).getY() + ")");
            this.tailNode.setText(ai.getTailPortInst().getNodeInst().describe(true));
            EPoint tailPt = ai.getTailLocation();
            this.tailLoc.setText("(" + ((Point2D)tailPt).getX() + "," + ((Point2D)tailPt).getY() + ")");
            this.rigid.setSelected(this.initialRigid);
            this.fixedAngle.setSelected(this.initialFixedAngle);
            this.slidable.setSelected(this.initialSlidable);
            this.negation.setSelectedIndex(this.initialNegated);
            this.extension.setSelectedIndex(this.initialExtension);
            this.directionality.setSelectedIndex(this.initialDirectional);
            this.colorAndPattern.setEnabled(ai.getProto().getTechnology() == Artwork.tech);
            this.allAttributes.clear();
            Iterator it2 = ai.getVariables();
            while (it2.hasNext()) {
                Variable aVar = (Variable)it2.next();
                String name = aVar.getKey().getName();
                if (!name.startsWith("ATTR_")) continue;
                AttributesTable.AttValPair avp = new AttributesTable.AttValPair();
                avp.key = aVar.getKey();
                avp.trueName = aVar.getTrueName();
                avp.value = aVar.getObject().toString();
                avp.code = aVar.isCode();
                this.allAttributes.add(avp);
            }
            this.attributesTable.setEnabled(this.allAttributes.size() != 0);
            this.attributesTable.setElectricObject(ai);
            this.pack();
            Job.releaseExamineLock();
        }
        catch (Error e) {
            Job.releaseExamineLock();
            throw e;
        }
        shownArc = ai;
        this.focusOnTextField(this.name);
    }

    private void disableDialog() {
        this.type.setText("");
        this.network.setText("");
        this.name.setEditable(false);
        this.name.setText("");
        this.width.setEditable(false);
        this.width.setText("");
        this.length.setText("");
        this.busSize.setText("");
        this.angle.setText("Angle:");
        this.easyToSelect.setEnabled(false);
        this.headNode.setText("");
        this.headLoc.setText("");
        this.headSee.setEnabled(false);
        this.tailNode.setText("");
        this.tailLoc.setText("");
        this.tailSee.setEnabled(false);
        this.rigid.setEnabled(false);
        this.rigid.setSelected(false);
        this.fixedAngle.setEnabled(false);
        this.fixedAngle.setSelected(false);
        this.slidable.setEnabled(false);
        this.slidable.setSelected(false);
        this.negation.setEnabled(false);
        this.extension.setEnabled(false);
        this.directionality.setEnabled(false);
        this.apply.setEnabled(false);
        this.attributes.setEnabled(false);
        this.colorAndPattern.setEnabled(false);
        this.attributesTable.setElectricObject(null);
        this.attributesTable.setEnabled(false);
        shownArc = null;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.type = new JLabel();
        this.jLabel3 = new JLabel();
        this.network = new JLabel();
        this.jLabel5 = new JLabel();
        this.name = new JTextField();
        this.jLabel6 = new JLabel();
        this.width = new JTextField();
        this.jLabel7 = new JLabel();
        this.busSize = new JLabel();
        this.jLabel9 = new JLabel();
        this.angle = new JLabel();
        this.easyToSelect = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.headNode = new JLabel();
        this.jLabel13 = new JLabel();
        this.headLoc = new JLabel();
        this.headSee = new JButton();
        this.jLabel15 = new JLabel();
        this.tailNode = new JLabel();
        this.jLabel17 = new JLabel();
        this.tailLoc = new JLabel();
        this.tailSee = new JButton();
        this.nameProperties = new JButton();
        this.length = new JLabel();
        this.jPanel2 = new JPanel();
        this.rigid = new JCheckBox();
        this.slidable = new JCheckBox();
        this.fixedAngle = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.extension = new JComboBox();
        this.jLabel8 = new JLabel();
        this.directionality = new JComboBox();
        this.jLabel10 = new JLabel();
        this.negation = new JComboBox();
        this.jPanel3 = new JPanel();
        this.attributes = new JButton();
        this.colorAndPattern = new JButton();
        this.jPanel4 = new JPanel();
        this.ok = new JButton();
        this.cancel = new JButton();
        this.apply = new JButton();
        this.moreLess = new JButton();
        this.attributesPane = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Arc Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoArc.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Type:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.type.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.type, gridBagConstraints);
        this.jLabel3.setText("Network:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.network.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.network, gridBagConstraints);
        this.jLabel5.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.name, gridBagConstraints);
        this.jLabel6.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.width.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.width, gridBagConstraints);
        this.jLabel7.setText("Bus size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.busSize.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.busSize, gridBagConstraints);
        this.jLabel9.setText("Length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.angle.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.angle, gridBagConstraints);
        this.easyToSelect.setText("Easy to Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.easyToSelect, gridBagConstraints);
        this.jLabel11.setText("Head:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        this.headNode.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.headNode, gridBagConstraints);
        this.jLabel13.setText("At:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel1.add((Component)this.jLabel13, gridBagConstraints);
        this.headLoc.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.headLoc, gridBagConstraints);
        this.headSee.setText("See");
        this.headSee.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.headSeeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.headSee, gridBagConstraints);
        this.jLabel15.setText("Tail:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel15, gridBagConstraints);
        this.tailNode.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.tailNode, gridBagConstraints);
        this.jLabel17.setText("At:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel1.add((Component)this.jLabel17, gridBagConstraints);
        this.tailLoc.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.tailLoc, gridBagConstraints);
        this.tailSee.setText("See");
        this.tailSee.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.tailSeeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.tailSee, gridBagConstraints);
        this.nameProperties.setText("Props.");
        this.nameProperties.setMinimumSize(new Dimension(71, 20));
        this.nameProperties.setPreferredSize(new Dimension(71, 20));
        this.nameProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.namePropertiesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.nameProperties, gridBagConstraints);
        this.length.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.length, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.rigid.setText("Rigid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.rigid, gridBagConstraints);
        this.slidable.setText("Slidable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.slidable, gridBagConstraints);
        this.fixedAngle.setText("Fixed-angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.fixedAngle, gridBagConstraints);
        this.jLabel4.setText("End Extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.extension, gridBagConstraints);
        this.jLabel8.setText("Directionality:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.directionality, gridBagConstraints);
        this.jLabel10.setText("Negation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.negation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.attributes.setText("Attributes");
        this.attributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.attributesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 4, 4);
        this.jPanel3.add((Component)this.attributes, gridBagConstraints);
        this.colorAndPattern.setText("Color and Pattern...");
        this.colorAndPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.colorAndPatternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.colorAndPattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.ok, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.cancel, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.apply, gridBagConstraints);
        this.moreLess.setText("More");
        this.moreLess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoArc.this.moreLessActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.moreLess, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.attributesPane.setMinimumSize(new Dimension(22, 100));
        this.attributesPane.setPreferredSize(new Dimension(22, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.attributesPane, gridBagConstraints);
        this.pack();
    }

    private void colorAndPatternActionPerformed(ActionEvent evt) {
        ArtworkLook.showArtworkLookDialog();
    }

    private void namePropertiesActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ArcInst ai = shownArc;
        Name arcName = ai.getNameKey();
        if (!arcName.isTempname() && this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addText(ai, ai.getParent(), null, arcName);
            highlighter.addElectricObject(ai, ai.getParent());
            highlighter.finished();
            GetInfoText.showDialog();
        }
    }

    private void attributesActionPerformed(ActionEvent evt) {
        Attributes.showDialog();
    }

    private void moreLessActionPerformed(ActionEvent evt) {
        boolean bl = this.bigger = !this.bigger;
        if (this.bigger) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.attributesPane, gridBagConstraints);
            this.moreLess.setText("Less");
        } else {
            this.getContentPane().remove(this.jPanel2);
            this.getContentPane().remove(this.jPanel3);
            this.getContentPane().remove(this.attributesPane);
            this.moreLess.setText("More");
        }
        this.pack();
    }

    private void tailSeeActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ArcInst ai = shownArc;
        NodeInst ni = shownArc.getTailPortInst().getNodeInst();
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addElectricObject(ni, ni.getParent());
            highlighter.addElectricObject(ai, ai.getParent());
            highlighter.finished();
        }
    }

    private void headSeeActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ArcInst ai = shownArc;
        NodeInst ni = shownArc.getHeadPortInst().getNodeInst();
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addElectricObject(ni, ni.getParent());
            highlighter.addElectricObject(ai, ai.getParent());
            highlighter.finished();
        }
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (shownArc == null) {
            return;
        }
        ChangeArc job = new ChangeArc(shownArc, this);
        this.attributesTable.applyChanges();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        prefs.putBoolean("GetInfoArc-bigger", this.bigger);
        this.setVisible(false);
    }

    private static class ChangeArc
    extends Job {
        ArcInst ai;
        GetInfoArc dialog;

        protected ChangeArc(ArcInst ai, GetInfoArc dialog) {
            super("Modify Arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ai = ai;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            double currentWidth;
            int currentNegated;
            int currentExtend;
            int currentDirectional;
            boolean currentSlidable;
            boolean currentFixedAngle;
            boolean currentRigid;
            boolean currentEasyToSelect;
            boolean changed = false;
            String currentName = this.dialog.name.getText().trim();
            if (!currentName.equals(this.dialog.initialName)) {
                this.dialog.initialName = new String(currentName);
                if (currentName.length() == 0) {
                    currentName = null;
                }
                this.ai.setName(currentName);
                changed = true;
            }
            if ((currentEasyToSelect = this.dialog.easyToSelect.isSelected()) != this.dialog.initialEasyToSelect) {
                this.ai.setHardSelect(!currentEasyToSelect);
                this.dialog.initialEasyToSelect = currentEasyToSelect;
            }
            if ((currentRigid = this.dialog.rigid.isSelected()) != this.dialog.initialRigid) {
                this.ai.setRigid(currentRigid);
                this.dialog.initialRigid = currentRigid;
                changed = true;
            }
            if ((currentFixedAngle = this.dialog.fixedAngle.isSelected()) != this.dialog.initialFixedAngle) {
                this.ai.setFixedAngle(currentFixedAngle);
                this.dialog.initialFixedAngle = currentFixedAngle;
                changed = true;
            }
            if ((currentSlidable = this.dialog.slidable.isSelected()) != this.dialog.initialSlidable) {
                this.ai.setSlidable(currentSlidable);
                this.dialog.initialSlidable = currentSlidable;
                changed = true;
            }
            if ((currentDirectional = this.dialog.directionality.getSelectedIndex()) != this.dialog.initialDirectional) {
                switch (currentDirectional) {
                    case 0: {
                        this.ai.setBodyArrowed(false);
                        this.ai.setHeadArrowed(false);
                        this.ai.setTailArrowed(false);
                        break;
                    }
                    case 1: {
                        this.ai.setBodyArrowed(true);
                        this.ai.setHeadArrowed(true);
                        this.ai.setTailArrowed(false);
                        break;
                    }
                    case 2: {
                        this.ai.setBodyArrowed(true);
                        this.ai.setHeadArrowed(false);
                        this.ai.setTailArrowed(true);
                        break;
                    }
                    case 3: {
                        this.ai.setBodyArrowed(true);
                        this.ai.setHeadArrowed(false);
                        this.ai.setTailArrowed(false);
                        break;
                    }
                    case 4: {
                        this.ai.setBodyArrowed(true);
                        this.ai.setHeadArrowed(true);
                        this.ai.setTailArrowed(true);
                    }
                }
                this.dialog.initialDirectional = currentDirectional;
                changed = true;
            }
            if ((currentExtend = this.dialog.extension.getSelectedIndex()) != this.dialog.initialExtension) {
                switch (currentExtend) {
                    case 0: {
                        this.ai.setHeadExtended(true);
                        this.ai.setTailExtended(true);
                        break;
                    }
                    case 1: {
                        this.ai.setHeadExtended(false);
                        this.ai.setTailExtended(false);
                        break;
                    }
                    case 2: {
                        this.ai.setHeadExtended(true);
                        this.ai.setTailExtended(false);
                        break;
                    }
                    case 3: {
                        this.ai.setHeadExtended(false);
                        this.ai.setTailExtended(true);
                    }
                }
                this.dialog.initialExtension = currentExtend;
                changed = true;
            }
            if ((currentNegated = this.dialog.negation.getSelectedIndex()) != this.dialog.initialNegated) {
                switch (currentNegated) {
                    case 0: {
                        this.ai.setHeadNegated(false);
                        this.ai.setTailNegated(false);
                        break;
                    }
                    case 1: {
                        this.ai.setHeadNegated(true);
                        this.ai.setTailNegated(false);
                        break;
                    }
                    case 2: {
                        this.ai.setHeadNegated(false);
                        this.ai.setTailNegated(true);
                        break;
                    }
                    case 3: {
                        this.ai.setHeadNegated(true);
                        this.ai.setTailNegated(true);
                    }
                }
                this.dialog.initialNegated = currentNegated;
                changed = true;
            }
            if (!DBMath.doublesEqual(currentWidth = TextUtils.atof(this.dialog.width.getText()) + this.ai.getProto().getWidthOffset(), this.dialog.initialWidth) || changed) {
                this.ai.modify(currentWidth - this.dialog.initialWidth, 0.0, 0.0, 0.0, 0.0);
                this.dialog.initialWidth = currentWidth;
            }
            return true;
        }
    }
}

