/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SkillTab
extends PreferencePanel {
    private JList skillLayerList;
    private DefaultListModel skillLayerModel;
    private HashMap skillLayers;
    private Technology curTech;
    private JLabel jLabel11;
    private JPanel skill;
    private JCheckBox skillFlattenHierarchy;
    private JCheckBox skillGDSNameLimit;
    private JTextField skillLayerName;
    private JScrollPane skillLayerPane;
    private JLabel skillNoSkill;
    private JCheckBox skillNoSubCells;
    private JLabel skillTechnology;

    public SkillTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.skill;
    }

    public String getName() {
        return "Skill";
    }

    public void init() {
        this.skillLayerModel = new DefaultListModel();
        this.skillLayerList = new JList(this.skillLayerModel);
        this.skillLayerList.setSelectionMode(0);
        this.skillLayerPane.setViewportView(this.skillLayerList);
        this.skillLayerList.clearSelection();
        this.skillLayerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SkillTab.this.skillClickLayer();
            }
        });
        this.skillLayerModel.clear();
        this.skillLayers = new HashMap();
        this.curTech = Technology.getCurrent();
        this.skillTechnology.setText("Skill layers for technology: " + this.curTech.getTechName());
        Iterator it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            String skillLayerName = layer.getSkillLayer();
            if (skillLayerName == null) {
                skillLayerName = "";
            }
            this.skillLayers.put(layer, skillLayerName);
            this.skillLayerModel.addElement(layer.getName() + " (" + skillLayerName + ")");
        }
        this.skillLayerList.setSelectedIndex(0);
        this.skillClickLayer();
        this.skillLayerName.getDocument().addDocumentListener(new LayerDocumentListener(this));
        this.skillNoSubCells.setSelected(IOTool.isSkillExcludesSubcells());
        this.skillFlattenHierarchy.setSelected(IOTool.isSkillFlattensHierarchy());
        this.skillGDSNameLimit.setSelected(IOTool.isSkillGDSNameLimit());
        if (!IOTool.hasSkill()) {
            this.skillNoSkill.setText("SKILL OUTPUT IS NOT INSTALLED!");
        }
    }

    private void skillLayerChanged() {
        Layer layer;
        String str = (String)this.skillLayerList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((layer = this.curTech.findLayer(str)) == null) {
            return;
        }
        String layerName = this.skillLayerName.getText();
        this.skillLayers.put(layer, layerName);
        String newLine = layer.getName() + " (" + layerName + ")";
        int index = this.skillLayerList.getSelectedIndex();
        this.skillLayerModel.set(index, newLine);
    }

    private void skillClickLayer() {
        Layer layer;
        String str = (String)this.skillLayerList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((layer = this.curTech.findLayer(str)) == null) {
            return;
        }
        String shownValue = (String)this.skillLayers.get(layer);
        this.skillLayerName.setText(shownValue);
    }

    public void term() {
        boolean currBoolean = this.skillNoSubCells.isSelected();
        if (currBoolean != IOTool.isSkillExcludesSubcells()) {
            IOTool.setSkillExcludesSubcells(currBoolean);
        }
        if ((currBoolean = this.skillFlattenHierarchy.isSelected()) != IOTool.isSkillFlattensHierarchy()) {
            IOTool.setSkillFlattensHierarchy(currBoolean);
        }
        if ((currBoolean = this.skillGDSNameLimit.isSelected()) != IOTool.isSkillGDSNameLimit()) {
            IOTool.setSkillGDSNameLimit(currBoolean);
        }
        Iterator it = this.skillLayers.keySet().iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            String layerName = (String)this.skillLayers.get(layer);
            if (layer.getSkillLayer().equals(layerName)) continue;
            layer.setSkillLayer(layerName);
        }
    }

    private void initComponents() {
        this.skill = new JPanel();
        this.skillLayerPane = new JScrollPane();
        this.skillLayerName = new JTextField();
        this.jLabel11 = new JLabel();
        this.skillNoSubCells = new JCheckBox();
        this.skillFlattenHierarchy = new JCheckBox();
        this.skillNoSkill = new JLabel();
        this.skillTechnology = new JLabel();
        this.skillGDSNameLimit = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SkillTab.this.closeDialog(evt);
            }
        });
        this.skill.setLayout(new GridBagLayout());
        this.skillLayerPane.setMinimumSize(new Dimension(150, 150));
        this.skillLayerPane.setPreferredSize(new Dimension(150, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillLayerPane, gridBagConstraints);
        this.skillLayerName.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillLayerName, gridBagConstraints);
        this.jLabel11.setText("SKILL Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.jLabel11, gridBagConstraints);
        this.skillNoSubCells.setText("Do not include subcells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillNoSubCells, gridBagConstraints);
        this.skillFlattenHierarchy.setText("Flatten hierarchy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillFlattenHierarchy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.skill.add((Component)this.skillNoSkill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillTechnology, gridBagConstraints);
        this.skillGDSNameLimit.setText("GDS name limit (32 chars)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.skill.add((Component)this.skillGDSNameLimit, gridBagConstraints);
        this.getContentPane().add((Component)this.skill, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class LayerDocumentListener
    implements DocumentListener {
        SkillTab dialog;

        LayerDocumentListener(SkillTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }
    }
}

