/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.NodeCursor;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InteriorNodeCursor<K extends Serializable & Comparable, V extends Serializable, S extends Serializable>
extends NodeCursor<K, V, S> {
    private final int INTERIOR_HEADER_SIZE;
    private final int INTERIOR_ENTRY_SIZE;
    private final int INTERIOR_MAX_BUCKETS;
    private final int SIZEOF_SUMMARY;
    private int numbuckets;

    public InteriorNodeCursor(BTree<K, V, S> bt) {
        super(bt);
        this.SIZEOF_SUMMARY = bt.ao == null ? 0 : bt.ao.getSize();
        this.INTERIOR_HEADER_SIZE = 8;
        this.INTERIOR_ENTRY_SIZE = bt.uk.getSize() + this.SIZEOF_SUMMARY + 4 + 4;
        this.INTERIOR_MAX_BUCKETS = (this.ps.getPageSize() - this.INTERIOR_HEADER_SIZE - 4 - this.SIZEOF_SUMMARY) / this.INTERIOR_ENTRY_SIZE;
    }

    public int insertNewBucketAt(int idx) {
        assert (!this.isFull());
        assert (idx != 0);
        if (idx < this.getNumBuckets()) {
            System.arraycopy(this.getBuf(), this.INTERIOR_HEADER_SIZE + (idx - 1) * this.INTERIOR_ENTRY_SIZE, this.getBuf(), this.INTERIOR_HEADER_SIZE + idx * this.INTERIOR_ENTRY_SIZE, this.endOfBuf() - (this.INTERIOR_HEADER_SIZE + (idx - 1) * this.INTERIOR_ENTRY_SIZE));
        }
        this.setNumBuckets(this.getNumBuckets() + 1);
        return this.INTERIOR_HEADER_SIZE + idx * this.INTERIOR_ENTRY_SIZE - this.bt.uk.getSize();
    }

    public static boolean isInteriorNode(byte[] buf) {
        return UnboxedInt.instance.deserializeInt(buf, 4) != 0;
    }

    @Override
    public int getMaxBuckets() {
        return this.INTERIOR_MAX_BUCKETS;
    }

    @Override
    public void initBuf(CachingPageStorage.CachedPage cp, boolean isRightMost) {
        super.setBuf(cp);
        this.setRightMost(isRightMost);
    }

    @Override
    public int getNumBuckets() {
        return this.numbuckets;
    }

    @Override
    protected void setNumBuckets(int num) {
        this.numbuckets = num;
        this.bt.ui.serializeInt(this.numbuckets, this.getBuf(), 4);
    }

    @Override
    public void setBuf(CachingPageStorage.CachedPage cp) {
        super.setBuf(cp);
        this.numbuckets = this.bt.ui.deserializeInt(this.getBuf(), 4);
    }

    public void initRoot() {
        this.bt.rootpage = this.ps.createPage();
        super.setBuf(this.ps.getPage(this.bt.rootpage, false));
        this.setNumBuckets(1);
        this.setRightMost(true);
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    protected int endOfBuf() {
        return this.INTERIOR_HEADER_SIZE + this.getNumBuckets() * this.INTERIOR_ENTRY_SIZE - this.SIZEOF_SUMMARY - 4;
    }

    public int getBucketPageId(int idx) {
        return this.bt.ui.deserializeInt(this.getBuf(), this.INTERIOR_HEADER_SIZE + this.INTERIOR_ENTRY_SIZE * idx);
    }

    public void setBucketPageId(int idx, int pageid) {
        this.bt.ui.serializeInt(pageid, this.getBuf(), this.INTERIOR_HEADER_SIZE + this.INTERIOR_ENTRY_SIZE * idx);
    }

    @Override
    public int compare(byte[] key, int key_ofs, int keynum) {
        if (keynum <= 0) {
            return 1;
        }
        if (keynum >= this.getNumBuckets()) {
            return -1;
        }
        return this.bt.uk.compare(key, key_ofs, this.getBuf(), this.INTERIOR_HEADER_SIZE + keynum * this.INTERIOR_ENTRY_SIZE - this.bt.uk.getSize());
    }

    @Override
    protected void scoot(byte[] oldBuf, int endOfBuf, int splitPoint) {
        int len = this.INTERIOR_HEADER_SIZE + this.INTERIOR_ENTRY_SIZE * splitPoint;
        System.arraycopy(oldBuf, len, this.getBuf(), this.INTERIOR_HEADER_SIZE, endOfBuf - len);
    }

    @Override
    public void getKey(int keynum, byte[] key, int key_ofs) {
        System.arraycopy(this.getBuf(), this.INTERIOR_HEADER_SIZE + keynum * this.INTERIOR_ENTRY_SIZE - this.bt.uk.getSize(), key, key_ofs, this.bt.uk.getSize());
    }

    public void setNumValsBelowBucket(int idx, int num) {
        if (idx == this.getNumBuckets() - 1) {
            throw new RuntimeException("InteriorNodeCursors don't store numValuesBelowBucket() for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets() - 1);
        this.bt.ui.serializeInt(num, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.SIZEOF_SUMMARY + this.INTERIOR_ENTRY_SIZE * idx);
    }

    @Override
    public int getNumValsBelowBucket(int bucket) {
        if (bucket >= this.getNumBuckets()) {
            return 0;
        }
        if (bucket == this.getNumBuckets() - 1) {
            throw new RuntimeException("InteriorNodeCursors don't store numValuesBelowBucket() for their last bucket");
        }
        return this.bt.ui.deserializeInt(this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.SIZEOF_SUMMARY + this.INTERIOR_ENTRY_SIZE * bucket);
    }

    public void multiplySummaryCommutative(int idx, byte[] buf, int ofs) {
        if (idx == this.getNumBuckets() - 1 && this.isRightMost()) {
            throw new RuntimeException("RightMost InteriorNodeCursors don't store a summary value for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets());
        this.bt.ao.multiply(buf, ofs, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx, this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx);
    }

    @Override
    public void getSummary(int idx, byte[] buf, int ofs) {
        if (idx == this.getNumBuckets() - 1 && this.isRightMost()) {
            throw new RuntimeException("RightMost InteriorNodeCursors don't store a summary value for their last bucket");
        }
        assert (idx >= 0 && idx < this.getNumBuckets());
        System.arraycopy(this.getBuf(), this.INTERIOR_HEADER_SIZE + 4 + this.INTERIOR_ENTRY_SIZE * idx, buf, ofs, this.bt.ao.getSize());
    }
}

