/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.InvisibleLayerConfiguration;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayerTab
extends JPanel
implements DragSourceListener,
DragGestureListener {
    private JList layerList;
    private JList configurationList;
    private DefaultListModel layerListModel;
    private DefaultListModel configurationModel;
    private List<Layer> layersInList;
    private DragSource dragSource;
    private boolean loading;
    private boolean layerDrawing;
    private LayerVisibility lv;
    private InvisibleLayerConfiguration invLayerConfigs = InvisibleLayerConfiguration.getOnly();
    private static final ImageIcon iconVisNew = Resources.getResource(LayerTab.class, "IconVisNew.gif");
    private static final ImageIcon iconVisSet = Resources.getResource(LayerTab.class, "IconVisSet.gif");
    private static final ImageIcon iconVisRename = Resources.getResource(LayerTab.class, "IconVisRename.gif");
    private static final ImageIcon iconVisDelete = Resources.getResource(LayerTab.class, "IconVisDelete.gif");
    private JCheckBox annotationText;
    private JCheckBox arcText;
    private JCheckBox cellText;
    private JScrollPane configurationPane;
    private JButton deleteConfiguration;
    private JCheckBox exportText;
    private JCheckBox instanceNames;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane layerPane;
    private JButton makeInvisible;
    private JButton makeVisible;
    private JButton newConfiguration;
    private JCheckBox nodeText;
    private JSlider opacitySlider;
    private JCheckBox portText;
    private JButton renameConfiguration;
    private JButton resetOpacity;
    private JButton selectAll;
    private JButton setConfiguration;
    private JComboBox technology;
    private JButton toggleHighlight;
    private JButton unhighlightAll;

    public LayerTab(WindowFrame wf) {
        this.initComponents();
        this.newConfiguration.setIcon(iconVisNew);
        this.newConfiguration.setText(null);
        Dimension minWid = new Dimension(iconVisNew.getIconWidth() + 4, iconVisNew.getIconHeight() + 4);
        this.newConfiguration.setMinimumSize(minWid);
        this.newConfiguration.setPreferredSize(minWid);
        this.setConfiguration.setIcon(iconVisSet);
        this.setConfiguration.setText(null);
        minWid = new Dimension(iconVisSet.getIconWidth() + 4, iconVisSet.getIconHeight() + 4);
        this.setConfiguration.setMinimumSize(minWid);
        this.setConfiguration.setPreferredSize(minWid);
        this.renameConfiguration.setIcon(iconVisRename);
        this.renameConfiguration.setText(null);
        minWid = new Dimension(iconVisRename.getIconWidth() + 4, iconVisRename.getIconHeight() + 4);
        this.renameConfiguration.setMinimumSize(minWid);
        this.renameConfiguration.setPreferredSize(minWid);
        this.deleteConfiguration.setIcon(iconVisDelete);
        this.deleteConfiguration.setText(null);
        minWid = new Dimension(iconVisDelete.getIconWidth() + 4, iconVisDelete.getIconHeight() + 4);
        this.deleteConfiguration.setMinimumSize(minWid);
        this.deleteConfiguration.setPreferredSize(minWid);
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(2);
        this.layerPane.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LayerTab.this.apply(e);
            }
        });
        this.configurationModel = new DefaultListModel();
        this.configurationList = new JList(this.configurationModel);
        this.configurationPane.setViewportView(this.configurationList);
        this.configurationList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LayerTab.this.useConfiguration(e);
            }
        });
        this.showConfigurations();
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.layerList, 1, this);
        new DropTarget(this.layerList, 0x40000000, new LayerTabTreeDropTarget(), true);
        this.nodeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.arcText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.portText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.exportText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.annotationText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.instanceNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.cellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.update();
            }
        });
        this.opacitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                LayerTab.this.sliderChanged();
            }
        });
        this.technology.setLightWeightPopupEnabled(false);
        this.loadTechnologies(true);
        this.updateLayersTab();
        this.technology.addActionListener(new WindowFrame.CurTechControlListener(wf));
    }

    public void finished() {
        this.layersInList.clear();
        this.layersInList = null;
    }

    public void loadTechnologies(boolean makeCurrent) {
        Technology cur = Technology.getCurrent();
        if (!makeCurrent || cur == null) {
            cur = Technology.findTechnology((String)this.technology.getSelectedItem());
        }
        this.loading = true;
        this.technology.removeAllItems();
        this.lv = LayerVisibility.getLayerVisibility();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.technology.addItem(tech.getTechName());
        }
        this.setSelectedTechnology(cur);
        this.loading = false;
    }

    private void renameConfiguration() {
        String newName;
        int index = this.configurationList.getSelectedIndex();
        if (index < 0) {
            Job.getUserInterface().showErrorMessage("First select a configuration name to rename.", "No Configuration Selected");
            return;
        }
        String cName = (String)this.configurationList.getSelectedValue();
        if (cName == null) {
            return;
        }
        if (cName.startsWith("* ")) {
            cName = cName.substring(2);
        }
        if ((newName = Job.getUserInterface().askForInput("New Name for Configuration:", "Rename Visibility Configuration", cName)) == null) {
            return;
        }
        if (this.invLayerConfigs.exists(newName)) {
            Job.getUserInterface().showErrorMessage("There is already a configuration with that name.  Choose another.", "Duplicate Configuration Name");
            return;
        }
        this.invLayerConfigs.renameConfiguration(cName, newName);
        this.showConfigurations();
    }

    private void setConfiguration() {
        int index = this.configurationList.getSelectedIndex();
        if (index < 0) {
            Job.getUserInterface().showErrorMessage("First select a configuration name to set.", "No Configuration Selected");
            return;
        }
        String cName = (String)this.configurationList.getSelectedValue();
        if (cName == null) {
            return;
        }
        if (cName.startsWith("* ")) {
            cName = cName.substring(2);
        }
        this.updateConfiguration(cName, this.invLayerConfigs.getConfigurationHardwiredIndex(cName));
    }

    private void newConfiguration() {
        String cName = Job.getUserInterface().askForInput("New Configuration Name:", "Save New Visibility Configuration", "Config");
        if (cName == null) {
            return;
        }
        if (this.invLayerConfigs.exists(cName)) {
            Job.getUserInterface().showErrorMessage("There is already a configuration with that name.  Choose another.", "Duplicate Configuration Name");
            return;
        }
        this.updateConfiguration(cName, -1);
    }

    private void updateConfiguration(String cName, int hardWiredIndex) {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        ArrayList<Layer> invis = new ArrayList<Layer>();
        Iterator<Layer> lIt = tech.getLayers();
        while (lIt.hasNext()) {
            Layer layer = lIt.next();
            if (this.lv.isVisible(layer)) continue;
            invis.add(layer);
        }
        this.invLayerConfigs.addConfiguration(cName, hardWiredIndex, tech, invis);
        this.showConfigurations();
    }

    private void deleteThisConfiguration() {
        int index = this.configurationList.getSelectedIndex();
        if (index < 0) {
            Job.getUserInterface().showErrorMessage("First select a configuration name to delete.", "No Configuration Selected");
            return;
        }
        String cName = (String)this.configurationList.getSelectedValue();
        if (cName == null) {
            return;
        }
        if (cName.startsWith("* ")) {
            cName = cName.substring(2);
        }
        this.invLayerConfigs.deleteConfiguration(cName);
        this.showConfigurations();
    }

    private void useConfiguration(MouseEvent e) {
        String cName = (String)this.configurationList.getSelectedValue();
        if (cName == null) {
            return;
        }
        if (cName.startsWith("* ")) {
            cName = cName.substring(2);
        }
        if (e.getClickCount() == 2) {
            this.setInvisibleLayerConfiguration(cName);
        }
    }

    public void setInvisibleLayerConfiguration(String cName) {
        int hardIndex = this.invLayerConfigs.getConfigurationHardwiredIndex(cName);
        Technology tech = this.invLayerConfigs.getConfigurationTechnology(cName);
        if (tech == null) {
            if (hardIndex >= 0) {
                this.setVisibilityLevel(hardIndex);
            }
            return;
        }
        Set<Layer> invisibleLayers = this.invLayerConfigs.getConfigurationValue(cName);
        HashMap<Layer, Boolean> visibilityChange = new HashMap<Layer, Boolean>();
        Iterator<Layer> lIt = tech.getLayers();
        while (lIt.hasNext()) {
            Layer layer;
            visibilityChange.put(layer, !invisibleLayers.contains(layer = lIt.next()));
        }
        this.lv.setVisible(visibilityChange);
        this.updateLayersTab();
        this.update();
    }

    private void showConfigurations() {
        this.configurationModel.clear();
        List<String> configs = this.invLayerConfigs.getConfigurationNames();
        for (String key : configs) {
            if (this.invLayerConfigs.getConfigurationHardwiredIndex(key) >= 0 && this.invLayerConfigs.getConfigurationTechnology(key) != null) {
                key = "* " + key;
            }
            this.configurationModel.addElement(key);
        }
    }

    public void setSelectedTechnology(Technology tech) {
        if (tech == null) {
            System.out.println("Selecting a null technology");
        } else {
            this.technology.setSelectedItem(tech.getTechName());
        }
    }

    public void setDisplayAlgorithm(boolean layerDrawing) {
        boolean changed = this.layerDrawing != layerDrawing;
        this.layerDrawing = layerDrawing;
        if (changed) {
            this.updateLayersTab();
        }
    }

    public void updateLayersTab() {
        if (this.loading) {
            return;
        }
        GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();
        this.nodeText.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE));
        this.arcText.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC));
        this.portText.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT));
        this.exportText.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT));
        this.annotationText.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ANNOTATION));
        this.instanceNames.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.INSTANCE));
        this.cellText.setSelected(gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL));
        Technology tech = Technology.getCurrent();
        this.setSelectedTechnology(tech);
        this.layerListModel.clear();
        this.layersInList = new ArrayList<Layer>();
        if (tech != null) {
            List<Layer> savedOrder = this.lv.getSavedLayerOrder(tech);
            List<Layer> allLayers = tech.getLayersSortedByHeight();
            ArrayList<Layer> dummyLayers = new ArrayList<Layer>();
            for (Layer lay : allLayers) {
                if (!lay.getFunction().isDummy() && !lay.getFunction().isDummyExclusion()) continue;
                dummyLayers.add(lay);
            }
            for (Layer lay : dummyLayers) {
                allLayers.remove(lay);
            }
            for (Layer lay : dummyLayers) {
                allLayers.add(lay);
            }
            if (tech.isLayout()) {
                allLayers.add(Generic.tech().drcLay);
                allLayers.add(Generic.tech().afgLay);
            }
            if (savedOrder == null) {
                savedOrder = allLayers;
            }
            for (Layer layer : savedOrder) {
                if (layer.getTechnology() != Generic.tech() && layer.isPseudoLayer()) continue;
                this.layersInList.add(layer);
                this.layerListModel.addElement(this.lineName(layer));
            }
            for (Layer layer : allLayers) {
                if (savedOrder.contains(layer) || layer.getTechnology() != Generic.tech() && layer.isPseudoLayer()) continue;
                this.layersInList.add(layer);
                this.layerListModel.addElement(this.lineName(layer));
            }
            this.layerList.setSelectedIndex(0);
        }
        this.opacitySlider.setVisible(this.layerDrawing);
        this.resetOpacity.setVisible(this.layerDrawing);
    }

    private String lineName(Layer layer) {
        StringBuffer layerName = new StringBuffer();
        if (this.lv.isVisible(layer)) {
            layerName.append("\u2713 ");
        } else {
            layerName.append("  ");
        }
        if (layer.isPseudoLayer()) {
            layerName.append(" (for pins)");
        }
        boolean layerHighlighted = this.lv.isHighlighted(layer);
        layerName.append(layer.getName());
        if (layerHighlighted) {
            layerName.append(" (HIGHLIGHTED)");
        }
        if (this.layerDrawing) {
            layerName.append(" (" + TextUtils.formatDouble(this.lv.getOpacity(layer), 2) + ")");
        }
        return layerName.toString();
    }

    private void apply(MouseEvent e) {
        Layer layer;
        int[] indices = this.layerList.getSelectedIndices();
        if (indices.length == 1 && this.layerDrawing && (layer = this.getSelectedLayer(indices[0])) != null) {
            double opacity = this.lv.getOpacity(layer);
            double range = this.opacitySlider.getMaximum() - this.opacitySlider.getMinimum();
            int newValue = this.opacitySlider.getMinimum() + (int)(range * opacity);
            this.opacitySlider.setValue(newValue);
        }
        if (e.getClickCount() == 2) {
            boolean[] visible = new boolean[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                int line = indices[i];
                visible[i] = !this.isLineChecked(line);
            }
            this.setVisibility(indices, visible);
            this.update();
        }
    }

    private void sliderChanged() {
        int[] indices = this.layerList.getSelectedIndices();
        if (indices.length != 1) {
            return;
        }
        Layer layer = this.getSelectedLayer(indices[0]);
        if (layer == null) {
            return;
        }
        int sliderValue = this.opacitySlider.getValue() - this.opacitySlider.getMinimum();
        double range = this.opacitySlider.getMaximum() - this.opacitySlider.getMinimum();
        double newOpacity = (double)sliderValue / range;
        this.lv.setOpacity(layer, newOpacity);
        this.layerListModel.set(indices[0], this.lineName(layer));
        this.opacityChanged();
    }

    private void opacityChanged() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.opacityChanged();
            LayerTab layerTab = wf.getLayersTab();
            if (layerTab != this) continue;
            wnd.repaint();
        }
    }

    private void clearAllHighlight() {
        for (int i = 0; i < this.layerListModel.size(); ++i) {
            this.changeHighlighted(i, 0);
        }
    }

    private void toggleHighlight() {
        int[] indices = this.layerList.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            int line = indices[i];
            this.changeHighlighted(line, 1);
        }
    }

    private void selectAll() {
        int len = this.layerListModel.size();
        int[] indices = new int[len];
        for (int i = 0; i < len; ++i) {
            indices[i] = i;
        }
        this.layerList.setSelectedIndices(indices);
    }

    private void setVisibility(boolean on) {
        int[] indices = this.layerList.getSelectedIndices();
        boolean[] visible = new boolean[indices.length];
        Arrays.fill(visible, on);
        this.setVisibility(indices, visible);
        this.update();
    }

    private boolean isLineChecked(int i) {
        String s = (String)this.layerListModel.get(i);
        return s.charAt(0) != ' ';
    }

    private Layer getSelectedLayer(int i) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null && (layer = Generic.tech().findLayer(name)) == null) {
            System.out.println("Can't find " + name);
        }
        return layer;
    }

    private void setVisibility(int[] indices, boolean[] visible) {
        Layer layer;
        int line;
        int i;
        HashMap<Layer, Boolean> visibilityChange = new HashMap<Layer, Boolean>();
        assert (indices.length == visible.length);
        for (i = 0; i < indices.length; ++i) {
            line = indices[i];
            layer = this.getSelectedLayer(line);
            if (layer == null) continue;
            visibilityChange.put(layer, visible[i]);
        }
        this.lv.setVisible(visibilityChange);
        for (i = 0; i < indices.length; ++i) {
            line = indices[i];
            layer = this.getSelectedLayer(line);
            if (layer == null) continue;
            this.layerListModel.set(line, this.lineName(layer));
        }
    }

    public void setVisibilityLevel(int level) {
        Technology tech = Technology.getCurrent();
        int numMetals = tech.getNumMetals();
        System.out.println("Setting for level " + level);
        int len = this.layerListModel.size();
        int[] indices = new int[len];
        boolean[] visible = new boolean[len];
        Layer metalLayer = null;
        if (level == 0) {
            for (int i = 0; i < len; ++i) {
                indices[i] = i;
                visible[i] = true;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                boolean b;
                indices[i] = i;
                Layer layer = this.getSelectedLayer(i);
                Layer.Function func = layer.getFunction();
                if (func.isContact() || func.isDiff() || func.isGatePoly() || func.isImplant() || func.isMetal() || func.isPoly() || func.isWell() || func.isDummy() || func.isDummyExclusion()) {
                    b = false;
                    if (level == 2 && layer.getFunction() == Layer.Function.GATE) {
                        b = true;
                    }
                    if (level == 2 && (layer.getFunction() == Layer.Function.DIFF || layer.getFunction() == Layer.Function.DIFFN || layer.getFunction() == Layer.Function.DIFFP)) {
                        b = true;
                    }
                    if (level == 1 && (layer.getFunction().getLevel() <= 1 || layer.getFunction() == Layer.Function.ART)) {
                        b = true;
                    }
                    if (layer.getFunction().getLevel() == level) {
                        b = true;
                        if (layer.getFunction().isMetal()) {
                            metalLayer = layer;
                        }
                    }
                    if (layer.getFunction().getLevel() == level - 1 || level == 0) {
                        b = true;
                    }
                    if (layer.getFunction().isContact() && layer.getFunction().getLevel() == level - 1) {
                        b = false;
                    }
                    visible[i] = b;
                    continue;
                }
                if (func == Layer.Function.ART || func == Layer.Function.OVERGLASS) {
                    b = false;
                    if (level == 0) {
                        b = true;
                    }
                    if (func == Layer.Function.ART && level <= 1) {
                        b = true;
                    }
                    if (func == Layer.Function.OVERGLASS && level >= numMetals) {
                        b = true;
                    }
                    visible[i] = b;
                    continue;
                }
                visible[i] = this.lv.isVisible(layer);
            }
        }
        this.setVisibility(indices, visible);
        if (metalLayer != null) {
            // empty if block
        }
        this.update();
    }

    private void changeHighlighted(int i, int how) {
        Layer layer;
        String name = (String)this.layerListModel.get(i);
        if (name != null) {
            name = name.substring(2);
        }
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        int spacePos = name.indexOf(32);
        if (spacePos >= 0) {
            name = name.substring(0, spacePos);
        }
        if ((layer = tech.findLayer(name)) == null) {
            System.out.println("Can't find " + name);
            return;
        }
        boolean newState = false;
        if (how == 1) {
            newState = !this.lv.isHighlighted(layer);
        }
        this.lv.setHighlighted(layer, newState);
        this.layerListModel.set(i, this.lineName(layer));
        this.update();
    }

    private void update() {
        GraphicsPreferences oldGp;
        boolean visibilityChanged = this.lv.clearChanged();
        GraphicsPreferences gp = oldGp = UserInterfaceMain.getGraphicsPreferences();
        gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.NODE, this.nodeText.isSelected());
        gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.ARC, this.arcText.isSelected());
        gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.PORT, this.portText.isSelected());
        gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT, this.exportText.isSelected());
        gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.ANNOTATION, this.annotationText.isSelected());
        gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.INSTANCE, this.instanceNames.isSelected());
        boolean textVisChanged = (gp = gp.withTextVisibilityOn(AbstractTextDescriptor.TextType.CELL, this.cellText.isSelected())) != oldGp;
        UserInterfaceMain.setGraphicsPreferences(gp);
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            LayerTab lt = wf.getLayersTab();
            if (lt == this) continue;
            lt.updateLayersTab();
        }
        if (visibilityChanged || textVisChanged) {
            LayerTab.layerVisibilityChanged(this.lv, !visibilityChanged);
        }
    }

    private static void layerVisibilityChanged(LayerVisibility lv, boolean onlyText) {
        if (!onlyText) {
            VectorCache.theCache.clearFadeImages();
        }
        AbstractDrawing.clearSubCellCache(false);
        EditWindow.setLayerVisibilityAll(lv);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        StringSelection transferable = new StringSelection("" + this.layerList.getSelectedIndex());
        this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    private void initComponents() {
        this.layerPane = new JScrollPane();
        this.technology = new JComboBox();
        this.selectAll = new JButton();
        this.makeVisible = new JButton();
        this.makeInvisible = new JButton();
        this.jPanel1 = new JPanel();
        this.unhighlightAll = new JButton();
        this.toggleHighlight = new JButton();
        this.jPanel2 = new JPanel();
        this.cellText = new JCheckBox();
        this.arcText = new JCheckBox();
        this.annotationText = new JCheckBox();
        this.instanceNames = new JCheckBox();
        this.exportText = new JCheckBox();
        this.portText = new JCheckBox();
        this.nodeText = new JCheckBox();
        this.opacitySlider = new JSlider();
        this.resetOpacity = new JButton();
        this.jPanel3 = new JPanel();
        this.newConfiguration = new JButton();
        this.deleteConfiguration = new JButton();
        this.configurationPane = new JScrollPane();
        this.setConfiguration = new JButton();
        this.renameConfiguration = new JButton();
        this.setLayout(new GridBagLayout());
        this.setName("");
        this.layerPane.setMinimumSize(new Dimension(100, 150));
        this.layerPane.setOpaque(false);
        this.layerPane.setPreferredSize(new Dimension(100, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.75;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.layerPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.technology, gridBagConstraints);
        this.selectAll.setText("Select All");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.add((Component)this.selectAll, gridBagConstraints);
        this.makeVisible.setText("Visible");
        this.makeVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.makeVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(1, 4, 1, 1);
        this.add((Component)this.makeVisible, gridBagConstraints);
        this.makeInvisible.setText("Invisible");
        this.makeInvisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.makeInvisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(1, 1, 1, 4);
        this.add((Component)this.makeInvisible, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Highlighting"));
        this.unhighlightAll.setText("Clear");
        this.unhighlightAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.unhighlightAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel1.add((Component)this.unhighlightAll, gridBagConstraints);
        this.toggleHighlight.setText("Toggle");
        this.toggleHighlight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.toggleHighlightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel1.add((Component)this.toggleHighlight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Text Visibility"));
        this.cellText.setText("Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.cellText, gridBagConstraints);
        this.arcText.setText("Arc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.arcText, gridBagConstraints);
        this.annotationText.setText("Annotation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.annotationText, gridBagConstraints);
        this.instanceNames.setText("Instance names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.instanceNames, gridBagConstraints);
        this.exportText.setText("Export");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.exportText, gridBagConstraints);
        this.portText.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.portText, gridBagConstraints);
        this.nodeText.setText("Node");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel2.add((Component)this.nodeText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.opacitySlider, gridBagConstraints);
        this.resetOpacity.setText("Reset Opacity");
        this.resetOpacity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.resetOpacityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 1, 4);
        this.add((Component)this.resetOpacity, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Visibility Configurations"));
        this.newConfiguration.setText("N");
        this.newConfiguration.setToolTipText("Create New Visibility Configuration");
        this.newConfiguration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.newConfigurationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel3.add((Component)this.newConfiguration, gridBagConstraints);
        this.deleteConfiguration.setText("D");
        this.deleteConfiguration.setToolTipText("Delete or Reset Selected Visibility Configuration");
        this.deleteConfiguration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.deleteConfigurationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel3.add((Component)this.deleteConfiguration, gridBagConstraints);
        this.configurationPane.setMinimumSize(new Dimension(100, 90));
        this.configurationPane.setPreferredSize(new Dimension(100, 90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel3.add((Component)this.configurationPane, gridBagConstraints);
        this.setConfiguration.setText("S");
        this.setConfiguration.setToolTipText("Save Visibility in Currently Selected Configuration");
        this.setConfiguration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.setConfigurationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel3.add((Component)this.setConfiguration, gridBagConstraints);
        this.renameConfiguration.setText("R");
        this.renameConfiguration.setToolTipText("Rename Selected Visibility Configuration");
        this.renameConfiguration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerTab.this.renameConfigurationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.jPanel3.add((Component)this.renameConfiguration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void renameConfigurationActionPerformed(ActionEvent evt) {
        this.renameConfiguration();
    }

    private void setConfigurationActionPerformed(ActionEvent evt) {
        this.setConfiguration();
    }

    private void deleteConfigurationActionPerformed(ActionEvent evt) {
        this.deleteThisConfiguration();
    }

    private void newConfigurationActionPerformed(ActionEvent evt) {
        this.newConfiguration();
    }

    private void resetOpacityActionPerformed(ActionEvent evt) {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.lv.resetOpacity(tech);
        this.updateLayersTab();
        this.opacityChanged();
    }

    private void toggleHighlightActionPerformed(ActionEvent evt) {
        this.toggleHighlight();
    }

    private void unhighlightAllActionPerformed(ActionEvent evt) {
        this.clearAllHighlight();
    }

    private void makeInvisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(false);
    }

    private void makeVisibleActionPerformed(ActionEvent evt) {
        this.setVisibility(true);
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private class LayerTabTreeDropTarget
    implements DropTargetListener {
        private Rectangle lastDrawn = null;

        private LayerTabTreeDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            DropTarget dt = (DropTarget)e.getSource();
            if (dt.getComponent() == LayerTab.this.layerList) {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            DropTarget dt = (DropTarget)e.getSource();
            if (dt.getComponent() != LayerTab.this.layerList) {
                return;
            }
            e.acceptDrag(e.getDropAction());
            this.eraseDragImage();
            int index = LayerTab.this.layerList.locationToIndex(e.getLocation());
            Rectangle path = LayerTab.this.layerList.getCellBounds(index, index);
            if (path == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)LayerTab.this.layerList.getGraphics();
            g2.setColor(Color.RED);
            g2.drawRect(path.x, path.y, path.width - 1, 1);
            this.lastDrawn = path;
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragExit(DropTargetEvent e) {
            this.eraseDragImage();
        }

        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            this.eraseDragImage();
            String text = null;
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            if (flavors.length > 0 && flavors[0].isFlavorTextType()) {
                try {
                    text = (String)dtde.getTransferable().getTransferData(flavors[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (text == null) {
                return;
            }
            int start = TextUtils.atoi(text);
            int end = LayerTab.this.layerList.locationToIndex(dtde.getLocation());
            Layer moveIt = (Layer)LayerTab.this.layersInList.get(start);
            LayerTab.this.layersInList.remove(start);
            if (start < end) {
                --end;
            }
            LayerTab.this.layersInList.add(end, moveIt);
            LayerTab.this.layerListModel.clear();
            for (Layer layer : LayerTab.this.layersInList) {
                LayerTab.this.layerListModel.addElement(LayerTab.this.lineName(layer));
            }
            LayerTab.this.layerList.setSelectedIndex(end);
            Technology tech = Technology.getCurrent();
            LayerTab.this.lv.setSavedLayerOrder(tech, LayerTab.this.layersInList);
            dtde.dropComplete(false);
        }

        private void eraseDragImage() {
            if (this.lastDrawn == null) {
                return;
            }
            LayerTab.this.layerList.paintImmediately(this.lastDrawn);
            this.lastDrawn = null;
        }
    }
}

