/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import com.sun.electric.database.geometry.bool.PointsSorter;
import java.io.DataOutputStream;
import java.io.IOException;

public class DeltaMerge {
    private static final Segment segLast = new Segment();
    private Segment segPool;
    private Segment chain;
    private int[] inpA = new int[1];
    private int inpC;
    private int[] outA = new int[1];
    private int outC;
    private PointsSorter ps;
    private int x;

    public DeltaMerge() {
        this.chain = new Segment();
        this.chain.next = segLast;
        this.chain.y = Integer.MIN_VALUE;
    }

    public int loop(PointsSorter ps, DataOutputStream out) {
        try {
            this.ps = ps;
            int totalOutPoints = 0;
            while (this.getLine()) {
                this.scanLine();
                totalOutPoints += this.outC;
                this.printOut(out);
                this.printSegments();
                this.checkSegments();
            }
            out.writeBoolean(false);
            return totalOutPoints;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printOut(DataOutputStream out) throws IOException {
        if (this.outC == 0) {
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.x);
        out.writeInt(this.outC);
        for (int i = 0; i < this.outC; ++i) {
            int outVal = this.outA[i];
            out.writeInt(outVal);
        }
    }

    private boolean getLine() {
        PointsSorter.ScanLine scanLine = this.ps.fix();
        if (scanLine == null) {
            return false;
        }
        this.x = scanLine.x;
        this.inpA = scanLine.y;
        this.inpC = scanLine.len;
        return true;
    }

    private void printSegments() {
        Segment cp = this.chain;
        while (cp.next != segLast) {
            assert (cp.y < cp.next.y);
            assert (cp.val >= 0);
            cp = cp.next;
        }
    }

    private void checkSegments() {
        assert (this.chain.y == Integer.MIN_VALUE);
        assert (this.chain.val == 0);
        Segment cp = this.chain;
        while (cp.next != segLast) {
            assert (cp.y < cp.next.y);
            assert (cp.val >= 0);
            cp = cp.next;
        }
        assert (DeltaMerge.segLast.y == Integer.MAX_VALUE);
        assert (DeltaMerge.segLast.val == 0);
    }

    private void scanLine() {
        assert (this.inpC > 0);
        int inpStep = 0;
        int outStep = 0;
        Segment cp = this.chain;
        this.resetOut();
        for (int inpPos = 0; inpPos < this.inpC; ++inpPos) {
            int newOutStep;
            int newO;
            int oldO;
            Segment p;
            int y = this.inpA[inpPos * 2 + 0];
            int df = this.inpA[inpPos * 2 + 1];
            assert (df != 0);
            assert (cp.y < y);
            if (inpStep == 0) {
                while (cp.next.y < y) {
                    cp = cp.next;
                }
            } else {
                while (cp.next.y < y) {
                    p = cp.next;
                    oldO = p.val == 0 ? 0 : 1;
                    p.val += inpStep;
                    newO = p.val == 0 ? 0 : 1;
                    newOutStep = newO - oldO;
                    if (newOutStep != outStep) {
                        this.putPointOut(p.y, newOutStep - outStep);
                        outStep = newOutStep;
                    }
                    cp = p;
                }
            }
            assert (cp.y < y && y <= cp.next.y);
            if (cp.next.y > y) {
                p = this.newSegment(cp.next);
                p.y = y;
                p.val = cp.val - inpStep;
                cp.next = p;
            } else {
                p = cp.next;
            }
            inpStep += df;
            assert (p.y == y);
            oldO = p.val == 0 ? 0 : 1;
            p.val += inpStep;
            newO = p.val == 0 ? 0 : 1;
            newOutStep = newO - oldO;
            if (newOutStep != outStep) {
                this.putPointOut(y, newOutStep - outStep);
                outStep = newOutStep;
            }
            if (cp.val == p.val) {
                cp.next = p.next;
                this.dispSegment(p);
            } else {
                cp = p;
            }
            assert (cp.y <= y);
        }
        assert (inpStep == 0);
    }

    private void resetOut() {
        this.outC = 0;
    }

    private void putPointOut(int y, int val) {
        if (this.outC >= this.outA.length) {
            int[] newOutA = new int[this.outA.length * 2];
            System.arraycopy(this.outA, 0, newOutA, 0, this.outA.length);
            this.outA = newOutA;
        }
        if (val == 1) {
            this.outA[this.outC++] = y << 1 | 1;
        } else if (val == -1) {
            this.outA[this.outC++] = y << 1;
        } else if (val == 2) {
            this.outA[this.outC++] = y << 1 | 1;
            this.putPointOut(y, 1);
        } else if (val == -2) {
            this.outA[this.outC++] = y << 1;
            this.putPointOut(y, -1);
        } else {
            throw new AssertionError();
        }
    }

    private Segment newSegment(Segment next) {
        Segment result;
        if (this.segPool == null) {
            result = new Segment();
        } else {
            result = this.segPool;
            this.segPool = this.segPool.next;
        }
        result.next = next;
        return result;
    }

    private void dispSegment(Segment p) {
        p.next = this.segPool;
        this.segPool = p;
    }

    static {
        DeltaMerge.segLast.y = Integer.MAX_VALUE;
    }

    private static class Segment {
        private Segment next;
        private int y;
        private int val;

        private Segment() {
        }
    }
}

