/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.compaction.Compaction;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.TextUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class CompactionTest
extends AbstractTest {
    public CompactionTest(String name) {
        super(name, true, false);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new CompactionTest("Regular1"));
        list.add(new CompactionTest("Regular2"));
        list.add(new CompactionTest("Regular3"));
        list.add(new CompactionTest("Spread"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Compaction/output/";
    }

    public boolean Regular1() {
        return this.test("compactionTest1", false);
    }

    public boolean Regular2() {
        return this.test("compactionTest2", false);
    }

    public boolean Regular3() {
        return this.test("compactionTest3", false);
    }

    public boolean Spread() {
        return this.test("spreadTest1", true);
    }

    private boolean test(String cellName, boolean spreading) {
        String testParameter = this.createMessageOutput();
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        URL fileURL = TextUtils.makeURLToFile(CompactionTest.dataDir(this.getRegressionPath(), testParameter) + "compactionTests.jelib");
        String libName = "compactionTests";
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            lib = LibraryFiles.readLibrary(ep, fileURL, libName, FileType.JELIB, true);
        }
        if (lib == null) {
            System.out.println("Library " + libName + " not found");
            return false;
        }
        Cell lay = lib.findNodeProto(cellName + "{lay}");
        if (lay == null) {
            System.out.println("Cell " + cellName + "{lay} not found");
            return false;
        }
        Compaction.compactNow(lay, spreading, new AbstractTest.CompareJob(lay));
        return true;
    }
}

