/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.dialogs.OptionReconcile;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class Pref {
    public static final int BOOLEAN = 0;
    public static final int INTEGER = 1;
    public static final int LONG = 2;
    public static final int DOUBLE = 3;
    public static final int STRING = 4;
    private String name;
    private int type;
    private Preferences prefs;
    private Meaning meaning;
    protected Object cachedObj;
    protected Object factoryObj;
    private static List allPrefs = new ArrayList();
    private static Map meaningVariablesThatChanged;

    protected Pref() {
    }

    protected void initBoolean(String name, Preferences prefs, boolean factory) {
        this.name = name;
        this.prefs = prefs;
        this.type = 0;
        this.meaning = null;
        this.factoryObj = new Integer(factory ? 1 : 0);
        this.cachedObj = prefs != null ? new Integer(prefs.getBoolean(name, factory) ? 1 : 0) : new Integer(factory ? 1 : 0);
        allPrefs.add(this);
    }

    public static Pref makeBooleanPref(String name, Preferences prefs, boolean factory) {
        Pref pref = new Pref();
        pref.initBoolean(name, prefs, factory);
        return pref;
    }

    protected void initInt(String name, Preferences prefs, int factory) {
        this.name = name;
        this.prefs = prefs;
        this.type = 1;
        this.meaning = null;
        this.factoryObj = new Integer(factory);
        this.cachedObj = prefs != null ? new Integer(prefs.getInt(name, factory)) : new Integer(factory);
        allPrefs.add(this);
    }

    public static Pref makeIntPref(String name, Preferences prefs, int factory) {
        Pref pref = new Pref();
        pref.initInt(name, prefs, factory);
        return pref;
    }

    protected void initLong(String name, Preferences prefs, long factory) {
        this.name = name;
        this.prefs = prefs;
        this.type = 2;
        this.meaning = null;
        this.factoryObj = new Long(factory);
        this.cachedObj = prefs != null ? new Long(prefs.getLong(name, factory)) : new Long(factory);
        allPrefs.add(this);
    }

    public static Pref makeLongPref(String name, Preferences prefs, long factory) {
        Pref pref = new Pref();
        pref.initLong(name, prefs, factory);
        return pref;
    }

    protected void initDouble(String name, Preferences prefs, double factory) {
        this.name = name;
        this.prefs = prefs;
        this.type = 3;
        this.meaning = null;
        this.factoryObj = new Double(factory);
        this.cachedObj = prefs != null ? new Double(prefs.getDouble(name, factory)) : new Double(factory);
        allPrefs.add(this);
    }

    public static Pref makeDoublePref(String name, Preferences prefs, double factory) {
        Pref pref = new Pref();
        pref.initDouble(name, prefs, factory);
        return pref;
    }

    protected void initString(String name, Preferences prefs, String factory) {
        this.name = name;
        this.prefs = prefs;
        this.type = 4;
        this.meaning = null;
        this.factoryObj = new String(factory);
        this.cachedObj = prefs != null ? new String(prefs.get(name, factory)) : new String(factory);
        allPrefs.add(this);
    }

    public static Pref makeStringPref(String name, Preferences prefs, String factory) {
        Pref pref = new Pref();
        pref.initString(name, prefs, factory);
        return pref;
    }

    public boolean getBoolean() {
        return (Integer)this.cachedObj != 0;
    }

    public int getInt() {
        return (Integer)this.cachedObj;
    }

    public long getLong() {
        return (Long)this.cachedObj;
    }

    public double getDouble() {
        return (Double)this.cachedObj;
    }

    public String getString() {
        return (String)this.cachedObj;
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public boolean getBooleanFactoryValue() {
        return (Integer)this.factoryObj != 0;
    }

    public int getIntFactoryValue() {
        return (Integer)this.factoryObj;
    }

    public long getLongFactoryValue() {
        return (Long)this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public String getStringFactoryValue() {
        return (String)this.factoryObj;
    }

    public String getPrefName() {
        return this.name;
    }

    public Object getValue() {
        return this.cachedObj;
    }

    public int getType() {
        return this.type;
    }

    public Meaning getMeaning() {
        return this.meaning;
    }

    public void setSideEffect() {
    }

    public void setBoolean(boolean v) {
        boolean cachedBool;
        boolean bl = cachedBool = (Integer)this.cachedObj != 0;
        if (v != cachedBool) {
            this.cachedObj = new Integer(v ? 1 : 0);
            if (this.prefs != null) {
                this.prefs.putBoolean(this.name, v);
                this.flushOptions();
            }
        }
        this.setSideEffect();
    }

    public void setInt(int v) {
        int cachedInt = (Integer)this.cachedObj;
        if (v != cachedInt) {
            this.cachedObj = new Integer(v);
            if (this.prefs != null) {
                this.prefs.putInt(this.name, v);
                this.flushOptions();
            }
        }
        this.setSideEffect();
    }

    public void setLong(long v) {
        long cachedLong = (Long)this.cachedObj;
        if (v != cachedLong) {
            this.cachedObj = new Long(v);
            if (this.prefs != null) {
                this.prefs.putLong(this.name, v);
                this.flushOptions();
            }
        }
        this.setSideEffect();
    }

    public boolean setDouble(double v) {
        double cachedDouble = (Double)this.cachedObj;
        boolean changed = false;
        if (v != cachedDouble) {
            this.cachedObj = new Double(v);
            if (this.prefs != null) {
                this.prefs.putDouble(this.name, v);
                this.flushOptions();
            }
            changed = true;
        }
        this.setSideEffect();
        return changed;
    }

    public void setString(String str) {
        String cachedString = (String)this.cachedObj;
        if (!str.equals(cachedString)) {
            this.cachedObj = new String(str);
            if (this.prefs != null) {
                this.prefs.put(this.name, str);
                this.flushOptions();
            }
        }
        this.setSideEffect();
    }

    public Meaning attachToObject(Object ownerObj, String location, String description) {
        if (this.meaning == null) {
            this.meaning = new Meaning(ownerObj, this, location, description);
        } else {
            System.out.println("Meaning " + this.name + " already attached to " + ownerObj);
        }
        return this.meaning;
    }

    public static Meaning getMeaningVariable(Object ownerObj, String name) {
        Iterator it = allPrefs.iterator();
        while (it.hasNext()) {
            Pref pref = (Pref)it.next();
            if (pref.meaning == null || pref.meaning.ownerObj != ownerObj || !pref.name.equals(name)) continue;
            return pref.meaning;
        }
        return null;
    }

    public static List getMeaningVariables(Object ownerObj) {
        ArrayList<Pref> prefs = new ArrayList<Pref>();
        Iterator it = allPrefs.iterator();
        while (it.hasNext()) {
            Pref pref = (Pref)it.next();
            if (pref.meaning == null || ownerObj != null && pref.meaning.ownerObj != ownerObj || pref.cachedObj.equals(pref.factoryObj)) continue;
            prefs.add(pref);
        }
        Collections.sort(prefs, new TextUtils.PrefsByName());
        return prefs;
    }

    public static void initMeaningVariableGathering() {
        meaningVariablesThatChanged = new HashMap();
    }

    public static void changedMeaningVariable(Meaning meaning, Object value) {
        meaningVariablesThatChanged.put(meaning, value);
    }

    public static void reconcileMeaningVariables(String libName) {
        Iterator it = allPrefs.iterator();
        while (it.hasNext()) {
            Pref pref = (Pref)it.next();
            if (pref.meaning == null) continue;
            pref.meaning.marked = false;
        }
        ArrayList<Meaning> meaningsToReconcile = new ArrayList<Meaning>();
        Iterator it2 = meaningVariablesThatChanged.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            Meaning meaning = (Meaning)entry.getKey();
            Object value = entry.getValue();
            meaning.marked = true;
            if (DBMath.objectsReallyEqual(value, ((Meaning)meaning).pref.cachedObj)) continue;
            meaning.setDesiredValue(value);
            if (!meaning.isValidOption()) continue;
            meaningsToReconcile.add(meaning);
        }
        it2 = allPrefs.iterator();
        while (it2.hasNext()) {
            Pref pref = (Pref)((Object)it2.next());
            if (pref.meaning == null || pref.meaning.marked || DBMath.objectsReallyEqual(pref.cachedObj, pref.factoryObj)) continue;
            pref.meaning.setDesiredValue(pref.factoryObj);
            if (!pref.meaning.isValidOption()) continue;
            meaningsToReconcile.add(pref.meaning);
        }
        if (meaningsToReconcile.size() == 0) {
            return;
        }
        if (Main.BATCHMODE) {
            it2 = meaningsToReconcile.iterator();
            block9: while (it2.hasNext()) {
                Meaning meaning = (Meaning)((Object)it2.next());
                Pref pref = meaning.getPref();
                Object obj = meaning.getDesiredValue();
                switch (pref.getType()) {
                    case 0: {
                        pref.setBoolean((Integer)obj != 0);
                        break;
                    }
                    case 1: {
                        pref.setInt((Integer)obj);
                        break;
                    }
                    case 3: {
                        if (obj instanceof Double) {
                            pref.setDouble((Double)obj);
                            break;
                        }
                        if (!(obj instanceof Float)) break;
                        pref.setDouble(((Float)obj).floatValue());
                        break;
                    }
                    case 4: {
                        pref.setString((String)obj);
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                System.out.println("Meaning variable " + ((Meaning)meaning).pref.name + " on " + meaning.ownerObj + " changed to " + obj);
            }
            return;
        }
        OptionReconcile dialog = new OptionReconcile((Frame)TopLevel.getCurrentJFrame(), true, meaningsToReconcile, libName);
        dialog.setVisible(true);
    }

    private void flushOptions() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            System.out.println("Failed to save " + this.name + " options");
        }
    }

    public static class Meaning {
        private Object ownerObj;
        private Variable.Key key;
        private boolean valid;
        private Object desiredValue;
        private Pref pref;
        private String description;
        private String location;
        private boolean marked;
        private String[] trueMeaning;

        Meaning(Object ownerObj, Pref pref, String location, String description) {
            this.ownerObj = ownerObj;
            this.key = ElectricObject.newKey(pref.name);
            this.pref = pref;
            this.location = location;
            this.description = description;
            this.valid = true;
        }

        public Pref getPref() {
            return this.pref;
        }

        public Variable.Key getKey() {
            return this.key;
        }

        public Object getOwnerObject() {
            return this.ownerObj;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDescription() {
            return this.description;
        }

        public void setValidOption(boolean valid) {
            this.valid = valid;
        }

        public boolean isValidOption() {
            return this.valid;
        }

        public void setTrueMeaning(String[] trueMeaning) {
            this.trueMeaning = trueMeaning;
        }

        public String[] getTrueMeaning() {
            return this.trueMeaning;
        }

        private void setDesiredValue(Object desiredValue) {
            this.desiredValue = desiredValue;
        }

        public Object getDesiredValue() {
            return this.desiredValue;
        }
    }
}

