/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetlister1;
import com.sun.electric.tool.logicaleffort.LENetlister2;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.ui.EditWindow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LETool
extends Tool {
    private static LETool tool = new LETool();
    private static final boolean DEBUG = false;
    private static final Pattern celecDefaultNamePattern = Pattern.compile("^(\\D+)(\\d+)$");
    private static AnalyzeCell lastLEJobExecuted = null;
    private static double DEFAULT_GLOBALFANOUT = 4.7;
    private static double DEFAULT_EPSILON = 0.001;
    private static int DEFAULT_MAXITER = 30;
    private static double DEFAULT_KEEPERRATIO = 0.1;
    private static Pref cacheUseLocalSettings = Pref.makeBooleanSetting("UseLocalSettings", LETool.tool.prefs, tool, tool.getProjectSettings(), null, "Logical Effort Tab", "Use Local Settings from Cell", true);
    private static Pref cacheGlobalFanout = Pref.makeDoubleSetting("GlobalFanout", LETool.tool.prefs, tool, tool.getProjectSettings(), null, "Logical Effort Tab", "Global Fanout", DEFAULT_GLOBALFANOUT);
    private static Pref cacheConvergenceEpsilon = Pref.makeDoubleSetting("ConvergenceEpsilon", LETool.tool.prefs, tool, tool.getProjectSettings(), null, "Logical Effort Tab", "Convergence Epsilon", DEFAULT_EPSILON);
    private static Pref cacheMaxIterations = Pref.makeIntSetting("MaxIterations", LETool.tool.prefs, tool, tool.getProjectSettings(), null, "Logical Effort Tab", "Maximum Iterations", DEFAULT_MAXITER);
    private static Pref cacheKeeperRatio = Pref.makeDoubleSetting("KeeperRatio", LETool.tool.prefs, tool, tool.getProjectSettings(), null, "Logical Effort Tab", "Keeper Ratio", DEFAULT_KEEPERRATIO);

    private LETool() {
        super("logeffort");
    }

    public static LETool getLETool() {
        return tool;
    }

    public void init() {
        EvalJavaBsh.evalJavaBsh.setVariable("LE", tool);
    }

    public Object getdrive() throws VarContext.EvalException {
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            throw new VarContext.EvalException("getdrive(): Not enough hierarchy");
        }
        VarContext context = EvalJavaBsh.evalJavaBsh.getCurrentContext();
        if (context == null) {
            throw new VarContext.EvalException("getdrive(): null VarContext");
        }
        Nodable ni = (Nodable)info;
        Object[] val = null;
        if (ni instanceof NodeInst && ni.getNameKey().busWidth() > 1) {
            Name name = ni.getNameKey();
            ArrayList<Object> sizes = new ArrayList<Object>();
            for (int i = 0; i < name.busWidth(); ++i) {
                Nodable no = Netlist.getNodableFor((NodeInst)ni, i);
                Variable var = this.getLEDRIVE(ni, context.push(no));
                Object size = null;
                if (var != null) {
                    size = var.getObject();
                }
                sizes.add(size);
            }
            if (sizes.size() > 5) {
                Object[] objs = new Object[]{sizes.get(0), "...", sizes.get(sizes.size() - 1)};
                val = objs;
            } else {
                val = sizes.toArray();
            }
        } else {
            Variable var = this.getLEDRIVE(ni, context.push(ni));
            if (var == null) {
                var = this.getLEDRIVE_old(ni, context);
            }
            if (var == null) {
                throw new VarContext.EvalException("getdrive(): no size");
            }
            val = var.getObject();
        }
        if (val == null) {
            throw new VarContext.EvalException("getdrive(): size null");
        }
        return val;
    }

    public Object subdrive(String nodeName, String parName) throws VarContext.EvalException {
        VarContext context;
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            throw new VarContext.EvalException("subdrive(): Not enough hierarchy information");
        }
        Nodable no = (Nodable)info;
        if (no == null) {
            throw new VarContext.EvalException("subdrive(): Not enough hierarchy");
        }
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            Cell parent = no.getParent();
            if (parent == null) {
                throw new VarContext.EvalException("subdrive(): null parent");
            }
            int arrayIndex = 0;
            no = Netlist.getNodableFor(ni, arrayIndex);
            if (no == null) {
                throw new VarContext.EvalException("subdrive(): can't get equivalent schematic");
            }
        }
        if ((context = EvalJavaBsh.evalJavaBsh.getCurrentContext()) == null) {
            throw new VarContext.EvalException("subdrive(): null context");
        }
        NodeProto np = no.getProto();
        if (np == null) {
            throw new VarContext.EvalException("subdrive(): null nodeProto");
        }
        if (!no.isCellInstance()) {
            throw new VarContext.EvalException("subdrive(): NodeProto not a Cell");
        }
        Cell cell = (Cell)np;
        NodeInst ni = cell.findNode(nodeName);
        if (ni == null && (ni = cell.findNode(LETool.convertToJElectricDefaultName(nodeName))) == null) {
            throw new VarContext.EvalException("subdrive(): no nodeInst named " + nodeName);
        }
        Variable var = ni.getVar(parName);
        if (var == null) {
            var = ni.getVar("ATTR_" + parName);
        }
        if (var == null) {
            throw new VarContext.EvalException(parName.replaceFirst("ATTR_", "") + " not found");
        }
        return context.push(no).evalVarRecurse(var, ni);
    }

    private Variable getLEDRIVE_old(Nodable no, VarContext context) {
        String drive = LETool.makeDriveStrOLDRecurse(context);
        Variable var = null;
        while (!drive.equals("")) {
            Variable.Key key = Variable.findKey("LEDRIVE_" + drive + ";0;S");
            Variable variable = var = key != null ? no.getVar(key) : null;
            if (var != null) {
                return var;
            }
            int i = drive.indexOf(59);
            if (i == -1) break;
            drive = drive.substring(i + 1);
        }
        if ((var = no.getVar(Variable.newKey("LEDRIVE_0;S"))) != null) {
            return var;
        }
        return null;
    }

    private Variable getLEDRIVE(Nodable no, VarContext context) {
        Variable var = null;
        var = this.getLEDRIVEtop(no, context);
        if (var == null) {
            var = this.getLEDRIVEleaf(no, context);
        }
        return var;
    }

    private Variable getLEDRIVEtop(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Nodable topno = no;
        while (context != VarContext.globalContext) {
            topno = context.getNodable();
            context = context.pop();
        }
        Cell parent = topno.getParent();
        Variable.Key key = Variable.findKey("LEDRIVE_" + drive);
        if (key == null) {
            return null;
        }
        Variable var = parent.getVar(key);
        return var;
    }

    private Variable getLEDRIVEleaf(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Variable var = null;
        while (!drive.equals("")) {
            Variable.Key key = Variable.findKey("LEDRIVE_" + drive);
            Variable variable = var = key != null ? no.getVar(key) : null;
            if (var != null) {
                return var;
            }
            int i = drive.indexOf(46);
            if (i == -1) {
                return null;
            }
            drive = drive.substring(i + 1);
        }
        return null;
    }

    private static String makeDriveStr(VarContext context) {
        return "LEDRIVE_" + context.getInstPath(".");
    }

    private static String makeDriveStrOLD(VarContext context) {
        String s = "LEDRIVE_" + LETool.makeDriveStrOLDRecurse(context) + ";0;S";
        return s;
    }

    private static String makeDriveStrOLDRecurse(VarContext context) {
        if (context == VarContext.globalContext) {
            return "";
        }
        String prefix = context.pop() == VarContext.globalContext ? "" : LETool.makeDriveStrOLDRecurse(context.pop());
        Nodable no = context.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        String name = LETool.getCElectricDefaultName(no);
        String me = name + ",0";
        if (prefix.equals("")) {
            return me;
        }
        return prefix + ";" + me;
    }

    private static String getCElectricDefaultName(Nodable no) {
        String name = no.getNodeInst().getName();
        int at = name.indexOf(64);
        if (at != -1 && at + 1 < name.length()) {
            String num = name.substring(at + 1, name.length());
            try {
                Integer i = new Integer(num);
                name = name.substring(0, at) + (i + 1);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return name;
    }

    private static String convertToJElectricDefaultName(String celectricDefaultName) {
        Matcher mat = celecDefaultNamePattern.matcher(celectricDefaultName);
        if (mat.matches()) {
            try {
                Integer i = new Integer(mat.group(2));
                int ii = i - 1;
                if (ii >= 0) {
                    celectricDefaultName = mat.group(1) + "@" + ii;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return celectricDefaultName;
    }

    protected static Variable getMFactor(Nodable no) {
        Variable var = no.getVar(Simulation.M_FACTOR_KEY);
        if (var == null) {
            var = no.getParameter(Simulation.M_FACTOR_KEY);
        }
        return var;
    }

    public static double quantize(double d, double error, double minValue) {
        if (d <= minValue) {
            return minValue;
        }
        double power = Math.log10(d) / Math.log10(1.0 + error);
        long p = Math.round(power);
        long quan = Math.round(Math.pow(1.0 + error, p));
        return quan;
    }

    public void optimizeEqualGateDelays(Cell cell, VarContext context, boolean newAlg) {
        AnalyzeCell acjob = new AnalyzeCell(LESizer.Alg.EQUALGATEDELAYS, cell, context, newAlg);
        acjob.startJob(true, false);
    }

    public static void printResults(Nodable no, VarContext context) {
        LENetlister netlister;
        if (lastLEJobExecuted != null && (netlister = lastLEJobExecuted.getNetlister()).printResults(no, context)) {
            return;
        }
        System.out.println("No existing completed sizing jobs contain info about " + no.getName());
    }

    public static void clearStoredSizesJob(Nodable no) {
        ClearStoredSizes job = new ClearStoredSizes(no);
    }

    public static void clearStoredSizesJob(Library lib) {
        ClearStoredSizesLibrary job = new ClearStoredSizesLibrary(lib);
    }

    private static void clearStoredSizes(Cell cell) {
        Iterator<Serializable> it = cell.getNodes();
        while (it.hasNext()) {
            LETool.clearStoredSizes(it.next());
        }
        it = cell.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            cell.delVar(var.getKey());
        }
    }

    private static void clearStoredSizes(Library lib) {
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            LETool.clearStoredSizes(it.next());
        }
    }

    private static void clearStoredSizes(Nodable no) {
        Iterator<Variable> it = no.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            no.delVar(var.getKey());
        }
    }

    public static boolean isUseLocalSettings() {
        return cacheUseLocalSettings.getBoolean();
    }

    public static void setUseLocalSettings(boolean on) {
        cacheUseLocalSettings.setBoolean(on);
    }

    public static double getGlobalFanout() {
        return cacheGlobalFanout.getDouble();
    }

    public static void setGlobalFanout(double fo) {
        cacheGlobalFanout.setDouble(fo);
    }

    public static double getConvergenceEpsilon() {
        return cacheConvergenceEpsilon.getDouble();
    }

    public static void setConvergenceEpsilon(double ep) {
        cacheConvergenceEpsilon.setDouble(ep);
    }

    public static int getMaxIterations() {
        return cacheMaxIterations.getInt();
    }

    public static void setMaxIterations(int it) {
        cacheMaxIterations.setInt(it);
    }

    public static double getKeeperRatio() {
        return cacheKeeperRatio.getDouble();
    }

    public static void setKeeperRatio(double kr) {
        cacheKeeperRatio.setDouble(kr);
    }

    public static class ClearStoredSizesLibrary
    extends Job {
        private Library lib;

        public ClearStoredSizesLibrary(Library lib) {
            super("Clear LE Sizes", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            LETool.clearStoredSizes(this.lib);
            return true;
        }
    }

    public static class ClearStoredSizes
    extends Job {
        private Nodable no;

        public ClearStoredSizes(Nodable no) {
            super("Clear LE Sizes", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.no = no;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            LETool.clearStoredSizes(this.no);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateSizes
    extends Job {
        private List<Float> sizes;
        private List<String> varNames;
        private Cell cell;

        private UpdateSizes(List<Float> sizes, List<String> varNames, Cell cell) {
            super("Update LE Sizes", tool, Job.Type.CHANGE, null, cell, Job.Priority.USER);
            this.sizes = sizes;
            this.varNames = varNames;
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (int i = 0; i < this.sizes.size(); ++i) {
                Float f = this.sizes.get(i);
                String varName = this.varNames.get(i);
                this.cell.newVar(varName, (Object)f);
            }
            System.out.println("Sizes updated. Sizing Finished.");
            this.fieldVariableChanged("cell");
            return true;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd = EditWindow.findWindow(this.cell);
            if (wnd != null) {
                wnd.repaintContents(null, false);
            }
        }
    }

    public static class AnalyzeCell
    extends Job {
        private String progress = null;
        private Cell cell;
        private VarContext context;
        private LESizer.Alg algorithm;
        private LENetlister netlister;
        private boolean newAlg;

        public AnalyzeCell(LESizer.Alg algorithm, Cell cell, VarContext context, boolean newAlg) {
            super("Analyze " + cell, tool, Job.Type.EXAMINE, null, cell, Job.Priority.USER);
            this.algorithm = algorithm;
            this.cell = cell;
            this.context = context;
            this.newAlg = newAlg;
        }

        public boolean doIt() throws JobException {
            if (lastLEJobExecuted != null) {
                lastLEJobExecuted.remove();
            }
            lastLEJobExecuted = this;
            this.setProgress("building equations");
            System.out.print("Building equations...");
            this.netlister = this.newAlg ? new LENetlister2(this) : new LENetlister1(this);
            boolean success = this.netlister.netlist(this.cell, this.context, true);
            if (!success) {
                return false;
            }
            long equationsDone = System.currentTimeMillis();
            String elapsed = TextUtils.getElapsedTime(equationsDone - this.startTime);
            System.out.println("done (" + elapsed + ")");
            if (this.checkAbort(null)) {
                this.netlister.done();
                return false;
            }
            System.out.println("Starting iterations: ");
            this.setProgress("iterating");
            boolean success2 = this.netlister.size(this.algorithm);
            if (this.checkAbort(null)) {
                this.netlister.done();
                return false;
            }
            if (success2) {
                System.out.println("Sizing finished, updating sizes...");
                this.netlister.printStatistics();
                ArrayList<Float> sizes = new ArrayList<Float>();
                ArrayList<String> varNames = new ArrayList<String>();
                ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
                ArrayList<VarContext> contexts = new ArrayList<VarContext>();
                this.netlister.getSizes(sizes, varNames, nodes, contexts);
                for (int i = 0; i < sizes.size(); ++i) {
                    float f = ((Float)sizes.get(i)).floatValue();
                    NodeInst ni = (NodeInst)nodes.get(i);
                    VarContext context = (VarContext)contexts.get(i);
                    if (!(f < 1.0f)) continue;
                    String msg = "WARNING: Instance " + ni + " has size " + TextUtils.formatDouble(f, 3) + " less than 1";
                    System.out.println(msg);
                    if (ni == null) continue;
                    this.netlister.getErrorLogger().logWarning(msg, ni, ni.getParent(), context, 2);
                }
                new UpdateSizes(sizes, varNames, this.cell);
                this.netlister.getErrorLogger().termLogging(true);
            } else {
                System.out.println("Sizing failed, sizes unchanged");
                this.netlister.done();
            }
            return true;
        }

        protected boolean checkAbort(String msg) {
            if (this.getScheduledToAbort()) {
                if (msg != null) {
                    System.out.println("LETool aborted: " + msg);
                } else {
                    System.out.println("LETool aborted: no changes made");
                }
                this.setAborted();
                return true;
            }
            return false;
        }

        public String getInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.getInfo());
            if (this.getScheduledToAbort()) {
                buf.append("  Job aborted, no changes made\n");
            } else {
                buf.append("  Job completed successfully\n");
            }
            return buf.toString();
        }

        public LENetlister getNetlister() {
            return this.netlister;
        }
    }
}

