/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.OptionReconcile;
import com.sun.electric.tool.user.dialogs.Progress;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ErrorLoggerTree;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInterfaceMain
extends AbstractUserInterface {
    static final Logger logger = Logger.getLogger("com.sun.electric.tool.user");
    static volatile boolean initializationFinished = false;
    private static volatile boolean undoEnabled = false;
    private static volatile boolean redoEnabled = false;
    private static EventListenerList listenerList = new EventListenerList();
    private static Snapshot currentSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
    private static EDatabase database = EDatabase.clientDatabase();
    protected static Progress progress = null;
    private SplashWindow sw = null;
    private int lastId = 0;
    private ArrayList<SavedHighlights> savedHighlights = new ArrayList();

    public UserInterfaceMain(List<String> argsList, Mode mode, boolean showSplash) {
        new EventProcessor();
        SwingUtilities.invokeLater(new InitializationRun(argsList, mode, showSplash));
    }

    protected void dispatchServerEvent(Client.ServerEvent serverEvent) throws Exception {
    }

    @Override
    public void addEvent(Client.ServerEvent serverEvent) {
        SwingUtilities.invokeLater(serverEvent);
    }

    @Override
    public void initializeInitJob(Job job, Object mode) {
        if (!Client.isOSMac()) {
            return;
        }
        if (mode != Mode.MDI) {
            new EventProcessor();
        }
        SwingUtilities.invokeLater(new InitializationSetJob(job));
    }

    private static String getMacClassName() {
        return "com.sun.electric.tool.user.MacOSXInterface";
    }

    @Override
    public void finishInitialization() {
        initializationFinished = true;
        if (this.sw != null) {
            this.sw.removeNotify();
            this.sw = null;
        }
        TopLevel.InitializeWindows();
        WindowFrame.wantToOpenCurrentLibrary(true, null);
    }

    @Override
    public EditWindow_ getCurrentEditWindow_() {
        return EditWindow.getCurrent();
    }

    @Override
    public EditWindow_ needCurrentEditWindow_() {
        return EditWindow.needCurrent();
    }

    @Override
    public Cell getCurrentCell() {
        return WindowFrame.getCurrentCell();
    }

    @Override
    public Cell getCurrentCell(Library lib) {
        return lib.getCurCell();
    }

    @Override
    public void setCurrentCell(Library lib, Cell curCell) {
        lib.setCurCell(curCell);
    }

    @Override
    public Cell needCurrentCell() {
        return WindowFrame.needCurCell();
    }

    @Override
    public void adjustReferencePoint(Cell theCell, double cX, double cY) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell cell;
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow_) || (cell = content.getCell()) != theCell) continue;
            EditWindow_ wnd = (EditWindow_)((Object)content);
            Point2D off = wnd.getOffset();
            off.setLocation(off.getX() - cX, off.getY() - cY);
            wnd.setOffset(off);
        }
    }

    @Override
    public void repaintAllEditWindows() {
        EditWindow.repaintAllContents();
    }

    @Override
    public void loadComponentMenuForTechnology() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf != null) {
            wf.loadComponentMenuForTechnology();
        }
    }

    @Override
    public void alignToGrid(Point2D pt) {
        EditWindow.gridAlign(pt);
    }

    @Override
    public int getDefaultTextSize() {
        return EditWindow.getDefaultFontSize();
    }

    @Override
    public EditWindow_ displayCell(Cell cell) {
        WindowFrame wf = WindowFrame.createEditWindow(cell);
        if (wf.getContent() instanceof EditWindow_) {
            return (EditWindow_)((Object)wf.getContent());
        }
        return null;
    }

    @Override
    public void termLogging(ErrorLogger logger, boolean explain, boolean terminate) {
        if (logger.getNumLogs() == 0) {
            return;
        }
        ErrorLoggerTree.addLogger(logger, explain, terminate);
    }

    @Override
    public void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        ErrorLoggerTree.updateNetworkErrors(cell, errors);
    }

    @Override
    public void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        ErrorLoggerTree.updateNetworkErrors(cell, errors);
    }

    @Override
    public String reportLog(ErrorLogger.MessageLog log, boolean showhigh, Geometric[] gPair) {
        ErrorHighlight eh;
        Iterator<ErrorHighlight> it;
        EDatabase database = EDatabase.clientDatabase();
        if (gPair != null) {
            Geometric geom1 = null;
            Geometric geom2 = null;
            it = log.getHighlights();
            while (it.hasNext()) {
                eh = it.next();
                if (geom1 == null) {
                    geom1 = (Geometric)eh.getObject(database);
                    continue;
                }
                if (geom2 != null) continue;
                geom2 = (Geometric)eh.getObject(database);
            }
            if (geom1 != null) {
                gPair[0] = geom1;
            }
            if (geom2 != null) {
                gPair[1] = geom2;
            }
        }
        if (showhigh) {
            Highlighter highlighter = null;
            EditWindow wnd = null;
            it = log.getHighlights();
            while (it.hasNext()) {
                eh = it.next();
                Cell cell = eh.getCell(database);
                if (cell != null) {
                    if (!cell.isLinked()) {
                        return "(cell deleted): " + log.getMessageString();
                    }
                    boolean found = false;
                    Iterator<WindowFrame> it2 = WindowFrame.getWindows();
                    while (it2.hasNext()) {
                        WindowFrame wf = it2.next();
                        WindowContent content = wf.getContent();
                        if (!(content instanceof EditWindow) || (wnd = (EditWindow)content).getCell() != cell || (eh.getVarContext() == null || !eh.getVarContext().equals(wnd.getVarContext())) && eh.getVarContext() != null) continue;
                        wf.getFrame().toFront();
                        found = true;
                        break;
                    }
                    if (!found) {
                        WindowFrame wf = WindowFrame.createEditWindow(cell);
                        wnd = (EditWindow)wf.getContent();
                        wnd.setCell(eh.getCell(database), eh.getVarContext(), null);
                    }
                    if (highlighter == null) {
                        highlighter = wnd.getHighlighter();
                        highlighter.clear();
                    }
                }
                if (highlighter == null) continue;
                eh.addToHighlighter(highlighter, database);
            }
            if (highlighter != null) {
                highlighter.ensureHighlightingSeen();
                highlighter.finished();
                Rectangle2D hBounds = highlighter.getHighlightedArea(wnd);
                Rectangle2D shown = wnd.getDisplayedBounds();
                if (!shown.intersects(hBounds)) {
                    wnd.focusOnHighlighted();
                }
            }
        }
        return log.getMessageString();
    }

    @Override
    public void showErrorMessage(Object message, String title) {
        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), message, title, 0);
    }

    @Override
    public void showInformationMessage(Object message, String title) {
        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), message, title, 1);
    }

    @Override
    public boolean confirmMessage(Object message) {
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), message);
        return response == 0;
    }

    @Override
    public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
        String msg = message;
        int size = msg.length();
        int pos = 0;
        String newMsg = "";
        for (int lineNumber = 0; pos < size && lineNumber < 10; pos += 256, ++lineNumber) {
            int endIndex = pos + 256;
            if (endIndex > size) {
                endIndex = size;
            }
            newMsg = newMsg + msg.substring(pos, endIndex);
            newMsg = newMsg + "\n";
        }
        if (pos < size) {
            newMsg = newMsg + "........\n";
            int index = size - pos > 256 ? size - 256 : pos;
            newMsg = newMsg + msg.substring(index, size);
        }
        message = msg = newMsg;
        int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), message, title, -1, 2, null, choices, defaultChoice);
        return val;
    }

    @Override
    public String askForInput(Object message, String title, String def) {
        return JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), message, title, 3, null, null, def).toString();
    }

    @Override
    public void importPrefs() {
        String fileName = OpenFile.chooseInputFile(FileType.PREFS, "Saved Preferences");
        if (fileName == null) {
            return;
        }
        Pref.importPrefs(fileName);
    }

    @Override
    public void exportPrefs() {
        String fileName = OpenFile.chooseOutputFile(FileType.PREFS, "Saved Preferences", "electricPrefs.xml");
        if (fileName == null) {
            return;
        }
        Pref.exportPrefs(fileName);
    }

    @Override
    public void restoreSavedBindings(boolean initialCall) {
        TopLevel top = TopLevel.getCurrentJFrame();
        top.getEMenuBar().restoreSavedBindings(false);
    }

    @Override
    public void finishPrefReconcilation(String libName, List<Pref.Meaning> meaningsToReconcile) {
        OptionReconcile dialog = new OptionReconcile((Frame)TopLevel.getCurrentJFrame(), true, meaningsToReconcile, libName);
        dialog.setVisible(true);
    }

    @Override
    public int saveHighlights() {
        EditWindow_ wnd = this.getCurrentEditWindow_();
        if (wnd == null) {
            return -1;
        }
        SavedHighlights sh = new SavedHighlights(this.lastId++, wnd);
        while (this.savedHighlights.size() >= User.getMaxUndoHistory() && !this.savedHighlights.isEmpty()) {
            this.savedHighlights.remove(0);
        }
        this.savedHighlights.add(sh);
        return sh.id;
    }

    @Override
    public void restoreHighlights(int highlightsId) {
        for (SavedHighlights sh : this.savedHighlights) {
            if (sh.id != highlightsId) continue;
            sh.restore();
            break;
        }
    }

    @Override
    public void showUndoRedoStatus(boolean newUndoEnabled, boolean newRedoEnabled) {
        PropertyChangeEvent e = null;
        if (undoEnabled != newUndoEnabled) {
            undoEnabled = newUndoEnabled;
            SwingUtilities.invokeLater(new PropertyChangeRun(e));
        }
        if (redoEnabled != newRedoEnabled) {
            redoEnabled = newRedoEnabled;
            SwingUtilities.invokeLater(new PropertyChangeRun(e));
        }
    }

    @Override
    public void showSnapshot(Snapshot newSnapshot, boolean undoRedo) {
        SwingUtilities.invokeLater(new DatabaseChangeRun(newSnapshot, undoRedo));
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static boolean getUndoEnabled() {
        return undoEnabled;
    }

    public static boolean getRedoEnabled() {
        return redoEnabled;
    }

    private static void firePropertyChange(PropertyChangeEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        ToolBar.updateUndoRedoButtons(UserInterfaceMain.getUndoEnabled(), UserInterfaceMain.getRedoEnabled());
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell c;
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (content == null || (c = content.getCell()) == null || c.isLinked()) continue;
            wf.setCellWindow(null, null);
            content.fullRepaint();
        }
    }

    public static synchronized void addDatabaseChangeListener(DatabaseChangeListener l) {
        listenerList.add(DatabaseChangeListener.class, l);
    }

    public static synchronized void removeDatabaseChangeListener(DatabaseChangeListener l) {
        listenerList.remove(DatabaseChangeListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDatabaseChangeEvent(DatabaseChangeEvent e) {
        Class<User> clazz = User.class;
        synchronized (User.class) {
            Object[] listeners = listenerList.getListenerList();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DatabaseChangeListener.class) continue;
                ((DatabaseChangeListener)listeners[i + 1]).databaseChanged(e);
            }
            return;
        }
    }

    @Override
    public void startProgressDialog(String type, String filePath) {
        try {
            progress = new Progress("Reading " + type + " " + filePath + "...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        progress.setProgress(0);
    }

    @Override
    public void stopProgressDialog() {
        progress.close();
        progress = null;
    }

    @Override
    public void setProgressValue(long pct) {
        if (progress != null) {
            progress.setProgress((int)pct);
        }
    }

    @Override
    public void setProgressNote(String message) {
        if (progress != null) {
            progress.setNote(message);
        }
    }

    @Override
    public String getProgressNote() {
        return progress.getNote();
    }

    private static class EventProcessor
    extends EventQueue {
        private final String CLASS_NAME = this.getClass().getName();
        private int dispatchDepth = 0;

        private EventProcessor() {
            Toolkit kit = Toolkit.getDefaultToolkit();
            kit.getSystemEventQueue().push(this);
        }

        protected void dispatchEvent(AWTEvent e) {
            block2: {
                ++this.dispatchDepth;
                try {
                    super.dispatchEvent(e);
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                    ActivityLogger.logException(ex);
                    if (!(ex instanceof Error)) break block2;
                    logger.throwing(this.CLASS_NAME, "dispatchEvent", ex);
                    throw (Error)ex;
                }
            }
        }
    }

    private static class SplashWindow
    extends JFrame {
        public SplashWindow(Mode mode) {
            this.setUndecorated(true);
            this.setTitle("Electric Splash");
            this.setIconImage(TopLevel.getFrameIcon().getImage());
            JPanel whole = new JPanel();
            whole.setBorder(BorderFactory.createLineBorder(new Color(0, 170, 0), 5));
            whole.setLayout(new BorderLayout());
            ImageIcon splashImage = Resources.getResource(TopLevel.class, "SplashImage.gif");
            JLabel l = new JLabel(splashImage);
            whole.add((Component)l, "Center");
            JLabel v = new JLabel("Version " + Version.getVersion(), 0);
            whole.add((Component)v, "South");
            Font font = new Font(User.getDefaultFont(), 1, 24);
            v.setFont(font);
            v.setForeground(Color.BLACK);
            v.setBackground(Color.WHITE);
            this.getContentPane().add((Component)whole, "South");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.setVisible(true);
            this.toFront();
            this.paint(this.getGraphics());
        }
    }

    private static class SavedHighlights {
        private final int id;
        private final EditWindow_ wnd;
        private final List<Highlight2> savedHighlights;
        private final Point2D savedHighlightsOffset;

        private SavedHighlights(int id, EditWindow_ wnd) {
            this.id = id;
            this.wnd = wnd;
            this.savedHighlights = wnd.saveHighlightList();
            this.savedHighlightsOffset = wnd.getHighlightOffset();
        }

        private void restore() {
            this.wnd.restoreHighlightList(this.savedHighlights);
            this.wnd.setHighlightOffset((int)this.savedHighlightsOffset.getX(), (int)this.savedHighlightsOffset.getY());
            this.wnd.finishedHighlighting();
        }
    }

    private static class DatabaseChangeRun
    implements Runnable {
        private Snapshot newSnapshot;
        private boolean undoRedo;

        private DatabaseChangeRun(Snapshot newSnapshot, boolean undoRedo) {
            this.newSnapshot = newSnapshot;
            this.undoRedo = undoRedo;
        }

        public void run() {
            DatabaseChangeEvent event = new DatabaseChangeEvent(currentSnapshot, this.newSnapshot);
            Iterator<Listener> it = Tool.getListeners();
            while (it.hasNext()) {
                Listener listener = it.next();
                listener.endBatch(currentSnapshot, this.newSnapshot, this.undoRedo);
            }
            currentSnapshot = this.newSnapshot;
            UserInterfaceMain.fireDatabaseChangeEvent(event);
        }
    }

    private static class PropertyChangeRun
    implements Runnable {
        private PropertyChangeEvent e;

        private PropertyChangeRun(PropertyChangeEvent e) {
            this.e = e;
        }

        public void run() {
            UserInterfaceMain.firePropertyChange(this.e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitializationRun
    implements Runnable {
        List<String> argsList;
        Mode mode;
        boolean showSplash;

        InitializationRun(List<String> argsList, Mode mode, boolean showSplash) {
            this.argsList = argsList;
            this.mode = mode;
            this.showSplash = showSplash;
        }

        @Override
        public void run() {
            assert (SwingUtilities.isEventDispatchThread());
            if (Client.isOSMac()) {
                try {
                    Class<?> osXClass = Class.forName(UserInterfaceMain.getMacClassName());
                    Method osXRegisterMethod = null;
                    try {
                        osXRegisterMethod = osXClass.getMethod("registerMacOSXApplication", List.class);
                    }
                    catch (NoSuchMethodException e) {
                        osXRegisterMethod = null;
                    }
                    if (osXRegisterMethod != null) {
                        try {
                            osXRegisterMethod.invoke(osXClass, this.argsList);
                        }
                        catch (Exception e) {
                            System.out.println("Error initializing Mac OS/X interface");
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.showSplash) {
                UserInterfaceMain.this.sw = new SplashWindow(this.mode);
            }
            TopLevel.OSInitialize(this.mode);
        }
    }

    private class InitializationSetJob
    implements Runnable {
        Job initJob;

        public InitializationSetJob(Job job) {
            this.initJob = job;
        }

        public void run() {
            if (!Client.isOSMac()) {
                return;
            }
            try {
                Class<?> osXClass = Class.forName(UserInterfaceMain.getMacClassName());
                Method osXSetJobMethod = null;
                try {
                    osXSetJobMethod = osXClass.getMethod("setInitJob", Job.class);
                }
                catch (NoSuchMethodException e) {
                    osXSetJobMethod = null;
                }
                if (osXSetJobMethod != null) {
                    try {
                        osXSetJobMethod.invoke(osXClass, this.initJob);
                    }
                    catch (Exception e) {
                        System.out.println("Error initializing Mac OS/X interface");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MDI,
        SDI;

    }
}

