/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HighlightEOBJ
extends Highlight2 {
    protected ElectricObject eobj;
    private boolean highlightConnected;
    protected int point;
    private Color color;

    public HighlightEOBJ(ElectricObject e, Cell c, boolean connected, int p) {
        super(c);
        this.eobj = e;
        this.highlightConnected = connected;
        this.point = p;
        this.color = null;
    }

    public HighlightEOBJ(ElectricObject e, Cell c, boolean connected, int p, Color col) {
        super(c);
        this.eobj = e;
        this.highlightConnected = connected;
        this.point = p;
        this.color = col;
    }

    @Override
    void internalDescribe(StringBuffer desc) {
        desc.append(", ");
        if (this.eobj instanceof PortInst) {
            desc.append(((PortInst)this.eobj).describe(true));
        }
        if (this.eobj instanceof NodeInst) {
            desc.append(((NodeInst)this.eobj).describe(true));
        }
        if (this.eobj instanceof ArcInst) {
            desc.append(((ArcInst)this.eobj).describe(true));
        }
    }

    @Override
    public ElectricObject getElectricObject() {
        return this.eobj;
    }

    @Override
    public boolean isHighlightEOBJ() {
        return true;
    }

    @Override
    public void setPoint(int p) {
        this.point = p;
    }

    @Override
    public int getPoint() {
        return this.point;
    }

    @Override
    boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.eobj instanceof PortInst) {
            return ((PortInst)this.eobj).getNodeInst().isLinked();
        }
        return this.eobj.isLinked();
    }

    @Override
    boolean sameThing(Highlight2 obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElectricObject realEObj = this.eobj;
        if (realEObj instanceof PortInst) {
            realEObj = ((PortInst)realEObj).getNodeInst();
        }
        HighlightEOBJ other = (HighlightEOBJ)obj;
        ElectricObject realOtherEObj = other.eobj;
        if (realOtherEObj instanceof PortInst) {
            realOtherEObj = ((PortInst)realOtherEObj).getNodeInst();
        }
        return realEObj == realOtherEObj;
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Graphics2D g2 = (Graphics2D)g;
        this.highlightConnected = setConnected;
        Color oldColor = null;
        if (this.color != null) {
            oldColor = g.getColor();
            g.setColor(this.color);
        }
        if (this.eobj instanceof ArcInst) {
            ArcInst ai = (ArcInst)this.eobj;
            Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
            if (poly == null) {
                return;
            }
            HighlightEOBJ.drawOutlineFromPoints(wnd, g, poly.getPoints(), highOffX, highOffY, false, false);
            if (onlyHighlight) {
                String constraints = "X";
                if (ai.isRigid()) {
                    constraints = "R";
                } else if (ai.isFixedAngle()) {
                    constraints = ai.isSlidable() ? "FS" : "F";
                } else if (ai.isSlidable()) {
                    constraints = "S";
                }
                Point p = wnd.databaseToScreen(ai.getTrueCenterX(), ai.getTrueCenterY());
                Font font = wnd.getFont(null);
                if (font != null) {
                    GlyphVector gv = wnd.getGlyphs(constraints, font);
                    Rectangle2D glyphBounds = gv.getVisualBounds();
                    g.drawString(constraints, (int)((double)p.x - glyphBounds.getWidth() / 2.0 + (double)highOffX), p.y + font.getSize() / 2 + highOffY);
                }
            }
            return;
        }
        PortProto pp = null;
        ElectricObject realEObj = this.eobj;
        PortInst originalPi = null;
        if (realEObj instanceof PortInst) {
            originalPi = (PortInst)realEObj;
            pp = originalPi.getPortProto();
            realEObj = ((PortInst)realEObj).getNodeInst();
        }
        if (realEObj instanceof NodeInst) {
            Point2D[] points;
            EPoint[] points2;
            NodeInst ni = (NodeInst)realEObj;
            AffineTransform trans = ni.rotateOutAboutTrueCenter();
            int offX = highOffX;
            int offY = highOffY;
            if (this.point >= 0 && (points2 = ni.getTrace()) != null) {
                if (ni.getProto() == Artwork.tech().splineNode) {
                    Point2D[] changedPoints = new Point2D[points2.length];
                    for (int i = 0; i < points2.length; ++i) {
                        changedPoints[i] = points2[i];
                        if (i != this.point) continue;
                        double x = ni.getAnchorCenterX() + ((Point2D)points2[this.point]).getX();
                        double y = ni.getAnchorCenterY() + ((Point2D)points2[this.point]).getY();
                        Point2D.Double thisPt = new Point2D.Double(x, y);
                        trans.transform(thisPt, thisPt);
                        Point cThis = wnd.databaseToScreen(thisPt);
                        Point2D db = wnd.screenToDatabase(cThis.x + offX, cThis.y + offY);
                        changedPoints[i] = new Point2D.Double(db.getX() - ni.getAnchorCenterX(), db.getY() - ni.getAnchorCenterY());
                    }
                    Point2D[] spPoints = Artwork.tech().fillSpline(ni.getAnchorCenterX(), ni.getAnchorCenterY(), changedPoints);
                    Point cLast = wnd.databaseToScreen(spPoints[0]);
                    for (int i = 1; i < spPoints.length; ++i) {
                        Point cThis = wnd.databaseToScreen(spPoints[i]);
                        HighlightEOBJ.drawLine(g, wnd, cLast.x, cLast.y, cThis.x, cThis.y);
                        cLast = cThis;
                    }
                }
                if (points2[this.point] != null) {
                    int nextPoint;
                    double x = ni.getAnchorCenterX() + ((Point2D)points2[this.point]).getX();
                    double y = ni.getAnchorCenterY() + ((Point2D)points2[this.point]).getY();
                    Point2D.Double thisPt = new Point2D.Double(x, y);
                    trans.transform(thisPt, thisPt);
                    Point cThis = wnd.databaseToScreen(thisPt);
                    int size = 3;
                    HighlightEOBJ.drawLine(g, wnd, cThis.x + size + offX, cThis.y + size + offY, cThis.x - size + offX, cThis.y - size + offY);
                    HighlightEOBJ.drawLine(g, wnd, cThis.x + size + offX, cThis.y - size + offY, cThis.x - size + offX, cThis.y + size + offY);
                    boolean showWrap = ni.traceWraps();
                    Point2D.Double prevPt = null;
                    Point2D.Double nextPt = null;
                    int prevPoint = this.point - 1;
                    if (prevPoint < 0 && showWrap) {
                        prevPoint = points2.length - 1;
                    }
                    if (prevPoint >= 0 && points2[prevPoint] != null) {
                        prevPt = new Point2D.Double(ni.getAnchorCenterX() + ((Point2D)points2[prevPoint]).getX(), ni.getAnchorCenterY() + ((Point2D)points2[prevPoint]).getY());
                        trans.transform(prevPt, prevPt);
                        if (((Point2D)prevPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)prevPt).getY() == ((Point2D)thisPt).getY()) {
                            prevPoint = -1;
                        } else {
                            Point cPrev = wnd.databaseToScreen(prevPt);
                            HighlightEOBJ.drawLine(g, wnd, cThis.x + offX, cThis.y + offY, cPrev.x, cPrev.y);
                        }
                    }
                    if ((nextPoint = this.point + 1) >= points2.length) {
                        nextPoint = showWrap ? 0 : -1;
                    }
                    if (nextPoint >= 0 && points2[nextPoint] != null) {
                        nextPt = new Point2D.Double(ni.getAnchorCenterX() + ((Point2D)points2[nextPoint]).getX(), ni.getAnchorCenterY() + ((Point2D)points2[nextPoint]).getY());
                        trans.transform(nextPt, nextPt);
                        if (((Point2D)nextPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)nextPt).getY() == ((Point2D)thisPt).getY()) {
                            nextPoint = -1;
                        } else {
                            Point cNext = wnd.databaseToScreen(nextPt);
                            HighlightEOBJ.drawLine(g, wnd, cThis.x + offX, cThis.y + offY, cNext.x, cNext.y);
                        }
                    }
                    if (offX == 0 && offY == 0 && points2.length > 2 && prevPt != null && nextPt != null) {
                        double arrowLen = Double.MAX_VALUE;
                        if (prevPoint >= 0) {
                            arrowLen = Math.min(thisPt.distance(prevPt), arrowLen);
                        }
                        if (nextPoint >= 0) {
                            arrowLen = Math.min(thisPt.distance(nextPt), arrowLen);
                        }
                        arrowLen /= 10.0;
                        double angleOfArrow = 2.5132741228718345;
                        if (prevPoint >= 0) {
                            Point2D.Double prevCtr = new Point2D.Double((((Point2D)prevPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)prevPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                            double prevAngle = DBMath.figureAngleRadians(prevPt, thisPt);
                            Point2D.Double prevArrow1 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle + angleOfArrow) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle + angleOfArrow) * arrowLen);
                            Point2D.Double prevArrow2 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle - angleOfArrow) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle - angleOfArrow) * arrowLen);
                            Point cPrevCtr = wnd.databaseToScreen(prevCtr);
                            Point cPrevArrow1 = wnd.databaseToScreen(prevArrow1);
                            Point cPrevArrow2 = wnd.databaseToScreen(prevArrow2);
                            HighlightEOBJ.drawLine(g, wnd, cPrevCtr.x, cPrevCtr.y, cPrevArrow1.x, cPrevArrow1.y);
                            HighlightEOBJ.drawLine(g, wnd, cPrevCtr.x, cPrevCtr.y, cPrevArrow2.x, cPrevArrow2.y);
                        }
                        if (nextPoint >= 0) {
                            Point2D.Double nextCtr = new Point2D.Double((((Point2D)nextPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)nextPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                            double nextAngle = DBMath.figureAngleRadians(thisPt, nextPt);
                            Point2D.Double nextArrow1 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle + angleOfArrow) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle + angleOfArrow) * arrowLen);
                            Point2D.Double nextArrow2 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle - angleOfArrow) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle - angleOfArrow) * arrowLen);
                            Point cNextCtr = wnd.databaseToScreen(nextCtr);
                            Point cNextArrow1 = wnd.databaseToScreen(nextArrow1);
                            Point cNextArrow2 = wnd.databaseToScreen(nextArrow2);
                            HighlightEOBJ.drawLine(g, wnd, cNextCtr.x, cNextCtr.y, cNextArrow1.x, cNextArrow1.y);
                            HighlightEOBJ.drawLine(g, wnd, cNextCtr.x, cNextCtr.y, cNextArrow2.x, cNextArrow2.y);
                        }
                    }
                }
                offY = 0;
                offX = 0;
            }
            if (offX == 0 && offY == 0 || this.point < 0) {
                Poly niPoly = HighlightEOBJ.getNodeInstOutline(ni);
                boolean niOpened = niPoly.getStyle() == Poly.Type.OPENED;
                points = niPoly.getPoints();
                HighlightEOBJ.drawOutlineFromPoints(wnd, g, points, offX, offY, niOpened, false);
            }
            if (pp != null) {
                Poly poly = ni.getShapeOfPort(pp);
                boolean opened = true;
                points = poly.getPoints();
                if (poly.getStyle() == Poly.Type.FILLED || poly.getStyle() == Poly.Type.CLOSED) {
                    opened = false;
                }
                if (poly.getStyle() == Poly.Type.CIRCLE || poly.getStyle() == Poly.Type.THICKCIRCLE || poly.getStyle() == Poly.Type.DISC) {
                    double sX = points[0].distance(points[1]) * 2.0;
                    Point2D[] pts = Artwork.fillEllipse(points[0], sX, sX, 0.0, 360.0);
                    poly = new Poly(pts);
                    poly.transform(ni.rotateOut());
                    points = poly.getPoints();
                } else if (poly.getStyle() == Poly.Type.CIRCLEARC) {
                    double[] angles = ni.getArcDegrees();
                    double sX = points[0].distance(points[1]) * 2.0;
                    Point2D[] pts = Artwork.fillEllipse(points[0], sX, sX, angles[0], angles[1]);
                    poly = new Poly(pts);
                    poly.transform(ni.rotateOut());
                    points = poly.getPoints();
                }
                HighlightEOBJ.drawOutlineFromPoints(wnd, g, points, offX, offY, opened, false);
                if (ni.isCellInstance() && g instanceof Graphics2D) {
                    boolean wired = false;
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        wired = true;
                        break;
                    }
                    if (wired) {
                        Font font = new Font(User.getDefaultFont(), 0, (int)(1.5 * (double)EditWindow.getDefaultFontSize()));
                        GlyphVector v = wnd.getGlyphs(pp.getName(), font);
                        Point point = wnd.databaseToScreen(poly.getCenterX(), poly.getCenterY());
                        ((Graphics2D)g).drawGlyphVector(v, (float)((Point2D)point).getX() + (float)offX, (float)((Point2D)point).getY() + (float)offY);
                    }
                }
                if (this.highlightConnected && onlyHighlight) {
                    NodeInst oNi;
                    Export equiv;
                    Netlist netlist = this.cell.acquireUserNetlist();
                    if (netlist == null) {
                        return;
                    }
                    NodeInst originalNI = ni;
                    if (ni.isIconOfParent() && (equiv = (Export)this.cell.findPortProto(pp.getName())) != null) {
                        originalPi = equiv.getOriginalPort();
                        ni = originalPi.getNodeInst();
                        pp = originalPi.getPortProto();
                    }
                    Set<Network> networks = new HashSet<Network>();
                    networks = NetworkTool.getNetworksOnPort(originalPi, netlist, networks);
                    HashSet<Geometric> markObj = new HashSet<Geometric>();
                    Iterator<Object> it = this.cell.getArcs();
                    block5: while (it.hasNext()) {
                        ArcInst ai = it.next();
                        Name arcName = ai.getNameKey();
                        for (int i = 0; i < arcName.busWidth(); ++i) {
                            if (!networks.contains(netlist.getNetwork(ai, i))) continue;
                            markObj.add(ai);
                            markObj.add(ai.getHeadPortInst().getNodeInst());
                            markObj.add(ai.getTailPortInst().getNodeInst());
                            continue block5;
                        }
                    }
                    it = netlist.getNodables();
                    while (it.hasNext()) {
                        Nodable no = (Nodable)it.next();
                        oNi = no.getNodeInst();
                        if (oNi == originalNI || markObj.contains(ni)) continue;
                        boolean highlightNo = false;
                        Iterator<PortProto> eIt = no.getProto().getPorts();
                        while (eIt.hasNext()) {
                            PortProto oPp = eIt.next();
                            Name opName = oPp.getNameKey();
                            for (int j = 0; j < opName.busWidth(); ++j) {
                                if (!networks.contains(netlist.getNetwork(no, oPp, j))) continue;
                                highlightNo = true;
                                break;
                            }
                            if (!highlightNo) continue;
                            break;
                        }
                        if (!highlightNo) continue;
                        markObj.add(oNi);
                    }
                    Stroke origStroke = g2.getStroke();
                    g2.setStroke(dashedLine);
                    Iterator<Geometric> it2 = this.cell.getArcs();
                    while (it2.hasNext()) {
                        ArcInst ai = it2.next();
                        if (!markObj.contains(ai)) continue;
                        Point c1 = wnd.databaseToScreen(ai.getHeadLocation());
                        Point c2 = wnd.databaseToScreen(ai.getTailLocation());
                        HighlightEOBJ.drawLine(g, wnd, c1.x, c1.y, c2.x, c2.y);
                    }
                    g2.setStroke(solidLine);
                    it2 = this.cell.getNodes();
                    while (it2.hasNext()) {
                        oNi = (NodeInst)it2.next();
                        if (!markObj.contains(oNi)) continue;
                        Point c = wnd.databaseToScreen(oNi.getTrueCenter());
                        g.fillOval(c.x - 4, c.y - 4, 8, 8);
                        Point2D nodeCenter = oNi.getTrueCenter();
                        Iterator<Connection> pIt = oNi.getConnections();
                        while (pIt.hasNext()) {
                            EPoint arcEnd;
                            Connection con = pIt.next();
                            ArcInst ai = con.getArc();
                            if (!markObj.contains(ai) || ((Point2D)(arcEnd = con.getLocation())).getX() == nodeCenter.getX() && ((Point2D)arcEnd).getY() == nodeCenter.getY()) continue;
                            Point c1 = wnd.databaseToScreen(arcEnd);
                            Point c2 = wnd.databaseToScreen(nodeCenter);
                            HighlightEOBJ.drawLine(g, wnd, c1.x, c1.y, c2.x, c2.y);
                        }
                    }
                    g2.setStroke(origStroke);
                }
            }
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    @Override
    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
        HighlightEOBJ.getHighlightedEObjsInternal(this.getGeometric(), list, wantNodes, wantArcs);
    }

    @Override
    void getHighlightedNodes(Highlighter highlighter, List<NodeInst> list) {
        HighlightEOBJ.getHighlightedNodesInternal(this.getGeometric(), list);
    }

    @Override
    void getHighlightedArcs(Highlighter highlighter, List<ArcInst> list) {
        HighlightEOBJ.getHighlightedArcsInternal(this.getGeometric(), list);
    }

    @Override
    void getHighlightedNetworks(Set<Network> nets, Netlist netlist) {
        PortInst pi;
        NodeInst ni;
        ElectricObject eObj = this.eobj;
        if (eObj instanceof NodeInst && (ni = (NodeInst)eObj).getNumPortInsts() == 1 && (pi = ni.getOnlyPortInst()) != null) {
            eObj = pi;
        }
        if (eObj instanceof PortInst) {
            PortInst pi2 = (PortInst)eObj;
            nets = NetworkTool.getNetworksOnPort(pi2, netlist, nets);
        } else if (eObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)eObj;
            int width = netlist.getBusWidth(ai);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork((ArcInst)eObj, i);
                if (net == null) continue;
                nets.add(net);
            }
        }
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        ElectricObject eObj = this.eobj;
        if (eObj instanceof PortInst) {
            eObj = ((PortInst)eObj).getNodeInst();
        }
        if (eObj instanceof Geometric) {
            Geometric geom = (Geometric)eObj;
            return geom.getBounds();
        }
        return null;
    }

    @Override
    public Geometric getGeometric() {
        Geometric retVal = null;
        if (this.eobj instanceof PortInst) {
            retVal = ((PortInst)this.eobj).getNodeInst();
        } else if (this.eobj instanceof Geometric) {
            retVal = (Geometric)this.eobj;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean overHighlighted(EditWindow wnd, int x, int y, Highlighter highlighter) {
        Point2D slop = wnd.deltaScreenToDatabase(10, 10);
        double directHitDist = slop.getX();
        Point2D start = wnd.screenToDatabase(x, y);
        Rectangle2D.Double searchArea = new Rectangle2D.Double(start.getX(), start.getY(), 0.0, 0.0);
        ElectricObject eobj = this.eobj;
        if (eobj instanceof PortInst) {
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (eobj instanceof Geometric) {
            ElectricObject hObj;
            ElectricObject hReal;
            boolean specialSelect = ToolBar.isSelectSpecial();
            Highlight2 got = Highlighter.checkOutObject((Geometric)eobj, true, false, specialSelect, searchArea, wnd, directHitDist, false);
            if (got == null) {
                return false;
            }
            if (!(got instanceof HighlightEOBJ)) {
                System.out.println("Error?");
            }
            if ((hReal = (hObj = got.getElectricObject())) instanceof PortInst) {
                hReal = ((PortInst)hReal).getNodeInst();
            }
            for (Highlight2 alreadyDone : highlighter.getHighlights()) {
                if (!(alreadyDone instanceof HighlightEOBJ)) continue;
                HighlightEOBJ alreadyHighlighted = (HighlightEOBJ)alreadyDone;
                ElectricObject aHObj = alreadyHighlighted.getElectricObject();
                ElectricObject aHReal = aHObj;
                if (aHReal instanceof PortInst) {
                    aHReal = ((PortInst)aHReal).getNodeInst();
                }
                if (hReal != aHReal) continue;
                if (hObj == aHObj && alreadyHighlighted.point == ((HighlightEOBJ)got).point) break;
                alreadyHighlighted.eobj = got.getElectricObject();
                alreadyHighlighted.point = ((HighlightEOBJ)got).point;
                Highlighter highlighter2 = highlighter;
                synchronized (highlighter2) {
                    highlighter.setChanged(true);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getInfo() {
        String description = "";
        ElectricObject realObj = this.eobj;
        if (realObj instanceof PortInst) {
            realObj = ((PortInst)realObj).getNodeInst();
        }
        if (realObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)realObj;
            description = "Node " + ni.describe(true);
        } else if (realObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)this.eobj;
            description = "Arc " + ai.describe(true);
        }
        return description;
    }
}

