/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolySweepMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.GDSLayers;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDS
extends Input {
    private static final boolean DEBUGALL = false;
    private static final boolean SHOWPROGRESS = false;
    private static final boolean IGNOREIMMENSECELLS = false;
    private static final boolean TALLYCONTENTS = false;
    private static final int MAXPOINTS = 4096;
    private static final int MINFONTWIDTH = 130;
    private static final int MINFONTHEIGHT = 190;
    private static final ShapeType SHAPEPOLY = new ShapeType();
    private static final ShapeType SHAPERECTANGLE = new ShapeType();
    private static final ShapeType SHAPEOBLIQUE = new ShapeType();
    private static final ShapeType SHAPELINE = new ShapeType();
    private static final ShapeType SHAPECLOSED = new ShapeType();
    private static final DatatypeSymbol TYPEERR = new DatatypeSymbol();
    private static final DatatypeSymbol TYPENONE = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEFLAGS = new DatatypeSymbol();
    private static final DatatypeSymbol TYPESHORT = new DatatypeSymbol();
    private static final DatatypeSymbol TYPELONG = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEFLOAT = new DatatypeSymbol();
    private static final DatatypeSymbol TYPEDOUBLE = new DatatypeSymbol();
    private static final DatatypeSymbol TYPESTRING = new DatatypeSymbol();
    private static final double twoTo32 = GDS.makePower(2, 32);
    private static final double twoToNeg56 = 1.0 / GDS.makePower(2, 56);
    private int countBox;
    private int countText;
    private int countNode;
    private int countPath;
    private int countShape;
    private int countSRef;
    private int countARef;
    private int countATotal;
    private Library theLibrary;
    private Map<Library, Cell> currentCells;
    private CellBuilder theCell;
    private NodeProto theNodeProto;
    private PrimitiveNode layerNodeProto;
    private UnknownLayerMessage currentUnknownLayerMessage;
    private PrimitiveNode pinNodeProto;
    private int randomLayerSelection;
    private boolean layerIsPin;
    private Technology curTech;
    private int recordCount;
    private int curLayerNum;
    private int curLayerType;
    private GSymbol theToken;
    private DatatypeSymbol valuetype;
    private int tokenFlags;
    private int tokenValue16;
    private int tokenValue32;
    private double tokenValueDouble;
    private String tokenString;
    private Point2D[] theVertices;
    private int numVertices;
    private double theScale;
    private Map<Integer, Layer> layerNames;
    private Map<Integer, UnknownLayerMessage> layerErrorMessages;
    private static Map<UnknownLayerMessage, Set<Cell>> cellLayerErrors;
    private Set<Integer> pinLayers;
    private PolyMerge merge;
    private static boolean arraySimplificationUseful;
    private static final GSymbol GDS_HEADER;
    private static final GSymbol GDS_BGNLIB;
    private static final GSymbol GDS_LIBNAME;
    private static final GSymbol GDS_UNITS;
    private static final GSymbol GDS_ENDLIB;
    private static final GSymbol GDS_BGNSTR;
    private static final GSymbol GDS_STRNAME;
    private static final GSymbol GDS_ENDSTR;
    private static final GSymbol GDS_BOUNDARY;
    private static final GSymbol GDS_PATH;
    private static final GSymbol GDS_SREF;
    private static final GSymbol GDS_AREF;
    private static final GSymbol GDS_TEXTSYM;
    private static final GSymbol GDS_LAYER;
    private static final GSymbol GDS_DATATYPSYM;
    private static final GSymbol GDS_WIDTH;
    private static final GSymbol GDS_XY;
    private static final GSymbol GDS_ENDEL;
    private static final GSymbol GDS_SNAME;
    private static final GSymbol GDS_COLROW;
    private static final GSymbol GDS_TEXTNODE;
    private static final GSymbol GDS_NODE;
    private static final GSymbol GDS_TEXTTYPE;
    private static final GSymbol GDS_PRESENTATION;
    private static final GSymbol GDS_STRING;
    private static final GSymbol GDS_STRANS;
    private static final GSymbol GDS_MAG;
    private static final GSymbol GDS_ANGLE;
    private static final GSymbol GDS_REFLIBS;
    private static final GSymbol GDS_FONTS;
    private static final GSymbol GDS_PATHTYPE;
    private static final GSymbol GDS_GENERATIONS;
    private static final GSymbol GDS_ATTRTABLE;
    private static final GSymbol GDS_ELFLAGS;
    private static final GSymbol GDS_NODETYPE;
    private static final GSymbol GDS_PROPATTR;
    private static final GSymbol GDS_PROPVALUE;
    private static final GSymbol GDS_BOX;
    private static final GSymbol GDS_BOXTYPE;
    private static final GSymbol GDS_PLEX;
    private static final GSymbol GDS_BGNEXTN;
    private static final GSymbol GDS_ENDEXTN;
    private static final GSymbol GDS_IDENT;
    private static final GSymbol GDS_REALNUM;
    private static final GSymbol GDS_SHORT_NUMBER;
    private static final GSymbol GDS_NUMBER;
    private static final GSymbol GDS_FLAGSYM;
    private static final GSymbol GDS_FORMAT;
    private static final GSymbol GDS_MASK;
    private static final GSymbol GDS_ENDMASKS;
    private static GSymbol[] optionSet;
    private static GSymbol[] shapeSet;
    private static GSymbol[] goodOpSet;
    private static GSymbol[] maskSet;
    private static GSymbol[] unsupportedSet;
    private GDSPreferences localPrefs;

    GDS(GDSPreferences ap) {
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.currentCells = currentCells;
        arraySimplificationUseful = false;
        CellBuilder.init();
        this.theLibrary = lib;
        this.curTech = tech;
        this.initialize();
        try {
            this.loadFile();
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR reading GDS file: " + e.getMessage());
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("ERROR reading GDS file: check input file, " + e.getMessage());
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            return null;
        }
        CellBuilder.buildInstances();
        CellBuilder.term();
        for (UnknownLayerMessage message : cellLayerErrors.keySet()) {
            Set<Cell> cellList = cellLayerErrors.get(message);
            System.out.println(message.message + " in cells:");
            String prev = "    ";
            int count = 0;
            for (Cell cell : cellList) {
                System.out.print(prev + cell.describe(false));
                prev = ", ";
                if (count > 10) {
                    count = 0;
                    System.out.print("\n\t");
                }
                ++count;
            }
            System.out.println();
        }
        if (arraySimplificationUseful) {
            System.out.println("NOTE: Found array references that could be simplified to save space and time");
            System.out.println("   To simplify arrays, set the 'Input array simplification' in GDS Preferences");
        }
        return lib;
    }

    private void initialize() {
        this.layerNodeProto = Generic.tech().drcNode;
        this.theVertices = new Point2D[4096];
        for (int i = 0; i < 4096; ++i) {
            this.theVertices[i] = new Point2D.Double();
        }
        this.recordCount = 0;
        this.layerNames = new HashMap<Integer, Layer>();
        this.layerErrorMessages = new HashMap<Integer, UnknownLayerMessage>();
        cellLayerErrors = new HashMap<UnknownLayerMessage, Set<Cell>>();
        this.pinLayers = new HashSet<Integer>();
        this.randomLayerSelection = 0;
        boolean valid = false;
        for (Map.Entry<Layer, String> e : this.curTech.getGDSLayers().entrySet()) {
            Layer layer = e.getKey();
            String gdsName = e.getValue();
            GDSLayers gdsl = GDSLayers.parseLayerString(gdsName);
            Iterator<Integer> lIt = gdsl.getLayers();
            while (lIt.hasNext()) {
                Integer lVal = lIt.next();
                Integer lay = new Integer(lVal);
                if (this.layerNames.get(lay) != null) continue;
                this.layerNames.put(lay, layer);
            }
            if (gdsl.getPinLayer() != -1) {
                this.pinLayers.add(new Integer(gdsl.getPinLayer()));
                this.layerNames.put(new Integer(gdsl.getPinLayer()), layer);
            }
            if (gdsl.getTextLayer() != -1) {
                this.layerNames.put(new Integer(gdsl.getTextLayer()), layer);
            }
            valid = true;
        }
        if (!valid) {
            System.out.println("There are no GDS layer names assigned in the " + this.curTech.getTechName() + " technology");
        }
    }

    private void loadFile() throws IOException {
        this.getToken();
        this.readHeader();
        this.getToken();
        this.readLibrary();
        this.getToken();
        while (this.isMember(this.theToken, optionSet)) {
            if (this.theToken == GDS_REFLIBS) {
                this.readRefLibs();
                continue;
            }
            if (this.theToken == GDS_FONTS) {
                this.readFonts();
                continue;
            }
            if (this.theToken == GDS_ATTRTABLE) {
                this.readAttrTable();
                continue;
            }
            if (this.theToken != GDS_GENERATIONS) continue;
            this.readGenerations();
        }
        while (this.theToken != GDS_UNITS) {
            this.getToken();
        }
        this.readUnits();
        this.getToken();
        while (this.theToken != GDS_ENDLIB) {
            this.readStructure();
            this.getToken();
        }
    }

    private void readHeader() throws IOException {
        if (this.theToken != GDS_HEADER) {
            this.handleError("GDS II header statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_SHORT_NUMBER) {
            this.handleError("GDS II version number is not decipherable");
        }
    }

    private void readLibrary() throws IOException {
        if (this.theToken != GDS_BGNLIB) {
            this.handleError("Begin library statement is missing");
        }
        this.getToken();
        this.determineTime();
        this.determineTime();
        if (this.theToken == GDS_LIBNAME) {
            this.getToken();
            if (this.theToken != GDS_IDENT) {
                this.handleError("Library name is missing");
            }
        }
    }

    private void readRefLibs() throws IOException {
        this.getToken();
        this.getToken();
    }

    private void readFonts() throws IOException {
        this.getToken();
        this.getToken();
    }

    private void readAttrTable() throws IOException {
        this.getToken();
        if (this.theToken == GDS_IDENT) {
            this.getToken();
        }
    }

    private void readUnits() throws IOException {
        if (this.theToken != GDS_UNITS) {
            this.handleError("Units statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_REALNUM) {
            this.handleError("Units statement has invalid number format");
        }
        this.getToken();
        double meterUnit = this.tokenValueDouble;
        double shift = 1.0;
        double roundedScale = meterUnit;
        while (roundedScale < 1.0) {
            roundedScale *= 10.0;
            shift *= 10.0;
        }
        meterUnit = roundedScale = DBMath.round(roundedScale) / shift;
        double microScale = TextUtils.convertFromDistance(1.0, this.curTech, TextUtils.UnitScale.MICRO);
        this.theScale = meterUnit * 1000000.0 * microScale * this.localPrefs.inputScale;
    }

    private double scaleValue(double value) {
        double result = value * this.theScale;
        return result;
    }

    private void showResultsOfCell() {
        System.out.print("**** Cell " + this.theCell.cell.describe(false) + " has");
        if (this.countBox > 0) {
            System.out.print(" " + this.countBox + " boxes");
        }
        if (this.countText > 0) {
            System.out.print(" " + this.countText + " texts");
        }
        if (this.countNode > 0) {
            System.out.print(" " + this.countNode + " nodes");
        }
        if (this.countPath > 0) {
            System.out.print(" " + this.countPath + " paths");
        }
        if (this.countShape > 0) {
            System.out.print(" " + this.countShape + " shapes");
        }
        if (this.countSRef > 0) {
            System.out.print(" " + this.countSRef + " instances");
        }
        if (this.countARef > 0) {
            System.out.print(" " + this.countARef + " arrays with " + this.countATotal + " elements");
        }
        System.out.println();
    }

    private void readStructure() throws IOException {
        this.beginStructure();
        this.getToken();
        if (this.localPrefs.mergeBoxes) {
            this.merge = new PolyMerge();
        }
        this.countATotal = 0;
        this.countARef = 0;
        this.countSRef = 0;
        this.countShape = 0;
        this.countPath = 0;
        this.countNode = 0;
        this.countText = 0;
        this.countBox = 0;
        while (this.theToken != GDS_ENDSTR) {
            this.getElement();
            this.getToken();
        }
        if (this.localPrefs.mergeBoxes) {
            Iterator<Layer> i$ = this.merge.getKeySet().iterator();
            while (i$.hasNext()) {
                Layer layer;
                Layer primLayer = layer = i$.next();
                PrimitiveNode pnp = primLayer.getPureLayerNode();
                List<PolyBase> polys = this.merge.getMergedPoints(layer, false);
                for (PolyBase poly : polys) {
                    EPoint ctr;
                    Rectangle2D box = poly.getBox();
                    if (box == null) {
                        box = poly.getBounds2D();
                        ctr = new EPoint(box.getCenterX(), box.getCenterY());
                        Point2D[] pPoints = poly.getPoints();
                        EPoint[] points = new EPoint[pPoints.length];
                        for (int i = 0; i < pPoints.length; ++i) {
                            points[i] = new EPoint(pPoints[i].getX(), pPoints[i].getY());
                        }
                        this.theCell.makeInstance(pnp, ctr, Orientation.IDENT, box.getWidth(), box.getHeight(), points, null);
                        continue;
                    }
                    ctr = new EPoint(box.getCenterX(), box.getCenterY());
                    this.theCell.makeInstance(pnp, ctr, Orientation.IDENT, box.getWidth(), box.getHeight(), null, null);
                }
            }
        }
    }

    private void beginStructure() throws IOException {
        String name;
        Cell cell;
        if (this.theToken != GDS_BGNSTR) {
            this.handleError("Begin structure statement is missing");
        }
        this.getToken();
        this.determineTime();
        this.determineTime();
        if (this.theToken != GDS_STRNAME) {
            this.handleError("Strname statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_IDENT) {
            this.handleError("Structure name is missing");
        }
        if ((cell = this.findCell(name = this.tokenString + "{lay}")) == null) {
            cell = Cell.newInstance(this.theLibrary, name);
            if (cell == null) {
                this.handleError("Failed to create structure");
            }
            System.out.println("Reading " + name);
            if (!this.currentCells.containsKey(this.theLibrary)) {
                this.currentCells.put(this.theLibrary, cell);
            }
        }
        this.theCell = new CellBuilder(cell, this.curTech, this.localPrefs);
    }

    private Cell findCell(String name) {
        return this.theLibrary.findNodeProto(name);
    }

    private static void buildComplexNode(List<EPoint> points, NodeProto pureType, Cell parent) {
        Point2D[] pointArray = new EPoint[points.size()];
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            pointArray[i] = points.get(i);
            if (pointArray[i] == null) continue;
            if (i == 0) {
                lX = hX = pointArray[i].getX();
                lY = hY = pointArray[i].getY();
                continue;
            }
            if (pointArray[i].getX() < lX) {
                lX = pointArray[i].getX();
            }
            if (pointArray[i].getX() > hX) {
                hX = ((EPoint)pointArray[i]).getX();
            }
            if (((EPoint)pointArray[i]).getY() < lY) {
                lY = ((EPoint)pointArray[i]).getY();
            }
            if (!(((EPoint)pointArray[i]).getY() > hY)) continue;
            hY = ((EPoint)pointArray[i]).getY();
        }
        NodeInst ni = NodeInst.makeInstance(pureType, new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0), hX - lX, hY - lY, parent, Orientation.IDENT, null);
        if (ni != null && GenMath.getAreaOfPoints(pointArray) != (hX - lX) * (hY - lY)) {
            ni.setTrace(pointArray);
        }
    }

    private void getElement() throws IOException {
        while (this.isMember(this.theToken, shapeSet)) {
            if (this.theToken == GDS_AREF) {
                this.determineARef();
                continue;
            }
            if (this.theToken == GDS_SREF) {
                this.determineSRef();
                continue;
            }
            if (this.theToken == GDS_BOUNDARY) {
                this.determineShape();
                continue;
            }
            if (this.theToken == GDS_PATH) {
                this.determinePath();
                continue;
            }
            if (this.theToken == GDS_NODE) {
                this.determineNode();
                continue;
            }
            if (this.theToken == GDS_TEXTSYM) {
                this.determineText();
                continue;
            }
            if (this.theToken != GDS_BOX) continue;
            this.determineBox();
        }
        while (this.theToken == GDS_PROPATTR) {
            this.determineProperty();
        }
        if (this.theToken != GDS_ENDEL) {
            this.showResultsOfCell();
            this.handleError("Element end statement is missing");
        }
    }

    private void determineARef() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.theToken != GDS_SNAME) {
            this.handleError("Array reference name is missing");
        }
        this.getToken();
        this.getPrototype(this.tokenString);
        this.getToken();
        int angle = 0;
        boolean trans = false;
        if (this.theToken == GDS_STRANS) {
            ReadOrientation ro = new ReadOrientation();
            ro.doIt();
            angle = ro.angle;
            trans = ro.trans;
        }
        int nCols = 0;
        int nRows = 0;
        if (this.theToken == GDS_COLROW) {
            this.getToken();
            nCols = this.tokenValue16;
            this.getToken();
            nRows = this.tokenValue16;
            this.getToken();
        }
        if (this.theToken != GDS_XY) {
            this.handleError("Array reference has no parameters");
        }
        this.getToken();
        this.determinePoints(3, 3);
        boolean mY = false;
        boolean mX = false;
        if (trans) {
            mY = true;
            angle = (angle + 900) % 3600;
        }
        Point2D.Double colInterval = new Point2D.Double(0.0, 0.0);
        if (nCols != 1) {
            ((Point2D)colInterval).setLocation((this.theVertices[1].getX() - this.theVertices[0].getX()) / (double)nCols, (this.theVertices[1].getY() - this.theVertices[0].getY()) / (double)nCols);
        }
        Point2D.Double rowInterval = new Point2D.Double(0.0, 0.0);
        if (nRows != 1) {
            ((Point2D)rowInterval).setLocation((this.theVertices[2].getX() - this.theVertices[0].getX()) / (double)nRows, (this.theVertices[2].getY() - this.theVertices[0].getY()) / (double)nRows);
        }
        this.theCell.makeInstanceArray(this.theNodeProto, nCols, nRows, Orientation.fromJava(angle, mX, mY), this.theVertices[0], rowInterval, colInterval);
    }

    private void determineSRef() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.theToken != GDS_SNAME) {
            this.handleError("Structure reference name is missing");
        }
        this.getToken();
        this.getPrototype(this.tokenString);
        this.getToken();
        int angle = 0;
        boolean trans = false;
        if (this.theToken == GDS_STRANS) {
            ReadOrientation ro = new ReadOrientation();
            ro.doIt();
            angle = ro.angle;
            trans = ro.trans;
        }
        if (this.theToken != GDS_XY) {
            this.handleError("Structure reference has no translation value");
        }
        this.getToken();
        this.determinePoints(1, 1);
        Point2D.Double loc = new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY());
        boolean mY = false;
        if (trans) {
            mY = true;
            angle = (angle + 900) % 3600;
        }
        this.theCell.makeInstance(this.theNodeProto, loc, Orientation.fromJava(angle, false, mY), 0.0, 0.0, null, null);
    }

    private void determineShape() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer();
        this.getToken();
        if (this.theToken != GDS_XY) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        this.determinePoints(3, 4096);
        this.determineBoundary();
    }

    private void determineBoundary() {
        boolean is90 = true;
        boolean is45 = true;
        for (int i = 0; i < this.numVertices - 1 && i < 4095; ++i) {
            double dx = this.theVertices[i + 1].getX() - this.theVertices[i].getX();
            double dy = this.theVertices[i + 1].getY() - this.theVertices[i].getY();
            if (dx == 0.0 || dy == 0.0) continue;
            is90 = false;
            if (Math.abs(dx) == Math.abs(dy)) continue;
            is45 = false;
        }
        ShapeType perimeter = SHAPELINE;
        if (this.theVertices[0].getX() == this.theVertices[this.numVertices - 1].getX() && this.theVertices[0].getY() == this.theVertices[this.numVertices - 1].getY()) {
            perimeter = SHAPECLOSED;
        }
        ShapeType oclass = SHAPEOBLIQUE;
        if (perimeter == SHAPECLOSED && (is90 || is45)) {
            oclass = SHAPEPOLY;
        }
        if (this.numVertices == 5 && is90 && perimeter == SHAPECLOSED) {
            oclass = SHAPERECTANGLE;
        }
        if (oclass == SHAPERECTANGLE) {
            this.readBox();
            Point2D.Double ctr = new Point2D.Double((this.theVertices[0].getX() + this.theVertices[1].getX()) / 2.0, (this.theVertices[0].getY() + this.theVertices[1].getY()) / 2.0);
            double sX = Math.abs(this.theVertices[1].getX() - this.theVertices[0].getX());
            double sY = Math.abs(this.theVertices[1].getY() - this.theVertices[0].getY());
            if (this.localPrefs.mergeBoxes) {
                if (this.layerNodeProto != null) {
                    PrimitiveNode plnp = this.layerNodeProto;
                    Technology.NodeLayer[] layers = plnp.getNodeLayers();
                    this.merge.addPolygon(layers[0].getLayer(), new Poly(((Point2D)ctr).getX(), ((Point2D)ctr).getY(), sX, sY));
                }
            } else {
                this.theCell.makeInstance(this.layerNodeProto, ctr, Orientation.IDENT, sX, sY, null, this.currentUnknownLayerMessage);
            }
            return;
        }
        if (oclass == SHAPEOBLIQUE || oclass == SHAPEPOLY) {
            if (this.localPrefs.mergeBoxes) {
                Technology.NodeLayer[] layers = this.layerNodeProto.getNodeLayers();
                if (this.layerNodeProto != null) {
                    this.merge.addPolygon(layers[0].getLayer(), new Poly(this.theVertices));
                }
            } else {
                double lx = this.theVertices[0].getX();
                double hx = this.theVertices[0].getX();
                double ly = this.theVertices[0].getY();
                double hy = this.theVertices[0].getY();
                for (int i = 1; i < this.numVertices; ++i) {
                    if (lx > this.theVertices[i].getX()) {
                        lx = this.theVertices[i].getX();
                    }
                    if (hx < this.theVertices[i].getX()) {
                        hx = this.theVertices[i].getX();
                    }
                    if (ly > this.theVertices[i].getY()) {
                        ly = this.theVertices[i].getY();
                    }
                    if (!(hy < this.theVertices[i].getY())) continue;
                    hy = this.theVertices[i].getY();
                }
                EPoint[] points = new EPoint[this.numVertices];
                for (int i = 0; i < this.numVertices; ++i) {
                    points[i] = new EPoint(this.theVertices[i].getX(), this.theVertices[i].getY());
                }
                this.theCell.makeInstance(this.layerNodeProto, new EPoint((lx + hx) / 2.0, (ly + hy) / 2.0), Orientation.IDENT, hx - lx, hy - ly, points, this.currentUnknownLayerMessage);
            }
            return;
        }
    }

    private void readBox() {
        double pxm = this.theVertices[4].getX();
        double pxs = this.theVertices[4].getX();
        double pym = this.theVertices[4].getY();
        double pys = this.theVertices[4].getY();
        for (int i = 0; i < 4; ++i) {
            if (this.theVertices[i].getX() > pxm) {
                pxm = this.theVertices[i].getX();
            }
            if (this.theVertices[i].getX() < pxs) {
                pxs = this.theVertices[i].getX();
            }
            if (this.theVertices[i].getY() > pym) {
                pym = this.theVertices[i].getY();
            }
            if (!(this.theVertices[i].getY() < pys)) continue;
            pys = this.theVertices[i].getY();
        }
        this.theVertices[0].setLocation(pxs, pys);
        this.theVertices[1].setLocation(pxm, pym);
    }

    private void determinePath() throws IOException {
        double bgnextend;
        int endcode = 0;
        this.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer();
        this.getToken();
        if (this.theToken == GDS_PATHTYPE) {
            this.getToken();
            endcode = this.tokenValue16;
            this.getToken();
        }
        double width = 0.0;
        if (this.theToken == GDS_WIDTH) {
            this.getToken();
            width = this.scaleValue(this.tokenValue32);
            this.getToken();
        }
        double endextend = bgnextend = endcode == 0 || endcode == 4 ? 0.0 : width / 2.0;
        if (this.theToken == GDS_BGNEXTN) {
            this.getToken();
            if (endcode == 4) {
                bgnextend = this.scaleValue(this.tokenValue32);
            }
            this.getToken();
        }
        if (this.theToken == GDS_ENDEXTN) {
            this.getToken();
            if (endcode == 4) {
                endextend = this.scaleValue(this.tokenValue32);
            }
            this.getToken();
        }
        if (this.theToken == GDS_XY) {
            this.getToken();
            this.determinePoints(2, 4096);
            for (int i = 0; i < this.numVertices - 1; ++i) {
                int ang;
                double fextend;
                Point2D fromPt = this.theVertices[i];
                Point2D toPt = this.theVertices[i + 1];
                double textend = fextend = width / 2.0;
                int thisAngle = GenMath.figureAngle(fromPt, toPt);
                if (i > 0) {
                    Point2D prevPoint = this.theVertices[i - 1];
                    int lastAngle = GenMath.figureAngle(prevPoint, fromPt);
                    if (Math.abs(thisAngle - lastAngle) % 900 != 0) {
                        ang = Math.abs(thisAngle - lastAngle) / 10;
                        if (ang > 180) {
                            ang = 360 - ang;
                        }
                        if (ang > 90) {
                            ang = 180 - ang;
                        }
                        fextend = Poly.getExtendFactor(width, ang);
                    }
                } else {
                    fextend = bgnextend;
                }
                if (i + 1 < this.numVertices - 1) {
                    Point2D nextPoint = this.theVertices[i + 2];
                    int nextAngle = GenMath.figureAngle(toPt, nextPoint);
                    if (Math.abs(thisAngle - nextAngle) % 900 != 0) {
                        ang = Math.abs(thisAngle - nextAngle) / 10;
                        if (ang > 180) {
                            ang = 360 - ang;
                        }
                        if (ang > 90) {
                            ang = 180 - ang;
                        }
                        textend = Poly.getExtendFactor(width, ang);
                    }
                } else {
                    textend = endextend;
                }
                double length = fromPt.distance(toPt);
                Poly poly = Poly.makeEndPointPoly(length, width, GenMath.figureAngle(toPt, fromPt), fromPt, fextend, toPt, textend, Poly.Type.FILLED);
                if (this.localPrefs.mergeBoxes) {
                    if (this.layerNodeProto == null) continue;
                    Technology.NodeLayer[] layers = this.layerNodeProto.getNodeLayers();
                    this.merge.addPolygon(layers[0].getLayer(), poly);
                    continue;
                }
                Rectangle2D polyBox = poly.getBox();
                if (polyBox != null) {
                    this.theCell.makeInstance(this.layerNodeProto, new EPoint(polyBox.getCenterX(), polyBox.getCenterY()), Orientation.IDENT, polyBox.getWidth(), polyBox.getHeight(), null, this.currentUnknownLayerMessage);
                    continue;
                }
                polyBox = poly.getBounds2D();
                double cx = polyBox.getCenterX();
                double cy = polyBox.getCenterY();
                Point2D[] polyPoints = poly.getPoints();
                EPoint[] points = new EPoint[polyPoints.length];
                for (int j = 0; j < polyPoints.length; ++j) {
                    points[j] = new EPoint(polyPoints[j].getX(), polyPoints[j].getY());
                }
                this.theCell.makeInstance(this.layerNodeProto, new EPoint(cx, cy), Orientation.IDENT, polyBox.getWidth(), polyBox.getHeight(), points, this.currentUnknownLayerMessage);
            }
        } else {
            this.handleError("Path element has no points");
        }
    }

    private void determineNode() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        if (this.theToken != GDS_LAYER) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        int layerNum = this.tokenValue16;
        if (this.theToken == GDS_SHORT_NUMBER) {
            this.getToken();
        }
        int layerType = this.tokenValue16;
        if (this.theToken == GDS_NODETYPE) {
            this.getToken();
            this.getToken();
        }
        this.setLayer(layerNum, layerType);
        if (this.theToken != GDS_XY) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        this.determinePoints(1, 1);
        if (!this.localPrefs.mergeBoxes) {
            this.theCell.makeInstance(this.layerNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), Orientation.IDENT, 0.0, 0.0, null, this.currentUnknownLayerMessage);
        }
    }

    private void determineText() throws IOException {
        String textString;
        double scale;
        boolean trans;
        int angle;
        int horiz_just;
        int vert_just;
        block9: {
            this.getToken();
            this.readUnsupported(unsupportedSet);
            this.determineLayer();
            this.getToken();
            vert_just = -1;
            horiz_just = -1;
            if (this.theToken == GDS_PRESENTATION) {
                Point just = this.determineJustification();
                vert_just = just.x;
                horiz_just = just.y;
            }
            if (this.theToken == GDS_PATHTYPE) {
                this.getToken();
                this.getToken();
            }
            if (this.theToken == GDS_WIDTH) {
                this.getToken();
                this.getToken();
            }
            angle = 0;
            trans = false;
            scale = 1.0;
            textString = "";
            while (true) {
                if (this.theToken == GDS_STRANS) {
                    ReadOrientation ro = new ReadOrientation();
                    ro.doIt();
                    angle = ro.angle;
                    trans = ro.trans;
                    scale = ro.scale;
                    continue;
                }
                if (this.theToken == GDS_XY) {
                    this.getToken();
                    this.determinePoints(1, 1);
                    continue;
                }
                if (this.theToken == GDS_ANGLE) {
                    this.getToken();
                    angle = (int)(this.tokenValueDouble * 10.0);
                    this.getToken();
                    continue;
                }
                if (this.theToken == GDS_STRING) {
                    if (this.recordCount != 0) {
                        this.getToken();
                        textString = this.tokenString;
                    }
                    this.getToken();
                    break block9;
                }
                if (this.theToken != GDS_MAG) break;
                this.getToken();
                this.getToken();
            }
            this.handleError("Text element has no reference point");
        }
        this.readText(textString, vert_just, horiz_just, angle, trans, scale);
    }

    private void readText(String charstring, int vjust, int hjust, int angle, boolean trans, double scale) {
        if (this.layerIsPin) {
            this.theCell.makeExport(this.pinNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), Orientation.IDENT, charstring, this.currentUnknownLayerMessage);
            return;
        }
        if (!this.localPrefs.includeText) {
            return;
        }
        double x = this.theVertices[0].getX() + (double)(130 * charstring.length());
        double y = this.theVertices[0].getY() + 190.0;
        this.theVertices[1].setLocation(x, y);
        MutableTextDescriptor td = MutableTextDescriptor.getNodeTextDescriptor();
        double size = scale;
        if (size <= 0.0) {
            size = 2.0;
        }
        if (size > 127.75) {
            size = 127.75;
        }
        if (size < 0.25) {
            size = 0.25;
        }
        td.setRelSize(size);
        td.setPos(AbstractTextDescriptor.Position.CENT);
        block0 : switch (vjust) {
            case 1: {
                switch (hjust) {
                    case 1: {
                        td.setPos(AbstractTextDescriptor.Position.UPRIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(AbstractTextDescriptor.Position.UPLEFT);
                        break block0;
                    }
                }
                td.setPos(AbstractTextDescriptor.Position.UP);
                break;
            }
            case 2: {
                switch (hjust) {
                    case 1: {
                        td.setPos(AbstractTextDescriptor.Position.DOWNRIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(AbstractTextDescriptor.Position.DOWNLEFT);
                        break block0;
                    }
                }
                td.setPos(AbstractTextDescriptor.Position.DOWN);
                break;
            }
            default: {
                switch (hjust) {
                    case 1: {
                        td.setPos(AbstractTextDescriptor.Position.RIGHT);
                        break block0;
                    }
                    case 2: {
                        td.setPos(AbstractTextDescriptor.Position.LEFT);
                        break block0;
                    }
                }
                td.setPos(AbstractTextDescriptor.Position.CENT);
            }
        }
        this.theCell.makeText(this.layerNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), charstring, TextDescriptor.newTextDescriptor(td), this.currentUnknownLayerMessage);
    }

    private void determineBox() throws IOException {
        this.getToken();
        this.readUnsupported(unsupportedSet);
        this.determineLayer();
        if (this.theToken != GDS_XY) {
            this.handleError("Boundary has no points");
        }
        this.getToken();
        this.determinePoints(2, 4096);
        if (this.localPrefs.mergeBoxes) {
            if (this.layerNodeProto != null) {
                // empty if block
            }
        } else {
            this.theCell.makeInstance(this.layerNodeProto, new Point2D.Double(this.theVertices[0].getX(), this.theVertices[0].getY()), Orientation.IDENT, 0.0, 0.0, null, this.currentUnknownLayerMessage);
        }
    }

    private void setLayer(int layerNum, int layerType) {
        String message;
        this.curLayerNum = layerNum;
        this.curLayerType = layerType;
        this.layerIsPin = false;
        this.currentUnknownLayerMessage = null;
        Integer layerInt = new Integer(layerNum + (layerType << 16));
        Layer layer = this.layerNames.get(layerInt);
        if (layer == null) {
            layer = Generic.tech().drcLay;
            if (this.localPrefs.unknownLayerHandling == 2) {
                Iterator<Layer> it = this.curTech.getLayers();
                while (it.hasNext()) {
                    Layer l = it.next();
                    if (this.layerNames.values().contains(l)) continue;
                    layer = l;
                    break;
                }
                if (layer == null) {
                    if (this.randomLayerSelection >= this.curTech.getNumLayers()) {
                        this.randomLayerSelection = 0;
                    }
                    layer = this.curTech.getLayer(this.randomLayerSelection);
                    ++this.randomLayerSelection;
                }
            }
            this.layerNames.put(layerInt, layer);
            message = "GDS layer " + layerNum + ", type " + layerType + " unknown, ";
            switch (this.localPrefs.unknownLayerHandling) {
                case 0: {
                    message = message + "ignoring it";
                    break;
                }
                case 1: {
                    message = message + "using Generic:DRC layer";
                    break;
                }
                case 2: {
                    message = message + "using layer " + layer.getName();
                }
            }
            this.currentUnknownLayerMessage = this.layerErrorMessages.get(layerInt);
            if (this.currentUnknownLayerMessage == null) {
                this.currentUnknownLayerMessage = new UnknownLayerMessage(message);
                this.layerErrorMessages.put(layerInt, this.currentUnknownLayerMessage);
            }
        }
        if (layer != null) {
            this.currentUnknownLayerMessage = this.layerErrorMessages.get(layerInt);
            if (layer == Generic.tech().drcLay && this.localPrefs.unknownLayerHandling == 0) {
                this.layerNodeProto = null;
                this.pinNodeProto = null;
                return;
            }
            this.layerNodeProto = layer.getNonPseudoLayer().getPureLayerNode();
            this.pinNodeProto = Generic.tech().universalPinNode;
            if (this.pinLayers.contains(layerInt)) {
                this.layerIsPin = true;
                if (this.layerNodeProto != null && this.layerNodeProto.getNumPorts() > 0) {
                    PrimitivePort pp = this.layerNodeProto.getPort(0);
                    Iterator<ArcProto> it = layer.getTechnology().getArcs();
                    while (it.hasNext()) {
                        ArcProto arc = it.next();
                        if (!pp.connectsTo(arc)) continue;
                        this.pinNodeProto = arc.findOverridablePinProto(this.ep);
                        break;
                    }
                }
            }
            if (this.layerNodeProto == null) {
                message = "Error: no pure layer node for layer '" + layer.getName() + "', ignoring it";
                this.layerNames.put(layerInt, Generic.tech().drcLay);
                this.currentUnknownLayerMessage = new UnknownLayerMessage(message);
                this.layerErrorMessages.put(layerInt, this.currentUnknownLayerMessage);
            }
        }
    }

    private void determineLayer() throws IOException {
        if (this.theToken != GDS_LAYER) {
            this.handleError("Layer statement is missing");
        }
        this.getToken();
        if (this.theToken != GDS_SHORT_NUMBER) {
            this.handleError("Invalid layer number");
        }
        int layerNum = this.tokenValue16;
        this.getToken();
        if (!this.isMember(this.theToken, maskSet)) {
            this.handleError("No datatype field");
        }
        this.getToken();
        this.setLayer(layerNum, this.tokenValue16);
    }

    private Point determineJustification() throws IOException {
        Point just = new Point();
        this.getToken();
        if (this.theToken != GDS_FLAGSYM) {
            this.handleError("Array reference has no parameters");
        }
        int font_libno = this.tokenFlags & 0x30;
        font_libno >>= 4;
        just.x = this.tokenFlags & 0xC;
        just.x >>= 2;
        just.y = this.tokenFlags & 3;
        this.getToken();
        return just;
    }

    private void determineProperty() throws IOException {
        this.getToken();
        this.getToken();
        if (this.theToken != GDS_PROPVALUE) {
            this.handleError("Property has no value");
        }
        this.getToken();
        this.getToken();
    }

    private void getPrototype(String name) throws IOException {
        Cell np = this.findCell(name = name + "{lay}");
        if (np == null) {
            np = Cell.newInstance(this.theLibrary, name);
            if (np == null) {
                this.handleError("Failed to create SREF proto");
            }
            GDS.setProgressValue(0);
            GDS.setProgressNote("Reading " + name);
        }
        this.theNodeProto = np;
    }

    private void readGenerations() throws IOException {
        this.getToken();
        if (this.theToken != GDS_SHORT_NUMBER) {
            this.handleError("Generations value is invalid");
        }
        this.getToken();
    }

    private boolean isMember(GSymbol tok, GSymbol[] set) {
        for (int i = 0; i < set.length; ++i) {
            if (set[i] != tok) continue;
            return true;
        }
        return false;
    }

    private void getToken() throws IOException {
        if (this.recordCount == 0) {
            this.valuetype = this.readRecord();
        } else {
            if (this.valuetype == TYPEFLAGS) {
                this.tokenFlags = this.getWord();
                this.theToken = GDS_FLAGSYM;
                return;
            }
            if (this.valuetype == TYPESHORT) {
                this.tokenValue16 = this.getWord();
                this.theToken = GDS_SHORT_NUMBER;
                return;
            }
            if (this.valuetype == TYPELONG) {
                this.tokenValue32 = this.getInteger();
                this.theToken = GDS_NUMBER;
                return;
            }
            if (this.valuetype == TYPEFLOAT) {
                this.tokenValueDouble = this.getFloat();
                this.theToken = GDS_REALNUM;
                return;
            }
            if (this.valuetype == TYPEDOUBLE) {
                this.tokenValueDouble = this.getDouble();
                this.theToken = GDS_REALNUM;
                return;
            }
            if (this.valuetype == TYPESTRING) {
                this.tokenString = this.getString();
                this.theToken = GDS_IDENT;
                return;
            }
            if (this.valuetype == TYPEERR) {
                this.handleError("Invalid GDS II datatype");
            }
        }
    }

    private DatatypeSymbol readRecord() throws IOException {
        int dataword = this.getWord();
        this.recordCount = dataword - 2;
        int recordtype = this.getByte() & 0xFF;
        this.theToken = GSymbol.findSymbol(recordtype);
        DatatypeSymbol datatypeSymbol = TYPEERR;
        switch (this.getByte()) {
            case 0: {
                datatypeSymbol = TYPENONE;
                break;
            }
            case 1: {
                datatypeSymbol = TYPEFLAGS;
                break;
            }
            case 2: {
                datatypeSymbol = TYPESHORT;
                break;
            }
            case 3: {
                datatypeSymbol = TYPELONG;
                break;
            }
            case 4: {
                datatypeSymbol = TYPEFLOAT;
                break;
            }
            case 5: {
                datatypeSymbol = TYPEDOUBLE;
                break;
            }
            case 6: {
                datatypeSymbol = TYPESTRING;
            }
        }
        return datatypeSymbol;
    }

    private void handleError(String msg) throws IOException {
        String message = "Error: " + msg + " at byte " + this.byteCount + " in '" + this.filePath + "'";
        Cell cell = this.theCell != null ? this.theCell.cell : null;
        System.out.println(message);
        errorLogger.logError(message, cell, 0);
        throw new IOException();
    }

    private void readUnsupported(GSymbol[] bad_op_set) throws IOException {
        if (this.isMember(this.theToken, bad_op_set)) {
            do {
                this.getToken();
            } while (!this.isMember(this.theToken, goodOpSet));
        }
    }

    private void determinePoints(int min_points, int max_points) throws IOException {
        this.numVertices = 0;
        while (this.theToken == GDS_NUMBER) {
            double x = this.scaleValue(this.tokenValue32);
            this.getToken();
            double y = this.scaleValue(this.tokenValue32);
            this.theVertices[this.numVertices].setLocation(x, y);
            ++this.numVertices;
            if (this.numVertices > max_points) {
                System.out.println("Found " + this.numVertices + " points (too many)");
                this.handleError("Too many points in the shape");
            }
            this.getToken();
        }
        if (this.numVertices < min_points) {
            System.out.println("Found " + this.numVertices + " points (too few)");
            this.handleError("Not enough points in the shape");
        }
    }

    private String determineTime() throws IOException {
        String[] time_array = new String[7];
        for (int i = 0; i < 6; ++i) {
            if (this.theToken != GDS_SHORT_NUMBER) {
                this.handleError("Date value is not a valid number");
            }
            if (i == 0 && this.tokenValue16 < 1900) {
                this.tokenValue16 = this.tokenValue16 > 60 ? (this.tokenValue16 += 1900) : (this.tokenValue16 += 2000);
            }
            time_array[i] = Integer.toString(this.tokenValue16);
            this.getToken();
        }
        return time_array[1] + "-" + time_array[2] + "-" + time_array[0] + " at " + time_array[3] + ":" + time_array[4] + ":" + time_array[5];
    }

    private float getFloat() throws IOException {
        int reg = this.getByte() & 0xFF;
        int sign = 1;
        if ((reg & 0x80) != 0) {
            sign = -1;
        }
        int binary_exponent = (reg &= 0x7F) - 64 << 2;
        reg = (this.getByte() & 0xFF) << 16;
        int dataword = this.getWord();
        reg += dataword;
        int shift_count = 0;
        while ((reg & 0x800000) == 0) {
            reg <<= 1;
            ++shift_count;
        }
        if ((binary_exponent = binary_exponent - shift_count - 24) > 0) {
            return (float)((double)(sign * reg) * GDS.makePower(2, binary_exponent));
        }
        if (binary_exponent < 0) {
            return (float)((double)(sign * reg) / GDS.makePower(2, -binary_exponent));
        }
        return sign * reg;
    }

    private static double makePower(int val, int power) {
        return Math.pow(val, power);
    }

    private double getDouble() throws IOException {
        int long_integer;
        int register1 = this.getByte() & 0xFF;
        double realValue = 1.0;
        if ((register1 & 0x80) != 0) {
            realValue = -1.0;
        }
        int exponent = (register1 &= 0x7F) - 64;
        register1 = (this.getByte() & 0xFF) << 16;
        int dataword = this.getWord();
        int register2 = long_integer = this.getInteger();
        if ((register1 += dataword) != 0 || register2 != 0) {
            while ((register1 & 0xF00000) == 0) {
                register1 = (register1 << 4) + (register2 >> 28);
                register2 <<= 4;
                --exponent;
            }
        } else {
            return 0.0;
        }
        realValue *= ((double)register1 * twoTo32 + (double)register2) * twoToNeg56;
        if (exponent > 0) {
            double pow = GDS.makePower(16, exponent);
            realValue *= pow;
        } else if (exponent < 0) {
            double pow = GDS.makePower(16, -exponent);
            realValue /= pow;
        }
        return realValue;
    }

    private String getString() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (this.recordCount != 0) {
            char letter = (char)this.getByte();
            if (letter == '\u0000') continue;
            sb.append(letter);
        }
        return sb.toString();
    }

    private int getInteger() throws IOException {
        int highWord = this.getWord();
        int lowWord = this.getWord();
        return highWord << 16 | lowWord;
    }

    private int getWord() throws IOException {
        int highByte = this.getByte() & 0xFF;
        int lowByte = this.getByte() & 0xFF;
        return highByte << 8 | lowByte;
    }

    private byte getByte() throws IOException {
        byte b = this.dataInputStream.readByte();
        this.updateProgressDialog(1);
        --this.recordCount;
        return b;
    }

    static {
        GDS_HEADER = new GSymbol(0);
        GDS_BGNLIB = new GSymbol(1);
        GDS_LIBNAME = new GSymbol(2);
        GDS_UNITS = new GSymbol(3);
        GDS_ENDLIB = new GSymbol(4);
        GDS_BGNSTR = new GSymbol(5);
        GDS_STRNAME = new GSymbol(6);
        GDS_ENDSTR = new GSymbol(7);
        GDS_BOUNDARY = new GSymbol(8);
        GDS_PATH = new GSymbol(9);
        GDS_SREF = new GSymbol(10);
        GDS_AREF = new GSymbol(11);
        GDS_TEXTSYM = new GSymbol(12);
        GDS_LAYER = new GSymbol(13);
        GDS_DATATYPSYM = new GSymbol(14);
        GDS_WIDTH = new GSymbol(15);
        GDS_XY = new GSymbol(16);
        GDS_ENDEL = new GSymbol(17);
        GDS_SNAME = new GSymbol(18);
        GDS_COLROW = new GSymbol(19);
        GDS_TEXTNODE = new GSymbol(20);
        GDS_NODE = new GSymbol(21);
        GDS_TEXTTYPE = new GSymbol(22);
        GDS_PRESENTATION = new GSymbol(23);
        GDS_STRING = new GSymbol(25);
        GDS_STRANS = new GSymbol(26);
        GDS_MAG = new GSymbol(27);
        GDS_ANGLE = new GSymbol(28);
        GDS_REFLIBS = new GSymbol(31);
        GDS_FONTS = new GSymbol(32);
        GDS_PATHTYPE = new GSymbol(33);
        GDS_GENERATIONS = new GSymbol(34);
        GDS_ATTRTABLE = new GSymbol(35);
        GDS_ELFLAGS = new GSymbol(38);
        GDS_NODETYPE = new GSymbol(42);
        GDS_PROPATTR = new GSymbol(43);
        GDS_PROPVALUE = new GSymbol(44);
        GDS_BOX = new GSymbol(45);
        GDS_BOXTYPE = new GSymbol(46);
        GDS_PLEX = new GSymbol(47);
        GDS_BGNEXTN = new GSymbol(48);
        GDS_ENDEXTN = new GSymbol(49);
        GDS_IDENT = new GSymbol(54);
        GDS_REALNUM = new GSymbol(55);
        GDS_SHORT_NUMBER = new GSymbol(56);
        GDS_NUMBER = new GSymbol(57);
        GDS_FLAGSYM = new GSymbol(58);
        GDS_FORMAT = new GSymbol(59);
        GDS_MASK = new GSymbol(60);
        GDS_ENDMASKS = new GSymbol(61);
        optionSet = new GSymbol[]{GDS_ATTRTABLE, GDS_REFLIBS, GDS_FONTS, GDS_GENERATIONS};
        shapeSet = new GSymbol[]{GDS_AREF, GDS_SREF, GDS_BOUNDARY, GDS_PATH, GDS_NODE, GDS_TEXTSYM, GDS_BOX};
        goodOpSet = new GSymbol[]{GDS_HEADER, GDS_BGNLIB, GDS_LIBNAME, GDS_UNITS, GDS_ENDLIB, GDS_BGNSTR, GDS_STRNAME, GDS_ENDSTR, GDS_BOUNDARY, GDS_PATH, GDS_SREF, GDS_AREF, GDS_TEXTSYM, GDS_LAYER, GDS_DATATYPSYM, GDS_WIDTH, GDS_XY, GDS_ENDEL, GDS_SNAME, GDS_COLROW, GDS_TEXTNODE, GDS_NODE, GDS_TEXTTYPE, GDS_PRESENTATION, GDS_STRING, GDS_STRANS, GDS_MAG, GDS_ANGLE, GDS_REFLIBS, GDS_FONTS, GDS_PATHTYPE, GDS_GENERATIONS, GDS_ATTRTABLE, GDS_NODETYPE, GDS_PROPATTR, GDS_PROPVALUE, GDS_BOX, GDS_BOXTYPE, GDS_FORMAT, GDS_MASK, GDS_ENDMASKS};
        maskSet = new GSymbol[]{GDS_DATATYPSYM, GDS_TEXTTYPE, GDS_BOXTYPE, GDS_NODETYPE};
        unsupportedSet = new GSymbol[]{GDS_ELFLAGS, GDS_PLEX};
    }

    private static class UnknownLayerMessage {
        String message;

        UnknownLayerMessage(String message) {
            this.message = message;
        }
    }

    private class ReadOrientation {
        private int angle;
        private boolean trans;
        private double scale;

        private ReadOrientation() {
        }

        private void doIt() throws IOException {
            double anglevalue = 0.0;
            this.scale = 1.0;
            boolean mirror_x = false;
            GDS.this.getToken();
            if (GDS.this.theToken != GDS_FLAGSYM) {
                GDS.this.handleError("Structure reference is missing its flags field");
            }
            if ((GDS.this.tokenFlags & 0x8000) != 0) {
                mirror_x = true;
            }
            GDS.this.getToken();
            if (GDS.this.theToken == GDS_MAG) {
                GDS.this.getToken();
                this.scale = GDS.this.tokenValueDouble;
                GDS.this.getToken();
            }
            if (GDS.this.theToken == GDS_ANGLE) {
                GDS.this.getToken();
                anglevalue = GDS.this.tokenValueDouble * 10.0;
                GDS.this.getToken();
            }
            this.angle = (int)anglevalue % 3600;
            this.trans = mirror_x;
            if (this.trans) {
                this.angle = (2700 - this.angle) % 3600;
            }
            if (this.angle < 0) {
                this.angle += 3600;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MakeInstance
    implements Comparable<MakeInstance> {
        private NodeProto proto;
        private Point2D loc;
        private Orientation orient;
        private double wid;
        private double hei;
        private EPoint[] points;
        private String exportName;
        private Name nodeName;
        private String origNodeName;
        private GDSPreferences localPrefs;

        private MakeInstance(NodeProto proto, Point2D loc, Orientation orient, double wid, double hei, EPoint[] points, String exportName, Name nodeName, GDSPreferences localPrefs) {
            this.proto = proto;
            this.loc = loc;
            this.orient = orient;
            this.wid = DBMath.round(wid);
            this.hei = DBMath.round(hei);
            this.points = points;
            this.exportName = exportName;
            if (nodeName != null && !nodeName.isValid()) {
                this.origNodeName = nodeName.toString();
                if (this.origNodeName.equals("[@instanceName]")) {
                    this.origNodeName = null;
                    nodeName = null;
                } else if (this.origNodeName.endsWith(":")) {
                    nodeName = Name.findName(this.origNodeName.substring(0, this.origNodeName.length() - 1));
                    if (nodeName.isValid()) {
                        this.origNodeName = null;
                    }
                } else {
                    nodeName = null;
                }
            }
            this.nodeName = nodeName;
            this.localPrefs = localPrefs;
        }

        @Override
        public int compareTo(MakeInstance that) {
            return TextUtils.STRING_NUMBER_ORDER.compare(this.nodeName.toString(), that.nodeName.toString());
        }

        private boolean instantiate(Cell parent, Map<String, String> exportUnify, Set<String> exportNames, List<Geometric> saveHere) {
            String name = null;
            if (this.nodeName != null) {
                name = this.nodeName.toString();
            }
            NodeInst ni = NodeInst.makeInstance(this.proto, this.loc, this.wid, this.hei, parent, this.orient, name);
            String errorMsg = null;
            if (ni == null) {
                return false;
            }
            if (saveHere != null) {
                saveHere.add(ni);
            }
            if (ni.getNameKey() != this.nodeName) {
                errorMsg = "Cell " + parent.describe(false) + ": GDS name '" + name + "' renamed to '" + ni.getName() + "'";
            } else if (this.origNodeName != null) {
                errorMsg = "Cell " + parent.describe(false) + ": Original GDS name of '" + name + "' was '" + this.origNodeName + "'";
            }
            if (errorMsg != null) {
                ArrayList<NodeInst> geomList = new ArrayList<NodeInst>(1);
                geomList.add(ni);
                Input.errorLogger.logMessage(errorMsg, geomList, parent, -1, false);
                System.out.println(errorMsg);
            }
            if (this.points != null && GenMath.getAreaOfPoints(this.points) != this.wid * this.hei) {
                ni.setTrace(this.points);
            }
            boolean renamed = false;
            if (this.exportName != null) {
                if (this.exportName.endsWith(":")) {
                    this.exportName = this.exportName.substring(0, this.exportName.length() - 1);
                }
                if (parent.findExport(this.exportName) != null) {
                    String newName = ElectricObject.uniqueObjectName(this.exportName, parent, PortProto.class, true, true);
                    exportUnify.put(newName, this.exportName);
                    this.exportName = newName;
                    renamed = true;
                }
                Export.newInstance(parent, ni.getPortInst(0), this.exportName);
            }
            return renamed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MakeInstanceArray {
        private NodeProto proto;
        private int nCols;
        private int nRows;
        private Orientation orient;
        private Point2D startLoc;
        private Point2D rowOffset;
        private Point2D colOffset;
        private GDSPreferences localPrefs;

        private MakeInstanceArray(NodeProto proto, int nCols, int nRows, Orientation orient, Point2D startLoc, Point2D rowOffset, Point2D colOffset, GDSPreferences localPrefs) {
            this.proto = proto;
            this.nCols = nCols;
            this.nRows = nRows;
            this.orient = orient;
            this.startLoc = startLoc;
            this.rowOffset = rowOffset;
            this.colOffset = colOffset;
            this.localPrefs = localPrefs;
        }

        private void instantiate(CellBuilder theCell, Cell parent, Map<NodeProto, List<EPoint>> massiveMerge) {
            int arraySimplification = this.localPrefs.arraySimplification;
            NodeInst subNi = null;
            Cell subCell = (Cell)this.proto;
            int numArcs = subCell.getNumArcs();
            int numNodes = subCell.getNumNodes();
            int numExports = subCell.getNumPorts();
            if (numArcs == 0 && numExports == 0 && numNodes == 1 && (subNi = subCell.getNode(0)).getProto().getFunction() != PrimitiveNode.Function.NODE) {
                subNi = null;
            }
            if (subNi != null && subNi.getTrace() != null) {
                subNi = null;
            }
            if (subNi != null) {
                if (arraySimplification > 0) {
                    List<EPoint> points = this.buildArray();
                    if (arraySimplification == 2) {
                        List<EPoint> soFar = massiveMerge.get(subNi.getProto());
                        if (soFar == null) {
                            soFar = new ArrayList<EPoint>();
                            massiveMerge.put(subNi.getProto(), soFar);
                        }
                        if (soFar.size() > 0) {
                            soFar.add(null);
                        }
                        for (EPoint ep : points) {
                            soFar.add(ep);
                        }
                    } else {
                        GDS.buildComplexNode(points, subNi.getProto(), parent);
                    }
                    return;
                }
                arraySimplificationUseful = true;
            }
            double ptcX = this.startLoc.getX();
            double ptcY = this.startLoc.getY();
            for (int ic = 0; ic < this.nCols; ++ic) {
                double ptX = ptcX;
                double ptY = ptcY;
                for (int ir = 0; ir < this.nRows; ++ir) {
                    if (this.localPrefs.instantiateArrays || ir == 0 && ic == 0 || ir == this.nRows - 1 && ic == this.nCols - 1) {
                        Point2D.Double loc = new Point2D.Double(ptX, ptY);
                        NodeInst ni = NodeInst.makeInstance(this.proto, loc, this.proto.getDefWidth(), this.proto.getDefHeight(), parent, this.orient, null);
                    }
                    ptX += this.rowOffset.getX();
                    ptY += this.rowOffset.getY();
                }
                ptcX += this.colOffset.getX();
                ptcY += this.colOffset.getY();
            }
        }

        private List<EPoint> buildArray() {
            ArrayList<EPoint> points = new ArrayList<EPoint>();
            ERectangle bounds = ((Cell)this.proto).getBounds();
            Rectangle2D.Double boundCopy = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
            DBMath.transformRect(boundCopy, this.orient.pureRotate());
            double ptcX = this.startLoc.getX();
            double ptcY = this.startLoc.getY();
            for (int ic = 0; ic < this.nCols; ++ic) {
                double ptX = ptcX;
                double ptY = ptcY;
                for (int ir = 0; ir < this.nRows; ++ir) {
                    points.add(new EPoint(ptX + boundCopy.getMinX(), ptY + boundCopy.getMinY()));
                    points.add(new EPoint(ptX + boundCopy.getMaxX(), ptY + boundCopy.getMinY()));
                    points.add(new EPoint(ptX + boundCopy.getMaxX(), ptY + boundCopy.getMaxY()));
                    points.add(new EPoint(ptX + boundCopy.getMinX(), ptY + boundCopy.getMaxY()));
                    if (ic < this.nCols - 1 || ir < this.nRows - 1) {
                        points.add(null);
                    }
                    ptX += this.rowOffset.getX();
                    ptY += this.rowOffset.getY();
                }
                ptcX += this.colOffset.getX();
                ptcY += this.colOffset.getY();
            }
            return points;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellBuilder {
        private static Map<Cell, CellBuilder> allBuilders;
        private static Set<Cell> cellsTooComplex;
        private GDSPreferences localPrefs;
        private Technology tech;
        private Cell cell;
        private List<MakeInstance> insts = new ArrayList<MakeInstance>();
        private Map<UnknownLayerMessage, List<MakeInstance>> allErrorInsts = new HashMap<UnknownLayerMessage, List<MakeInstance>>();
        private List<MakeInstanceArray> instArrays = new ArrayList<MakeInstanceArray>();

        private CellBuilder(Cell cell, Technology tech, GDSPreferences localPrefs) {
            this.cell = cell;
            this.tech = tech;
            this.localPrefs = localPrefs;
            allBuilders.put(cell, this);
        }

        private void makeInstance(NodeProto proto, Point2D loc, Orientation orient, double wid, double hei, EPoint[] points, UnknownLayerMessage ulm) {
            List<MakeInstance> errorList;
            MakeInstance mi = null;
            if (proto != null) {
                mi = new MakeInstance(proto, loc, orient, wid, hei, points, null, null, this.localPrefs);
                if (ulm == null) {
                    this.insts.add(mi);
                    return;
                }
            }
            if ((errorList = this.allErrorInsts.get(ulm)) == null) {
                errorList = new ArrayList<MakeInstance>();
                this.allErrorInsts.put(ulm, errorList);
            }
            errorList.add(mi);
        }

        private void makeInstanceArray(NodeProto proto, int nCols, int nRows, Orientation orient, Point2D startLoc, Point2D rowOffset, Point2D colOffset) {
            MakeInstanceArray mia = new MakeInstanceArray(proto, nCols, nRows, orient, new Point2D.Double(startLoc.getX(), startLoc.getY()), rowOffset, colOffset, this.localPrefs);
            this.instArrays.add(mia);
        }

        private void makeExport(NodeProto proto, Point2D loc, Orientation orient, String exportName, UnknownLayerMessage ulm) {
            List<MakeInstance> errorList;
            MakeInstance mi = null;
            if (proto != null && proto.getNumPorts() > 0) {
                double wid = proto.getDefWidth();
                double hei = proto.getDefHeight();
                mi = new MakeInstance(proto, loc, orient, wid, hei, null, exportName, null, this.localPrefs);
                if (ulm == null) {
                    this.insts.add(mi);
                    return;
                }
            }
            if ((errorList = this.allErrorInsts.get(ulm)) == null) {
                errorList = new ArrayList<MakeInstance>();
                this.allErrorInsts.put(ulm, errorList);
            }
            errorList.add(mi);
        }

        private void makeText(NodeProto proto, Point2D loc, String text, TextDescriptor textDescriptor, UnknownLayerMessage ulm) {
            List<MakeInstance> errorList;
            MakeInstance mi = null;
            if (proto != null) {
                mi = new MakeInstance(proto, loc, Orientation.IDENT, 0.0, 0.0, null, null, Name.findName(text), this.localPrefs);
                if (ulm == null) {
                    this.insts.add(mi);
                    return;
                }
            }
            if ((errorList = this.allErrorInsts.get(ulm)) == null) {
                errorList = new ArrayList<MakeInstance>();
                this.allErrorInsts.put(ulm, errorList);
            }
            errorList.add(mi);
        }

        private static void init() {
            allBuilders = new HashMap<Cell, CellBuilder>();
            cellsTooComplex = new HashSet<Cell>();
        }

        private static void term() {
            allBuilders = null;
            if (cellsTooComplex.size() > 0) {
                System.out.print("THESE CELLS WERE TOO COMPLEX AND NOT FULLY READ:");
                for (Cell cell : cellsTooComplex) {
                    System.out.print(" " + cell.describe(false));
                }
                System.out.println();
            }
        }

        private void makeInstances(Set<Cell> builtCells) {
            Cell subCell;
            CellBuilder cellBuilder;
            if (builtCells.contains(this.cell)) {
                return;
            }
            builtCells.add(this.cell);
            boolean countOff = false;
            this.nameInstances(countOff);
            Collections.sort(this.insts);
            HashSet<String> exportNames = new HashSet<String>();
            for (MakeInstance mi : this.insts) {
                if (mi.exportName == null) continue;
                exportNames.add(mi.exportName);
            }
            for (UnknownLayerMessage ulm : this.allErrorInsts.keySet()) {
                List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                for (MakeInstance mi : errorList) {
                    if (mi == null || mi.exportName == null) continue;
                    exportNames.add(mi.exportName);
                }
            }
            int count = 0;
            int renamed = 0;
            HashMap exportUnify = new HashMap();
            for (MakeInstance mi : this.insts) {
                if (mi.exportName != null) continue;
                if (countOff && ++count % 1000 == 0) {
                    System.out.println("        Made " + count + " instances");
                }
                if (mi.proto instanceof Cell && (cellBuilder = allBuilders.get(subCell = (Cell)mi.proto)) != null) {
                    cellBuilder.makeInstances(builtCells);
                }
                if (!mi.instantiate(this.cell, exportUnify, exportNames, null)) continue;
                ++renamed;
            }
            for (MakeInstance mi : this.insts) {
                if (mi.exportName == null) continue;
                if (countOff && ++count % 1000 == 0) {
                    System.out.println("        Made " + count + " instances");
                }
                if (mi.proto instanceof Cell && (cellBuilder = allBuilders.get(subCell = (Cell)mi.proto)) != null) {
                    cellBuilder.makeInstances(builtCells);
                }
                if (this.localPrefs.cadenceCompatibility) {
                    double scaledResolution;
                    ArcProto theArc = mi.proto.getPort(0).getBasePort().getConnections()[0];
                    Layer theLayer = theArc.getLayer(0);
                    PrimitiveNode theProto = theLayer.getPureLayerNode();
                    Rectangle2D.Double search = new Rectangle2D.Double(mi.loc.getX(), mi.loc.getY(), 0.0, 0.0);
                    Iterator<RTBounds> it = this.cell.searchIterator(search);
                    block5: while (it.hasNext()) {
                        NodeInst ni;
                        Geometric geom = (Geometric)it.next();
                        if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != theProto) continue;
                        Rectangle2D pointBounds = ni.getBounds();
                        double cX = pointBounds.getCenterX();
                        double cY = pointBounds.getCenterY();
                        EPoint[] trace = ni.getTrace();
                        if (trace != null) {
                            Point2D[] newPoints = new Point2D[trace.length];
                            for (int i = 0; i < trace.length; ++i) {
                                if (trace[i] == null) continue;
                                newPoints[i] = new Point2D.Double(trace[i].getX() + cX, trace[i].getY() + cY);
                            }
                            PolyBase poly = new PolyBase(newPoints);
                            poly.transform(ni.rotateOut());
                            if (!poly.contains(mi.loc)) continue;
                            GeometryHandler thisMerge = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
                            thisMerge.add(theLayer, poly);
                            thisMerge.postProcess(true);
                            Collection<PolyBase> set = ((PolySweepMerge)thisMerge).getPolyPartition(theLayer);
                            for (PolyBase simplePoly : set) {
                                Rectangle2D polyBounds = simplePoly.getBounds2D();
                                if (!polyBounds.contains(mi.loc)) continue;
                                mi.loc.setLocation(polyBounds.getCenterX(), polyBounds.getCenterY());
                                break block5;
                            }
                            break;
                        }
                        if (!pointBounds.contains(mi.loc)) continue;
                        mi.loc.setLocation(cX, cY);
                        break;
                    }
                    if ((scaledResolution = this.tech.getFactoryScaledResolution()) > 0.0) {
                        double x = (double)Math.round(mi.loc.getX() / scaledResolution) * scaledResolution;
                        double y = (double)Math.round(mi.loc.getY() / scaledResolution) * scaledResolution;
                        mi.loc.setLocation(x, y);
                    }
                }
                if (!mi.instantiate(this.cell, exportUnify, exportNames, null)) continue;
                ++renamed;
            }
            for (UnknownLayerMessage ulm : this.allErrorInsts.keySet()) {
                ArrayList instantiated = new ArrayList();
                List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                for (MakeInstance mi : errorList) {
                    Cell subCell2;
                    CellBuilder cellBuilder2;
                    if (mi == null) continue;
                    if (countOff && ++count % 1000 == 0) {
                        System.out.println("        Made " + count + " instances");
                    }
                    if (mi.proto instanceof Cell && (cellBuilder2 = allBuilders.get(subCell2 = (Cell)mi.proto)) != null) {
                        cellBuilder2.makeInstances(builtCells);
                    }
                    if (!mi.instantiate(this.cell, exportUnify, exportNames, instantiated)) continue;
                    ++renamed;
                }
                String msg = "Cell " + this.cell.noLibDescribe() + ": " + ulm.message;
                TreeSet<Cell> cellsWithError = (TreeSet<Cell>)cellLayerErrors.get(ulm);
                if (cellsWithError == null) {
                    cellsWithError = new TreeSet<Cell>();
                    cellLayerErrors.put(ulm, cellsWithError);
                }
                cellsWithError.add(this.cell);
                Input.errorLogger.logMessage(msg, instantiated, this.cell, -1, true);
            }
            HashMap massiveMerge = new HashMap();
            for (MakeInstanceArray mia : this.instArrays) {
                Cell subCell3;
                CellBuilder cellBuilder3;
                if (countOff && ++count % 1000 == 0) {
                    System.out.println("        Made " + count + " instances");
                }
                if (mia.proto instanceof Cell && (cellBuilder3 = allBuilders.get(subCell3 = (Cell)mia.proto)) != null) {
                    cellBuilder3.makeInstances(builtCells);
                }
                mia.instantiate(this, this.cell, massiveMerge);
            }
            ArrayList<NodeProto> mergeNodeSet = new ArrayList<NodeProto>();
            for (NodeProto np : massiveMerge.keySet()) {
                mergeNodeSet.add(np);
            }
            for (NodeProto np : mergeNodeSet) {
                List points = (List)massiveMerge.get(np);
                GDS.buildComplexNode(points, np, this.cell);
            }
            if (renamed > 0) {
                System.out.println("Cell " + this.cell.describe(false) + ": Renamed and NCC-unified " + renamed + " exports with duplicate names");
                HashMap<String, String> unifyStrings = new HashMap<String, String>();
                Set finalNames = exportUnify.keySet();
                for (String finalName : finalNames) {
                    String singleName = (String)exportUnify.get(finalName);
                    String us = (String)unifyStrings.get(singleName);
                    if (us == null) {
                        us = singleName;
                    }
                    us = us + " " + finalName;
                    unifyStrings.put(singleName, us);
                }
                ArrayList<String> annotations = new ArrayList<String>();
                for (String us : unifyStrings.keySet()) {
                    annotations.add("exportsConnectedByParent " + (String)unifyStrings.get(us));
                }
                if (annotations.size() > 0) {
                    String[] anArr = new String[annotations.size()];
                    for (int i = 0; i < annotations.size(); ++i) {
                        anArr[i] = (String)annotations.get(i);
                    }
                    TextDescriptor td = TextDescriptor.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                    this.cell.newVar(NccCellAnnotations.NCC_ANNOTATION_KEY, (Object)anArr, td);
                }
            }
            if (this.localPrefs.simplifyCells) {
                this.simplifyNodes(this.cell, this.tech);
            }
            builtCells.add(this.cell);
        }

        private void simplifyNodes(Cell cell, Technology tech) {
            HashMap<Layer, ArrayList<NodeInst>> map = new HashMap<Layer, ArrayList<NodeInst>>();
            Iterator<NodeInst> itNi = cell.getNodes();
            while (itNi.hasNext()) {
                PrimitiveNode pn;
                NodeInst ni = itNi.next();
                if (!(ni.getProto() instanceof PrimitiveNode) || (pn = (PrimitiveNode)ni.getProto()).getFunction() != PrimitiveNode.Function.NODE) continue;
                Layer layer = pn.getLayerIterator().next();
                ArrayList<NodeInst> list = (ArrayList<NodeInst>)map.get(layer);
                if (list == null) {
                    list = new ArrayList<NodeInst>();
                    map.put(layer, list);
                }
                list.add(ni);
            }
            HashSet<NodeInst> toDelete = new HashSet<NodeInst>();
            HashSet<NodeInst> viaToDelete = new HashSet<NodeInst>();
            ArrayList<NodeInst> geomList = new ArrayList<NodeInst>();
            Iterator<PrimitiveNode> itPn = tech.getNodes();
            while (itPn.hasNext()) {
                PrimitiveNode pn = itPn.next();
                boolean allFound = true;
                if (!pn.getFunction().isContact()) continue;
                Layer m1Layer = null;
                Layer m2Layer = null;
                Layer viaLayer = null;
                SizeOffset so = pn.getProtoSizeOffset();
                Iterator<Layer> itLa = pn.getLayerIterator();
                while (itLa.hasNext()) {
                    Layer l = itLa.next();
                    if (map.get(l) == null) {
                        allFound = false;
                        break;
                    }
                    if (l.getFunction().isMetal()) {
                        if (m1Layer == null) {
                            m1Layer = l;
                            continue;
                        }
                        m2Layer = l;
                        continue;
                    }
                    if (!l.getFunction().isContact()) continue;
                    viaLayer = l;
                }
                if (!allFound || viaLayer == null) continue;
                assert (m1Layer != null);
                List list = (List)map.get(m1Layer);
                assert (list != null);
                Layer.Function.Set thisLayer = new Layer.Function.Set(viaLayer.getFunction());
                List viasList = (List)map.get(viaLayer);
                for (NodeInst ni : list) {
                    Poly[] polys = tech.getShapeOfNode(ni, true, false, null);
                    assert (polys.length == 1);
                    Poly m1P = polys[0];
                    List nList = (List)map.get(m2Layer);
                    if (nList == null) continue;
                    for (NodeInst n : nList) {
                        Poly[] otherPolys = tech.getShapeOfNode(n, true, false, null);
                        assert (otherPolys.length == 1);
                        Poly m2P = otherPolys[0];
                        if (!m2P.getBounds2D().equals(m1P.getBounds2D())) continue;
                        ImmutableNodeInst d = ni.getD();
                        String name = ni.getName();
                        int atIndex = name.indexOf(64);
                        name = atIndex < 0 ? name + "tmp" : name.substring(0, atIndex) + "tmp" + name.substring(atIndex);
                        NodeInst newNi = NodeInst.makeInstance(pn, d.anchor, m2P.getBounds2D().getWidth() + so.getLowXOffset() + so.getHighXOffset(), m2P.getBounds2D().getHeight() + so.getLowYOffset() + so.getHighYOffset(), ni.getParent(), ni.getOrient(), name);
                        if (newNi == null) continue;
                        assert (viasList != null);
                        Poly[] viaPolys = tech.getShapeOfNode(newNi, true, false, thisLayer);
                        boolean found = false;
                        viaToDelete.clear();
                        for (int i = 0; i < viaPolys.length; ++i) {
                            Poly poly = viaPolys[i];
                            Rectangle2D bb = poly.getBounds2D();
                            bb.setRect(ERectangle.fromLambda(bb));
                            found = false;
                            for (NodeInst viaNi : viasList) {
                                Poly[] thisViaList = tech.getShapeOfNode(viaNi, true, false, thisLayer);
                                assert (thisViaList.length == 1);
                                Poly p = thisViaList[0];
                                Rectangle2D b = p.getBounds2D();
                                b.setRect(ERectangle.fromLambda(b));
                                if (!thisViaList[0].polySame(poly)) continue;
                                viaToDelete.add(viaNi);
                                assert (!found);
                                found = true;
                            }
                            if (!found) break;
                        }
                        if (!found) {
                            newNi.kill();
                            continue;
                        }
                        toDelete.clear();
                        geomList.clear();
                        toDelete.add(ni);
                        toDelete.add(n);
                        toDelete.addAll(viaToDelete);
                        String message = toDelete.size() + " nodes were replaced for more complex primitives in cell '" + cell.getName() + "'";
                        geomList.add(newNi);
                        Input.errorLogger.logMessage(message, geomList, cell, -1, false);
                        cell.killNodes(toDelete);
                    }
                }
            }
        }

        private void nameInstances(boolean countOff) {
            HashMap<String, GenMath.MutableInteger> maxSuffixes = new HashMap<String, GenMath.MutableInteger>();
            HashSet<String> userNames = new HashSet<String>();
            GenMath.MutableInteger count = new GenMath.MutableInteger(0);
            for (MakeInstance mi : this.insts) {
                this.nameInstance(mi, countOff, count, userNames, maxSuffixes);
            }
            for (UnknownLayerMessage ulm : this.allErrorInsts.keySet()) {
                List<MakeInstance> errorList = this.allErrorInsts.get(ulm);
                for (MakeInstance mi : errorList) {
                    if (mi == null) continue;
                    this.nameInstance(mi, countOff, count, userNames, maxSuffixes);
                }
            }
        }

        private void nameInstance(MakeInstance mi, boolean countOff, GenMath.MutableInteger count, Set<String> userNames, Map<String, GenMath.MutableInteger> maxSuffixes) {
            Name baseName;
            count.increment();
            if (countOff && count.intValue() % 2000 == 0) {
                System.out.println("        Named " + count + " instances");
            }
            if (mi.nodeName != null) {
                if (!this.validGdsNodeName(mi.nodeName)) {
                    System.out.println("  Warning: Node name '" + mi.nodeName + "' in cell " + this.cell.describe(false) + " is bad (" + Name.checkName(mi.nodeName.toString()) + ")...ignoring the name");
                } else if (!userNames.contains(mi.nodeName.toString())) {
                    userNames.add(mi.nodeName.toString());
                    return;
                }
            }
            if (mi.proto instanceof Cell) {
                baseName = ((Cell)mi.proto).getBasename();
            } else {
                PrimitiveNode np = (PrimitiveNode)mi.proto;
                baseName = np.getFunction().getBasename();
            }
            String basenameString = baseName.toString();
            GenMath.MutableInteger maxSuffix = maxSuffixes.get(basenameString);
            if (maxSuffix == null) {
                maxSuffix = new GenMath.MutableInteger(-1);
                maxSuffixes.put(basenameString, maxSuffix);
            }
            maxSuffix.increment();
            mi.nodeName = baseName.findSuffixed(maxSuffix.intValue());
        }

        private boolean validGdsNodeName(Name name) {
            return name.isValid() && !name.hasEmptySubnames() && !name.isBus() || !name.isTempname();
        }

        private static void buildInstances() {
            HashSet<Cell> builtCells = new HashSet<Cell>();
            for (CellBuilder cellBuilder : allBuilders.values()) {
                cellBuilder.makeInstances(builtCells);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GDSPreferences
    extends Input.InputPreferences {
        public double inputScale;
        public boolean simplifyCells;
        public int arraySimplification;
        public boolean instantiateArrays;
        public boolean expandCells;
        public boolean mergeBoxes;
        public boolean includeText;
        public int unknownLayerHandling;
        public boolean cadenceCompatibility;

        public GDSPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public void initFromUserDefaults() {
            this.inputScale = IOTool.getGDSInputScale();
            this.simplifyCells = IOTool.isGDSInSimplifyCells();
            this.arraySimplification = IOTool.getGDSArraySimplification();
            this.instantiateArrays = IOTool.isGDSInInstantiatesArrays();
            this.expandCells = IOTool.isGDSInExpandsCells();
            this.mergeBoxes = IOTool.isGDSInMergesBoxes();
            this.includeText = IOTool.isGDSInIncludesText();
            this.unknownLayerHandling = IOTool.getGDSInUnknownLayerHandling();
            this.cadenceCompatibility = IOTool.isGDSCadenceCompatibility();
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            GDS in = new GDS(this);
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
            HashSet<Library> oldLibs = new HashSet<Library>();
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                oldLibs.add(it.next());
            }
            oldLibs.remove(lib);
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            if (this.expandCells) {
                EDatabase database = EDatabase.currentDatabase();
                Iterator<Library> it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library l = it2.next();
                    if (oldLibs.contains(l)) continue;
                    Iterator<Cell> cit = l.getCells();
                    while (cit.hasNext()) {
                        Cell cell = cit.next();
                        Iterator<NodeInst> nit = cell.getNodes();
                        while (nit.hasNext()) {
                            NodeInst ni = nit.next();
                            if (!ni.isCellInstance()) continue;
                            database.addToNodes(nodesToExpand, ni);
                        }
                    }
                }
            }
            return lib;
        }
    }

    private static class GSymbol {
        private int value;
        private static List<GSymbol> symbols = new ArrayList<GSymbol>();

        private GSymbol(int value) {
            this.value = value;
            symbols.add(this);
        }

        private static GSymbol findSymbol(int value) {
            for (GSymbol gs : symbols) {
                if (gs.value != value) continue;
                return gs;
            }
            return null;
        }
    }

    private static class DatatypeSymbol {
        private DatatypeSymbol() {
        }
    }

    private static class ShapeType {
        private ShapeType() {
        }
    }
}

