/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.result.PartReport;
import com.sun.electric.tool.ncc.result.SizeMismatch;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.HighlightTools;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class SizeMismatchPane
extends JPanel
implements HyperlinkListener,
AdjustmentListener {
    public static final int MAXROWS = 200;
    private static final Border border = BorderFactory.createEmptyBorder();
    private static final Insets insets = new Insets(0, 0, 0, 0);
    private static final int HALF_INF = 0x3FFFFFFF;
    private Dimension dimErrCol;
    private Dimension dimWidCol;
    private Dimension dimLenCol;
    private JScrollPane headScrPane;
    private Color bkgndColor;
    private Font font = new Font("Helvetica", 0, 12);
    private NccGuiInfo result;
    private SizeMismatch.Mismatch[] mismatches;
    private PartReport[][] parts;

    public SizeMismatchPane(NccGuiInfo res) {
        super(new BorderLayout());
        this.result = res;
        this.mismatches = this.result.getSizeMismatches().toArray(new SizeMismatch.Mismatch[0]);
        int size2 = Math.min(this.mismatches.length, 200);
        if (size2 == 0) {
            return;
        }
        this.parts = new PartReport[size2][2];
        int errColWidth = 7;
        int widColWidth = 3;
        int lenColWidth = 3;
        for (int i = 0; i < size2; ++i) {
            String err2 = NccUtils.round(this.mismatches[i].relErr() * 100.0, 1) + "";
            errColWidth = Math.max(errColWidth, err2.length());
            String w1 = NccUtils.round(this.mismatches[i].minPart.getWidth(), 2) + "";
            String w2 = NccUtils.round(this.mismatches[i].maxPart.getWidth(), 2) + "";
            int wid = Math.max(w1.length(), w2.length());
            widColWidth = Math.max(widColWidth, wid + 1);
            String l1 = NccUtils.round(this.mismatches[i].minPart.getLength(), 2) + "";
            String l2 = NccUtils.round(this.mismatches[i].maxPart.getLength(), 2) + "";
            int len = Math.max(l1.length(), l2.length());
            lenColWidth = Math.max(lenColWidth, len + 1);
        }
        this.dimErrCol = new Dimension(errColWidth * 7, 20);
        this.dimWidCol = new Dimension(widColWidth * 7, 16);
        this.dimLenCol = new Dimension(lenColWidth * 7, 16);
        JSeparator sep = new JSeparator(0);
        Box topBox = new Box(1);
        topBox.setAlignmentY(0.0f);
        sep.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
        int maxRowWid = 0;
        for (int i = 0; i < size2; ++i) {
            JPanel row = this.createRow(i);
            maxRowWid = Math.max(maxRowWid, row.getPreferredSize().width + 16);
            topBox.add(row);
            topBox.add(Box.createVerticalStrut(2));
            topBox.add(sep);
            topBox.add(Box.createVerticalStrut(2));
        }
        JScrollPane bodyScrPane = new JScrollPane(topBox);
        bodyScrPane.setBorder(border);
        bodyScrPane.setAlignmentX(0.0f);
        bodyScrPane.setAlignmentY(0.0f);
        bodyScrPane.getHorizontalScrollBar().addAdjustmentListener(this);
        JPanel header = this.createRow(-1);
        Dimension dim = header.getPreferredSize();
        dim.width = maxRowWid;
        header.setPreferredSize(dim);
        Box headBox = new Box(1);
        headBox.add(header);
        headBox.add(Box.createVerticalStrut(2));
        headBox.add(sep);
        headBox.add(Box.createVerticalStrut(2));
        this.headScrPane = new JScrollPane(headBox, 21, 31);
        this.headScrPane.setBorder(border);
        this.headScrPane.setAlignmentX(0.0f);
        this.headScrPane.setAlignmentY(0.0f);
        this.add((Component)this.headScrPane, "North");
        this.add((Component)bodyScrPane, "Center");
        this.setBorder(border);
        JScrollBar scrBar = bodyScrPane.getVerticalScrollBar();
        scrBar.invalidate();
        scrBar.validate();
        scrBar.setValue(scrBar.getMinimum());
    }

    private JPanel createRow(int rowNdx) {
        String relErr;
        JPanel row = new JPanel(new BorderLayout());
        if (rowNdx < 0) {
            this.bkgndColor = row.getBackground();
            relErr = "Error,%";
        } else {
            this.bkgndColor = Color.WHITE;
            row.setBackground(this.bkgndColor);
            int firstCellNdx = 0;
            if (this.result.isSwapCells()) {
                firstCellNdx = 1;
            }
            if (this.mismatches[rowNdx].minNdx == firstCellNdx) {
                this.parts[rowNdx][0] = this.mismatches[rowNdx].minPart;
                this.parts[rowNdx][1] = this.mismatches[rowNdx].maxPart;
            } else {
                this.parts[rowNdx][1] = this.mismatches[rowNdx].minPart;
                this.parts[rowNdx][0] = this.mismatches[rowNdx].maxPart;
            }
            relErr = this.mismatches[rowNdx].relErr() * 100.0 < 0.1 ? "< 0.01" : NccUtils.round(this.mismatches[rowNdx].relErr() * 100.0, 1) + "";
        }
        JLabel errLabel = new JLabel(relErr);
        errLabel.setHorizontalAlignment(4);
        errLabel.setMinimumSize(this.dimErrCol);
        errLabel.setMaximumSize(this.dimErrCol);
        errLabel.setPreferredSize(this.dimErrCol);
        errLabel.setFont(this.font);
        errLabel.setBorder(border);
        JPanel errPanel = new JPanel();
        errPanel.setLayout(new BoxLayout(errPanel, 0));
        errPanel.add(Box.createHorizontalStrut(4));
        errPanel.add(errLabel);
        errPanel.add(Box.createHorizontalStrut(4));
        errPanel.add(new JSeparator(1));
        errPanel.add(Box.createHorizontalStrut(2));
        errPanel.setBackground(this.bkgndColor);
        Box subRowsPanel = new Box(1);
        Dimension[] paramDims = new Dimension[]{this.dimWidCol, this.dimLenCol};
        String[] params = new String[2];
        for (int line = 0; line < 2; ++line) {
            String name;
            if (rowNdx < 0) {
                params[0] = "Wid";
                params[1] = "Len";
                String[] titles = this.result.getNames();
                name = "Name in " + titles[line];
            } else {
                params[0] = NccUtils.round(this.parts[rowNdx][line].getWidth(), 2) + "";
                params[1] = NccUtils.round(this.parts[rowNdx][line].getLength(), 2) + "";
                name = this.parts[rowNdx][line].instanceDescription();
            }
            JPanel subRow = this.createSubRow(params, paramDims, name, rowNdx, line);
            subRow.setBackground(this.bkgndColor);
            subRowsPanel.add(subRow);
        }
        row.add((Component)errPanel, "West");
        row.add((Component)subRowsPanel, "Center");
        Dimension dim = new Dimension(row.getPreferredSize());
        dim.width = 0x3FFFFFFF;
        row.setMaximumSize(dim);
        row.setAlignmentX(0.0f);
        row.setAlignmentY(0.0f);
        return row;
    }

    private JPanel createSubRow(String[] params, Dimension[] paramDims, String name, int rowNdx, int lineNdx) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setBorder(border);
        panel.setBackground(this.bkgndColor);
        for (int i = 0; i < 2; ++i) {
            JLabel label = new JLabel(params[i]);
            label.setHorizontalAlignment(11);
            label.setFont(this.font);
            if (rowNdx >= 0) {
                boolean red;
                boolean bl = red = i == 0 && this.mismatches[rowNdx] instanceof SizeMismatch.WidthMismatch || i == 1 && this.mismatches[rowNdx] instanceof SizeMismatch.LengthMismatch;
                if (red) {
                    label.setForeground(Color.RED);
                }
            }
            label.setBorder(border);
            label.setMinimumSize(paramDims[i]);
            label.setMaximumSize(paramDims[i]);
            label.setPreferredSize(paramDims[i]);
            if (rowNdx >= 0) {
                label.setAlignmentY(1.0f);
                label.setVerticalAlignment(3);
                label.setVerticalTextPosition(3);
            }
            panel.add(label);
        }
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.createNamePane(name, rowNdx, lineNdx));
        return panel;
    }

    private JComponent createNamePane(String name, int rowNdx, int lineNdx) {
        int ind;
        StringBuffer text2 = new StringBuffer(128);
        String href = "<a style=\"text-decoration: none;\" href=\"";
        text2.append("<html><font size=3><font face=\"Helvetica, TimesRoman\">");
        if (rowNdx < 0) {
            JLabel label = new JLabel(name);
            label.setFont(this.font);
            label.setBorder(border);
            return label;
        }
        if (name.startsWith("Wire: ") || name.startsWith("Part: ")) {
            name = name.substring(6);
        }
        if ((ind = name.indexOf(" Cell instance:")) > 0) {
            name = name.substring(0, ind).trim();
        }
        if (name.endsWith("{sch}") || name.endsWith("{lay}")) {
            name = name.substring(0, name.length() - 5);
        }
        text2.append(href + (rowNdx * 10 + lineNdx) + "\">" + name + "</a>");
        text2.append("</font></html>");
        JEditorPane pane = new JEditorPane();
        pane.setBackground(this.bkgndColor);
        pane.setEditable(false);
        pane.addHyperlinkListener(this);
        pane.setContentType("text/html");
        pane.setText(text2.toString());
        pane.setMargin(insets);
        pane.setBorder(border);
        pane.moveCaretPosition(0);
        return pane;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.highlight(Integer.parseInt(event.getDescription()));
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.headScrPane.getHorizontalScrollBar().setValue(e.getValue());
    }

    private void highlight(int index) {
        VarContext context;
        int row = index / 10;
        int col = index % 2;
        PartReport part = this.parts[row][col];
        Cell cell = part.getNameProxy().leafCell();
        Highlighter highlighter = HighlightTools.getHighlighter(cell, context = part.getNameProxy().getContext());
        if (highlighter == null) {
            return;
        }
        HighlightTools.highlightPart(highlighter, cell, part);
        highlighter.finished();
    }
}

