/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.ExternalEditing;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class TopLevel
extends JFrame {
    private static final boolean MDIINITIALRESIZE = true;
    private static UserInterfaceMain.Mode mode;
    private static JDesktopPane desktop;
    private static TopLevel topLevel;
    private static Dimension scrnSize;
    private static int doubleClickDelay;
    private static Cursor cursor;
    private static boolean busyCursorOn;
    private static Set<Window> modelessDialogs;
    private static WindowAdapter onTopWindowAdapter;
    private StatusBar sb = null;
    private EMenuBar.Instance menuBar;
    private ToolBar toolBar;
    private static Pref cacheWindowLoc;

    public TopLevel(String name, Rectangle bound, WindowFrame frame, GraphicsConfiguration gc, boolean createStructure) {
        super(name, gc);
        this.setLocation(bound.x, bound.y);
        this.setSize(bound.width, bound.height);
        this.getContentPane().setLayout(new BorderLayout());
        this.setIconImage(TopLevel.getFrameIcon().getImage());
        if (createStructure) {
            this.createStructure(frame);
        }
        if (TopLevel.isMDIMode()) {
            this.addWindowListener(new WindowsEvents());
            this.setDefaultCloseOperation(0);
            this.addComponentListener(new ReshapeComponentAdapter());
        } else {
            this.setDefaultCloseOperation(0);
        }
        this.addWindowFocusListener(onTopWindowAdapter);
        cursor = Cursor.getPredefinedCursor(0);
        try {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            this.enableEvents(64L);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    public static void addModelessDialog(Window dialog) {
        modelessDialogs.add(dialog);
    }

    public static void removeModelessDialog(JFrame dialog) {
        modelessDialogs.remove(dialog);
    }

    public void createStructure(WindowFrame frame) {
        try {
            this.menuBar = MenuCommands.menuBar().genInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setJMenuBar(this.menuBar);
        this.toolBar = ToolBar.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.sb = new StatusBar(frame);
        this.getContentPane().add((Component)this.sb, "South");
    }

    public static ImageIcon getFrameIcon() {
        return Resources.getResource(TopLevel.class, "IconElectric.gif");
    }

    public static void InitializeMessagesWindow() {
        if (TopLevel.isMDIMode()) {
            String loc = cacheWindowLoc.getString();
            Rectangle bound = TopLevel.parseBound(loc);
            if (bound == null) {
                bound = new Rectangle(scrnSize);
            }
            --bound.width;
            desktop = new JDesktopPane();
            try {
                topLevel = new TopLevel("Electric", bound, null, null, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            topLevel.getContentPane().add((Component)desktop, "Center");
            topLevel.setVisible(true);
        }
        MessagesWindow.init();
    }

    public static void InitializeWindows() {
        if (TopLevel.isMDIMode()) {
            topLevel.createStructure(null);
        }
        WindowFrame.createEditWindow(null);
        FileMenu.updateRecentlyOpenedLibrariesList();
        if (TopLevel.isMDIMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dimension old = topLevel.getSize();
                    topLevel.setSize(new Dimension(old.width + 1, old.height));
                }
            });
        }
    }

    public static void OSInitialize(UserInterfaceMain.Mode mode) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        scrnSize = tk.getScreenSize();
        Object click = tk.getDesktopProperty("awt.multiClickInterval");
        doubleClickDelay = click == null ? 500 : Integer.parseInt(click.toString());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (gs.length > 0) {
            GraphicsDevice gd = gs[0];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle r = gc.getBounds();
            scrnSize.setSize(r.width, r.height);
        }
        UserInterfaceMain.Mode osMode = null;
        Client.OS os = Client.getOperatingSystem();
        try {
            switch (os) {
                case WINDOWS: {
                    osMode = UserInterfaceMain.Mode.MDI;
                    TopLevel.scrnSize.height -= 30;
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    break;
                }
                case UNIX: {
                    osMode = UserInterfaceMain.Mode.SDI;
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    break;
                }
                case MACINTOSH: {
                    osMode = UserInterfaceMain.Mode.SDI;
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.MacLookAndFeel");
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        TopLevel.mode = mode == null ? osMode : mode;
        if (os == Client.OS.UNIX) {
            User.setWorkingDirectory(System.getProperty("user.dir"));
        }
    }

    private static Rectangle parseBound(String loc) {
        int lowX = TextUtils.atoi(loc);
        int commaPos = loc.indexOf(44);
        if (commaPos < 0) {
            return null;
        }
        int lowY = TextUtils.atoi(loc.substring(commaPos + 1));
        int spacePos = loc.indexOf(32);
        if (spacePos < 0) {
            return null;
        }
        int width = TextUtils.atoi(loc.substring(spacePos + 1));
        int xPos = loc.indexOf(120);
        if (xPos < 0) {
            return null;
        }
        int height = TextUtils.atoi(loc.substring(xPos + 1));
        return new Rectangle(lowX, lowY, width, height);
    }

    public static boolean isMDIMode() {
        return mode == UserInterfaceMain.Mode.MDI;
    }

    public StatusBar getStatusBar() {
        return this.sb;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public EMenuBar.Instance getTheMenuBar() {
        return this.menuBar;
    }

    public EMenuBar getEMenuBar() {
        return this.menuBar.getMenuBarGroup();
    }

    public static int getDoubleClickSpeed() {
        return doubleClickDelay;
    }

    public static Dimension getScreenSize() {
        if (TopLevel.isMDIMode()) {
            Rectangle bounds = topLevel.getBounds();
            Rectangle dBounds = desktop.getBounds();
            if (dBounds.width != 0 && dBounds.height != 0) {
                return new Dimension(dBounds.width, dBounds.height);
            }
            return new Dimension(bounds.width - 8, bounds.height - 96);
        }
        return new Dimension(scrnSize);
    }

    public static void addToDesktop(JInternalFrame jif) {
        if (desktop.isVisible() && !Job.isClientThread()) {
            SwingUtilities.invokeLater(new ModifyToDesktopSafe(jif, true));
        } else {
            new ModifyToDesktopSafe(jif, true).run();
        }
    }

    public static void removeFromDesktop(JInternalFrame jif) {
        if (desktop.isVisible() && !Job.isClientThread()) {
            SwingUtilities.invokeLater(new ModifyToDesktopSafe(jif, false));
        } else {
            new ModifyToDesktopSafe(jif, false).run();
        }
    }

    public static Cursor getCurrentCursor() {
        return cursor;
    }

    public static synchronized void setCurrentCursor(Cursor cursor) {
        TopLevel.cursor = cursor;
        TopLevel.setCurrentCursorPrivate(cursor);
    }

    private static synchronized void setCurrentCursorPrivate(Cursor cursor) {
        TopLevel jf;
        if (mode == UserInterfaceMain.Mode.MDI && (jf = TopLevel.getCurrentJFrame()) != null) {
            jf.setCursor(cursor);
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.setCursor(cursor);
        }
    }

    public static synchronized List<ToolBar> getToolBars() {
        ArrayList<ToolBar> toolBars = new ArrayList<ToolBar>();
        if (mode == UserInterfaceMain.Mode.MDI) {
            toolBars.add(topLevel.getToolBar());
        } else {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                toolBars.add(wf.getFrame().getToolBar());
            }
        }
        return toolBars;
    }

    public static synchronized List<EMenuBar.Instance> getMenuBars() {
        ArrayList<EMenuBar.Instance> menuBars = new ArrayList<EMenuBar.Instance>();
        if (mode == UserInterfaceMain.Mode.MDI) {
            if (topLevel != null && topLevel.getTheMenuBar() != null) {
                menuBars.add(topLevel.getTheMenuBar());
            }
        } else {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                menuBars.add(wf.getFrame().getTheMenuBar());
            }
        }
        return menuBars;
    }

    public static synchronized void setBusyCursor(boolean on) {
        if (on) {
            if (!busyCursorOn) {
                TopLevel.setCurrentCursorPrivate(Cursor.getPredefinedCursor(3));
            }
            busyCursorOn = true;
        } else {
            if (busyCursorOn) {
                TopLevel.setCurrentCursorPrivate(TopLevel.getCurrentCursor());
            }
            busyCursorOn = false;
        }
    }

    public static TopLevel getCurrentJFrame() {
        return TopLevel.getCurrentJFrame(true);
    }

    public static TopLevel getCurrentJFrame(boolean makeNewFrame) {
        if (TopLevel.isMDIMode()) {
            return topLevel;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(makeNewFrame);
        if (wf == null) {
            return null;
        }
        return wf.getFrame();
    }

    public void finished() {
        this.setJMenuBar(null);
        this.removeWindowFocusListener(onTopWindowAdapter);
        this.menuBar.finished();
        this.menuBar = null;
        Container container = this.getContentPane();
        if (container != null) {
            container.remove(this.toolBar);
        }
        this.toolBar.finished();
        this.toolBar = null;
        if (container != null) {
            container.remove(this.sb);
        }
        this.sb.finished();
        this.sb = null;
        super.dispose();
    }

    public static Rectangle[] getWindowAreas() {
        Rectangle[] areas;
        if (TopLevel.isMDIMode()) {
            TopLevel tl = TopLevel.getCurrentJFrame();
            Dimension sz = tl.getContentPane().getSize();
            areas = new Rectangle[]{new Rectangle(0, 0, sz.width, sz.height)};
        } else {
            areas = TopLevel.getDisplays();
        }
        return areas;
    }

    public static Rectangle[] getDisplays() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle[] areas = new Rectangle[gs.length];
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            areas[j] = gc.getBounds();
        }
        return areas;
    }

    public static void printError(boolean print, String msg) {
        if (print) {
            Throwable t = new Throwable(msg);
            System.out.println(t.toString());
            ActivityLogger.logException(t);
        }
    }

    static {
        desktop = null;
        topLevel = null;
        busyCursorOn = false;
        modelessDialogs = new HashSet<Window>();
        onTopWindowAdapter = new MyWindowAdapter();
        cacheWindowLoc = Pref.makeStringPref("WindowLocation", User.getUserTool().prefs, "");
    }

    private static class WindowsEvents
    extends WindowAdapter {
        WindowsEvents() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            FileMenu.quitCommand();
        }

        @Override
        public void windowActivated(WindowEvent evt) {
            ExternalEditing.updateEditors();
        }
    }

    private static class ReshapeComponentAdapter
    extends ComponentAdapter {
        private ReshapeComponentAdapter() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.saveLocation(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.saveLocation(e);
        }

        private void saveLocation(ComponentEvent e) {
            TopLevel frame = (TopLevel)e.getSource();
            Rectangle bounds = frame.getBounds();
            cacheWindowLoc.setString(bounds.getMinX() + "," + bounds.getMinY() + " " + bounds.getWidth() + "x" + bounds.getHeight());
        }
    }

    private static class ModifyToDesktopSafe
    implements Runnable {
        private JInternalFrame jif;
        private boolean add;

        private ModifyToDesktopSafe(JInternalFrame jif, boolean add) {
            this.jif = jif;
            this.add = add;
        }

        @Override
        public void run() {
            if (this.add) {
                desktop.add(this.jif);
                try {
                    this.jif.show();
                }
                catch (ClassCastException e) {
                    System.out.println("ERROR: Could not show new window: " + e.getMessage());
                }
            } else {
                desktop.remove(this.jif);
            }
        }
    }

    private static class MyWindowAdapter
    extends WindowAdapter {
        private MyWindowAdapter() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            if (!User.isKeepModelessDialogsOnTop()) {
                return;
            }
            for (Window jf : modelessDialogs) {
                if (!jf.isVisible()) continue;
                jf.toFront();
            }
        }
    }
}

