/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.als;

import com.sun.electric.tool.simulation.als.ALS;
import java.util.Iterator;

public class UserCom {

    static class StateToBus
    extends ALS.UserProc {
        StateToBus(ALS als) {
            this.nameMe(als, "STATE_TO_BUS");
        }

        @Override
        void simulate(ALS.Model primHead) {
            Iterator<ALS.ALSExport> it = primHead.exList.iterator();
            ALS.ALSExport argPtr = it.next();
            int input2 = argPtr.nodePtr.sumState;
            for (int i = 7; i > -1; --i) {
                argPtr = it.next();
                int mask = 1 << i;
                if ((input2 & mask) != 0) {
                    this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(2), 12, this.als.timeAbs);
                    continue;
                }
                this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(0), 12, this.als.timeAbs);
            }
        }
    }

    static class BusToState
    extends ALS.UserProc {
        BusToState(ALS als) {
            this.nameMe(als, "BUS_TO_STATE");
        }

        @Override
        void simulate(ALS.Model primHead) {
            Iterator<ALS.ALSExport> it = primHead.exList.iterator();
            ALS.ALSExport argPtr = it.next();
            int state = 0;
            for (int i = 7; i > -1; --i) {
                int bit = argPtr.nodePtr.sumState;
                if (bit == 2) {
                    state += 1 << i;
                }
                argPtr = it.next();
            }
            this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(state), 12, this.als.timeAbs);
        }
    }

    static class DFFlop
    extends ALS.UserProc {
        DFFlop(ALS als) {
            this.nameMe(als, "DFFLOP");
        }

        @Override
        void simulate(ALS.Model primHead) {
            ALS.ALSExport argPtr = primHead.exList.get(0);
            int dIn = argPtr.nodePtr.sumState;
            argPtr = primHead.exList.get(1);
            int clk = argPtr.nodePtr.sumState;
            if (clk != 0) {
                return;
            }
            argPtr = primHead.exList.get(2);
            int q = dIn;
            this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(q), 8, this.als.timeAbs);
        }
    }

    static class JKFlop
    extends ALS.UserProc {
        JKFlop(ALS als) {
            this.nameMe(als, "JKFFLOP");
        }

        @Override
        void simulate(ALS.Model primHead) {
            ALS.ALSExport argPtr = primHead.exList.get(0);
            int ck = argPtr.nodePtr.sumState;
            if (ck != 0) {
                return;
            }
            argPtr = primHead.exList.get(1);
            int j = argPtr.nodePtr.sumState;
            argPtr = primHead.exList.get(2);
            int k = argPtr.nodePtr.sumState;
            argPtr = primHead.exList.get(3);
            ALS.ALSExport argPtrBar = primHead.exList.get(4);
            if (j == 0) {
                if (k == 0) {
                    return;
                }
                this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(0), 8, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, argPtrBar, 61, new Integer(2), 8, this.als.timeAbs);
                return;
            }
            if (k == 0) {
                this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(2), 8, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, argPtrBar, 61, new Integer(0), 8, this.als.timeAbs);
                return;
            }
            int out = argPtr.nodePtr.sumState;
            if (out == 2) {
                this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(0), 8, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, argPtrBar, 61, new Integer(2), 8, this.als.timeAbs);
            } else {
                this.scheduleNodeUpdate(primHead, argPtr, 61, new Integer(2), 8, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, argPtrBar, 61, new Integer(0), 8, this.als.timeAbs);
            }
        }
    }

    static class NMOSTranWeak
    extends ALS.UserProc {
        NMOSTranWeak(ALS als) {
            this.nameMe(als, "nMOStranWeak");
        }

        @Override
        void simulate(ALS.Model primHead) {
            ALS.ALSExport ctl = primHead.exList.get(0);
            ALS.ALSExport[] side = new ALS.ALSExport[]{primHead.exList.get(1), primHead.exList.get(2)};
            if (ctl.nodePtr.sumState == 0) {
                this.scheduleNodeUpdate(primHead, side[0], 61, new Integer(1), 0, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, side[1], 61, new Integer(1), 0, this.als.timeAbs);
                return;
            }
            this.calculateBidirOutputs(primHead, side, 4);
        }
    }

    static class NMOSTran
    extends ALS.UserProc {
        NMOSTran(ALS als) {
            this.nameMe(als, "nMOStran");
        }

        @Override
        void simulate(ALS.Model primHead) {
            ALS.ALSExport ctl = primHead.exList.get(0);
            ALS.ALSExport[] side = new ALS.ALSExport[]{primHead.exList.get(1), primHead.exList.get(2)};
            if (ctl.nodePtr.sumState == 0) {
                this.scheduleNodeUpdate(primHead, side[0], 61, new Integer(1), 0, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, side[1], 61, new Integer(1), 0, this.als.timeAbs);
                return;
            }
            this.calculateBidirOutputs(primHead, side, 8);
        }
    }

    static class PMOSTranWeak
    extends ALS.UserProc {
        PMOSTranWeak(ALS als) {
            this.nameMe(als, "pMOStranWeak");
        }

        @Override
        void simulate(ALS.Model primHead) {
            ALS.ALSExport ctl = primHead.exList.get(0);
            ALS.ALSExport[] side = new ALS.ALSExport[]{primHead.exList.get(1), primHead.exList.get(2)};
            if (ctl.nodePtr.sumState == 2) {
                this.scheduleNodeUpdate(primHead, side[0], 61, new Integer(1), 0, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, side[1], 61, new Integer(1), 0, this.als.timeAbs);
                return;
            }
            this.calculateBidirOutputs(primHead, side, 4);
        }
    }

    static class PMOSTran
    extends ALS.UserProc {
        PMOSTran(ALS als) {
            this.nameMe(als, "PMOStran");
        }

        @Override
        void simulate(ALS.Model primHead) {
            ALS.ALSExport ctl = primHead.exList.get(0);
            ALS.ALSExport[] side = new ALS.ALSExport[]{primHead.exList.get(1), primHead.exList.get(2)};
            if (ctl.nodePtr.sumState == 2) {
                this.scheduleNodeUpdate(primHead, side[0], 61, new Integer(1), 0, this.als.timeAbs);
                this.scheduleNodeUpdate(primHead, side[1], 61, new Integer(1), 0, this.als.timeAbs);
                return;
            }
            this.calculateBidirOutputs(primHead, side, 8);
        }
    }
}

