/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.jce;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.mode.IMode;
import gnu.crypto.mode.ModeFactory;
import gnu.crypto.pad.IPad;
import gnu.crypto.pad.PadFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TestOfCipher
implements Testlet {
    public void test(TestHarness harness) {
        this.setUp();
        this.testUnknownCipher(harness);
        this.testEquality(harness);
        this.testPadding(harness);
        this.testPartial(harness);
        this.testDoFinal(harness);
    }

    public void testUnknownCipher(TestHarness harness) {
        harness.checkPoint("testUnknownCipher");
        try {
            Cipher.getInstance("Godot", "GNU-CRYPTO");
            harness.fail("testUnknownCipher()");
        }
        catch (Exception x) {
            harness.check(true);
        }
    }

    public void testEquality(TestHarness harness) {
        harness.checkPoint("testEquality");
        String cipherName = null;
        IMode gnu = null;
        Cipher jce = null;
        HashMap<String, Object> attrib = new HashMap<String, Object>();
        byte[] pt = null;
        Object iv = null;
        byte[] ct1 = null;
        byte[] ct2 = null;
        byte[] cpt1 = null;
        byte[] cpt2 = null;
        try {
            Iterator ci = CipherFactory.getNames().iterator();
            while (ci.hasNext()) {
                cipherName = (String)ci.next();
                IBlockCipher cipher = CipherFactory.getInstance((String)cipherName);
                int bs = cipher.defaultBlockSize();
                Iterator mi = ModeFactory.getNames().iterator();
                while (mi.hasNext()) {
                    String modeName = (String)mi.next();
                    gnu = ModeFactory.getInstance((String)modeName, (IBlockCipher)cipher, (int)bs);
                    jce = Cipher.getInstance(cipherName + "/" + modeName + "/NoPadding", "GNU-CRYPTO");
                    pt = new byte[bs];
                    int i = 0;
                    while (i < bs) {
                        pt[i] = (byte)i;
                        ++i;
                    }
                    attrib.put("gnu.crypto.cipher.block.size", new Integer(bs));
                    attrib.put("gnu.crypto.mode.iv", pt);
                    Iterator ks = cipher.keySizes();
                    while (ks.hasNext()) {
                        byte[] kb = new byte[((Integer)ks.next()).intValue()];
                        int i2 = 0;
                        while (i2 < kb.length) {
                            kb[i2] = (byte)i2;
                            ++i2;
                        }
                        attrib.put("gnu.crypto.mode.state", new Integer(1));
                        attrib.put("gnu.crypto.cipher.key.material", kb);
                        gnu.reset();
                        gnu.init(attrib);
                        ct1 = new byte[bs];
                        gnu.update(pt, 0, ct1, 0);
                        jce.init(1, (Key)new SecretKeySpec(kb, cipherName), new IvParameterSpec(pt));
                        ct2 = new byte[bs];
                        jce.doFinal(pt, 0, bs, ct2, 0);
                        harness.check(Util.areEqual((byte[])ct1, (byte[])ct2), "testEquality(" + cipherName + ")");
                        attrib.put("gnu.crypto.mode.state", new Integer(2));
                        cpt1 = new byte[bs];
                        gnu.reset();
                        gnu.init(attrib);
                        gnu.update(ct1, 0, cpt1, 0);
                        harness.check(Util.areEqual((byte[])pt, (byte[])cpt1), "testEquality(" + cipherName + ")");
                        jce.init(2, (Key)new SecretKeySpec(kb, cipherName), new IvParameterSpec(pt));
                        cpt2 = new byte[bs];
                        jce.doFinal(ct2, 0, bs, cpt2, 0);
                        harness.check(Util.areEqual((byte[])pt, (byte[])cpt2), "testEquality(" + cipherName + ")");
                        harness.check(Util.areEqual((byte[])cpt1, (byte[])cpt2), "testEquality(" + cipherName + ")");
                    }
                }
            }
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testEquality(" + cipherName + "): " + String.valueOf(x));
        }
    }

    public void testPadding(TestHarness harness) {
        harness.checkPoint("testPadding");
        String padName = null;
        IMode gnu = ModeFactory.getInstance((String)"ECB", (String)"AES", (int)16);
        IPad pad = null;
        Cipher jce = null;
        byte[] kb = new byte[32];
        int i = 0;
        while (i < kb.length) {
            kb[i] = (byte)i;
            ++i;
        }
        byte[] pt = new byte[42];
        int i2 = 0;
        while (i2 < pt.length) {
            pt[i2] = (byte)i2;
            ++i2;
        }
        byte[] ppt = new byte[48];
        System.arraycopy(pt, 0, ppt, 0, 42);
        byte[] ct1 = new byte[48];
        byte[] ct2 = new byte[48];
        byte[] cpt1 = new byte[42];
        byte[] cpt2 = new byte[42];
        HashMap<String, Object> attrib = new HashMap<String, Object>();
        attrib.put("gnu.crypto.cipher.key.material", kb);
        try {
            Iterator it = PadFactory.getNames().iterator();
            while (it.hasNext()) {
                padName = (String)it.next();
                pad = PadFactory.getInstance((String)padName);
                pad.reset();
                pad.init(16);
                byte[] padding = pad.pad(pt, 0, pt.length);
                System.arraycopy(padding, 0, ppt, 42, padding.length);
                attrib.put("gnu.crypto.mode.state", new Integer(1));
                gnu.reset();
                gnu.init(attrib);
                int i3 = 0;
                while (i3 < ppt.length) {
                    gnu.update(ppt, i3, ct1, i3);
                    i3 += 16;
                }
                jce = Cipher.getInstance("AES/ECB/" + padName, "GNU-CRYPTO");
                jce.init(1, new SecretKeySpec(kb, "AES"));
                jce.doFinal(pt, 0, pt.length, ct2, 0);
                harness.check(Util.areEqual((byte[])ct1, (byte[])ct2), "testPadding(" + padName + ")");
                attrib.put("gnu.crypto.mode.state", new Integer(2));
                gnu.reset();
                gnu.init(attrib);
                byte[] pcpt = new byte[48];
                int i4 = 0;
                while (i4 < ct1.length) {
                    gnu.update(ct1, i4, pcpt, i4);
                    i4 += 16;
                }
                int trim = pad.unpad(pcpt, 0, pcpt.length);
                System.arraycopy(pcpt, 0, cpt1, 0, pcpt.length - trim);
                jce.init(2, new SecretKeySpec(kb, "AES"));
                jce.doFinal(ct2, 0, ct2.length, cpt2, 0);
                harness.check(Util.areEqual((byte[])cpt1, (byte[])cpt2), "testPadding(" + padName + ")");
                harness.check(Util.areEqual((byte[])cpt1, (byte[])pt), "testPadding(" + padName + ")");
            }
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testPadding(" + padName + "): " + String.valueOf(x));
        }
    }

    public void testPartial(TestHarness harness) {
        harness.checkPoint("testPartial");
        String cipherName = null;
        Cipher full = null;
        Cipher part = null;
        IBlockCipher gnu = null;
        try {
            Iterator it = CipherFactory.getNames().iterator();
            while (it.hasNext()) {
                cipherName = (String)it.next();
                gnu = CipherFactory.getInstance((String)cipherName);
                full = Cipher.getInstance(cipherName, "GNU-CRYPTO");
                part = Cipher.getInstance(cipherName, "GNU-CRYPTO");
                byte[] pt = new byte[gnu.defaultBlockSize()];
                int i = 0;
                while (i < pt.length) {
                    pt[i] = (byte)i;
                    ++i;
                }
                byte[] kb = new byte[gnu.defaultKeySize()];
                int i2 = 0;
                while (i2 < kb.length) {
                    kb[i2] = (byte)i2;
                    ++i2;
                }
                full.init(1, new SecretKeySpec(kb, cipherName));
                byte[] ct1 = full.doFinal(pt);
                part.init(1, new SecretKeySpec(kb, cipherName));
                int i3 = 0;
                while (i3 < pt.length - 1) {
                    part.update(pt, i3, 1);
                    ++i3;
                }
                byte[] ct2 = part.doFinal(pt, pt.length - 1, 1);
                harness.check(Util.areEqual((byte[])ct1, (byte[])ct2), "testPartial(" + cipherName + ")");
            }
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("testPartial(" + cipherName + "): " + String.valueOf(x));
        }
    }

    public void testDoFinal(TestHarness harness) {
        harness.checkPoint("testDoFinal");
        String cipherName = null;
        Cipher jce = null;
        IBlockCipher gnu = null;
        Iterator it = CipherFactory.getNames().iterator();
        while (it.hasNext()) {
            try {
                cipherName = (String)it.next();
                gnu = CipherFactory.getInstance((String)cipherName);
                jce = Cipher.getInstance(cipherName, "GNU-CRYPTO");
                byte[] pt = new byte[gnu.defaultBlockSize() - 1];
                int i = 0;
                while (i < pt.length) {
                    pt[i] = (byte)i;
                    ++i;
                }
                byte[] kb = new byte[gnu.defaultKeySize()];
                int i2 = 0;
                while (i2 < kb.length) {
                    kb[i2] = (byte)i2;
                    ++i2;
                }
                jce.init(1, new SecretKeySpec(kb, cipherName));
                jce.doFinal(pt);
                harness.fail("testDoFinal(" + cipherName + ")");
            }
            catch (IllegalBlockSizeException ibse) {
                harness.check(true, "testDoFinal(" + cipherName + ")");
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("testDoFinal(" + cipherName + "): " + String.valueOf(x));
            }
        }
    }

    private void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }
}

