/* wptFileSaveDlg.cpp - Save a file 
 *	Copyright (C) 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptTypes.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptW32API.h"
#include "wptErrors.h"

static void
switch_buttons( HWND dlg, int file )
{
    int check1 = file? BST_CHECKED : BST_UNCHECKED;
    int check2 = file? BST_UNCHECKED: BST_CHECKED;
    
    CheckDlgButton( dlg, IDC_FILE_SAVE_TOFILE, check1 ); 
    CheckDlgButton( dlg, IDC_FILE_SAVE_CLIP, check2 );    
} /* switch_buttons */


BOOL CALLBACK
file_save_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{    
    gpgme_data_t sig, plain;
    gpgme_error_t err;
    const char *filename;
    int has_data;
    char file[768];
    
    switch ( msg ) {
    case WM_INITDIALOG:
	#ifndef LANG_DE
        SetWindowText( dlg, _("Save Plaintext") );
	#endif
        switch_buttons( dlg, 0 );
        SetForegroundWindow( dlg );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE )
            EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
        switch ( LOWORD(wparam) ) {
        case IDC_FILE_SAVE_SELECT:
            filename = get_filename_dlg( dlg, FILE_SAVE, _("Destination for Plaintext"), NULL, NULL );
            if( filename ) {
                SetDlgItemText( dlg, IDC_FILE_SAVE_FILE, filename );
                switch_buttons( dlg, 1 );
            }
            return TRUE;
            
        case IDOK:
            if( IsDlgButtonChecked( dlg, IDC_FILE_SAVE_TOFILE ) ) {
                if( !GetDlgItemText( dlg, IDC_FILE_SAVE_FILE, file, sizeof file - 1 ) ) {
                    msg_box( dlg, _("Please enter a filename."), _("Save Plaintext"), MB_INFO );
                    return FALSE;
                }
                err = gpgme_data_new_from_clipboard (&sig);
		if( err ) {
		    msg_box( dlg, winpt_strerror( WPTERR_CLIP_GET ), _("Save Plaintext"), MB_ERR );
		    return FALSE;
		}
                gpgme_data_extract_plaintext( sig, &plain );
                gpgme_data_release_and_set_file( plain, file );
                gpgme_data_release( sig );
                msg_box( dlg, _("Finished"), _("Save Plaintext"), MB_OK );
            }
            else if( IsDlgButtonChecked( dlg, IDC_FILE_SAVE_CLIP ) ) {
                if( !gpgme_clip_istext_avail( &has_data ) && !has_data ) {
                    msg_box( dlg, winpt_strerror( WPTERR_CLIP_ISEMPTY ), _("Save Plaintext"), MB_ERR );
                    return FALSE;
                }
                err = gpgme_data_new_from_clipboard (&sig);
		if( err ) {
		    msg_box( dlg, winpt_strerror( WPTERR_CLIP_GET ), _("Save Plaintext"), MB_ERR );
		    return FALSE;
		}
                gpgme_data_extract_plaintext( sig, &plain );
                gpgme_data_release_and_set_clipboard( plain );
                gpgme_data_release( sig );
                msg_box( dlg, _("Finished"), _("Save Plaintext"), MB_OK );
            }
            EndDialog( dlg, TRUE );
            return TRUE;
            
        case IDCANCEL:
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* file_save_dlg_proc */
