/* wptFirstRunDlg.cpp - Welcome dialog
 *	Copyright (C) 2002-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptW32API.h"
#include "wptGPG.h"
#include "wptTypes.h"
#include "wptCommonCtl.h"
#include "wptContext.h"


BOOL CALLBACK
first_run_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static struct key_wizard_s * ctx;

    switch (msg) {
    case WM_INITDIALOG:
	ctx = (struct key_wizard_s *)lparam;
	if (!ctx)
	    BUG (0);
	CheckDlgButton( dlg, IDC_FIRST_KEYGEN, BST_CHECKED );
	SetDlgItemText (dlg, IDC_FIRST_KEYGEN, _("&Generate a GnuPG key pair"));
	SetDlgItemText (dlg, IDC_FIRST_IMPORT, _("&Copy GnuPG keyrings from another location"));
	SetDlgItemText (dlg, IDC_FIRST_SETUP, _("&Specify a new GnuPG home directory"));
	SetForegroundWindow (dlg);
	center_window (dlg);
	return TRUE;

    case WM_COMMAND:
	switch (LOWORD (wparam)) {
	case IDOK:
	    if (IsDlgButtonChecked (dlg, IDC_FIRST_KEYGEN))
		ctx->interactive = SETUP_KEYGEN;
	    else if (IsDlgButtonChecked (dlg, IDC_FIRST_IMPORT))
		ctx->interactive = SETUP_IMPORT;
	    else if (IsDlgButtonChecked (dlg, IDC_FIRST_SETUP))
		ctx->interactive = SETUP_EXISTING;
	    else
		ctx->interactive = -1;
	    EndDialog (dlg, TRUE);
	    break;

	case IDCANCEL:
	    ctx->interactive = -1;
	    EndDialog (dlg, FALSE);
	    break;
	}
	break;
    }

    return FALSE;
} /* first_run_dlg_proc */
