/* wptKeyImportStatusDlg.cpp - Key Import status dialog
 *	Copyright (C) 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptW32API.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptNLS.h"
#include "wptTypes.h"


BOOL CALLBACK
import_status_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static import_status_s *res;

    switch( msg ) {
    case WM_INITDIALOG:
	res = (import_status_s *)lparam;
	if( !res )
	    dlg_fatal_error( dlg, "Could not get dialog param!" );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NPKEYS, res->import_res[0], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_IPKEYS, res->import_res[2], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NSKEYS, res->import_res[9], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_ISKEYS, res->import_res[10], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NREV, res->import_res[8], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NOUID, res->import_res[1], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NUID, res->import_res[5], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NSUBK, res->import_res[6], FALSE );
	SetDlgItemInt( dlg, IDC_IMPSTAT_NSIG, res->import_res[7], FALSE );
	if( res->rev_cert )
	    SetDlgItemText( dlg, IDC_IMPSTAT_INFO, _("Revocation certifcate imported.") );
	else if( res->import_res[GPGME_IMPSTAT_IPKEYS] == 0 
	    && res->import_res[GPGME_IMPSTAT_ISKEYS] == 0 
	    && res->import_res[GPGME_IMPSTAT_NUIDS] == 0
	    && res->import_res[GPGME_IMPSTAT_NSUBKEYS] == 0
	    && res->import_res[GPGME_IMPSTAT_NSIGS] == 0
	    && res->import_res[GPGME_IMPSTAT_ISKEYS] == 0 )
	    SetDlgItemText( dlg, IDC_IMPSTAT_INFO, _("No keys updated.") );
	center_window( dlg );
	SetForegroundWindow( dlg );
	data_cb_dlg_destroy();
	return TRUE;

    case WM_COMMAND:
	switch( LOWORD( wparam ) ) {
	case IDOK:	    
	    EndDialog( dlg, TRUE );
	    break;
	}
	break;
    }

    return FALSE;
} /* import_status_dlg_proc */