/* wptKeyRevokersDlg.cpp - Designated Revoker Keys
 *	Copyright (C) 2002, 2003, 2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>

#include "../resource.h"
#include "wptCommonCtl.h"
#include "wptNLS.h"
#include "wptTypes.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptErrors.h"
#include "wptKeyserver.h"


static int
revokelist_build( listview_ctrl_t *r_lv, HWND ctrl )
{
    listview_ctrl_t lv;
    struct listview_column_s rlist[] = {
	{ 0,  55, (char *)_("Algorithm") },
	{ 1,  80, (char *)_("Key ID") },
	{ 2, 160, (char *)_("Name") },
	{0}
    };
    int i, rc;

    rc = listview_new( &lv );
    if( rc )
	return rc;
    lv->ctrl = ctrl;
    lv->items = DIM( rlist )-1;
    for( i = 0; i < lv->items; i++ )
	listview_add_column( lv, &rlist[i] );
    listview_set_ext_style( lv );
    *r_lv = lv;
    return 0;
} /* revokelist_build */


static listview_ctrl_t
revokelist_init (HWND ctrl, gpgme_key_t key, gpgme_keycache_t ctx)
{    
    const char *keyid, *alg, *id;
    int i, nkeys;
    gpgme_key_t revkey;
    listview_ctrl_t lv;

    if (revokelist_build (&lv, ctrl))
	BUG (0);

    nkeys = gpgme_key_count_items (key, GPGME_ATTR_REVKEY_FPR);
    for (i = 0; i < nkeys; i++) {
	int algo = gpgme_key_get_ulong_attr (key, GPGME_ATTR_REVKEY_ALGO, NULL, i);
	alg = gpgme_key_expand_attr (GPGME_ATTR_ALGO, algo);
	keyid = gpgme_key_get_string_attr (key, GPGME_ATTR_REVKEY_FPR, NULL, i);
	if (!keyid)
	    continue;
	keyid += 32;
	if (get_pubkey (keyid, &revkey))
	    id = _("User ID was not found");
	else
	    id = gpgme_key_get_string_attr (revkey, GPGME_ATTR_NAME, NULL, 0);
	listview_add_item (lv, "");
	listview_add_sub_item (lv, 0, 0, alg);
	listview_add_sub_item (lv, 0, 1, keyid);
	listview_add_sub_item (lv, 0, 2, id);
    }
    return lv;
} /* revokelist_init */


BOOL CALLBACK
key_revokers_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static listview_ctrl_t lv;
    gpgme_key_t key;
    char buf[128], keyid[32];
    int rc;
    
    switch( msg ) {
    case WM_INITDIALOG:
	gpgme_keycache_t ctx;
	key = (gpgme_key_t)lparam;
	if( !key )
	    dlg_fatal_error( dlg, "Could not get dilaog param" );
	ctx = keycache_get_ctx( 1 );
	if( !ctx )
	    BUG( dlg );
	lv = revokelist_init( GetDlgItem( dlg, IDC_KEYREVOKERS_LIST ), key, ctx );
	return TRUE;

    case WM_NOTIFY:
	NMHDR *notify;
	notify = (NMHDR *)lparam;
	if( notify && notify->code == NM_DBLCLK && notify->idFrom == IDC_KEYREVOKERS_LIST ) {
	    int idx = listview_get_curr_pos( lv );
	    listview_get_item_text( lv, idx, 1, keyid, sizeof keyid-1 );
	    listview_get_item_text( lv, idx, 2, buf, sizeof buf-1 );
	    if( !strcmp( buf, _("User ID was not found") ) ) {
		int id = log_box( _("Designated Key Revokers"), MB_YESNO|MB_INFO,
				  _("Do you want to retrieve 0x%s via the default keyserver?"), keyid );
		if( id == IDNO )
		    break;
		rc = hkp_recv_key( dlg, default_keyserver, default_keyserver_port, buf, 0, 0 );
		if( !rc ) {
		    const char * s;
		    keycache_reload( dlg );
		    if( get_pubkey( keyid, &key ) )
			BUG( NULL );
		    s = gpgme_key_get_string_attr( key, GPGME_ATTR_NAME, NULL, 0 );
		    if( s )
			listview_add_sub_item( lv, idx, 2, s );
		}
	    }
	}
	break;

    case WM_DESTROY:
	if( lv ) {
	    listview_release( lv );
	    lv = NULL;
	}
	return FALSE;

    case WM_COMMAND:
	switch( LOWORD( wparam ) ) {
	case IDOK:
	    EndDialog( dlg, TRUE );
	    break;
	}
	break;
    }

    return FALSE;
} /* key_revokers_dlg_proc */