/* wptKeyTrustPathDlg.cpp - List a trust path for a key.
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#if 0
#include <windows.h>
#include <commctrl.h>

#include "../resource.h"
#include "wptGPGME.h"
#include "wptCommonCtl.h"
#include "wptContext.h" /* for passphrase_s */
#include "wptDlgs.h"
#include "wptTypes.h"
#include "wptNLS.h"

struct trust_path_s {
    int level;
    int type;
    char otrust[2];
    char valid[2];
    char keyid[16+1];
    char uid[128];
};


static void
copy_trust_item(trust_path_s *tp, GpgmeTrustItem ti)
{
    const char *t;
    
    tp->level = gpgme_trust_item_get_int_attr( ti, GPGME_ATTR_LEVEL, NULL, 0 );
    tp->type = gpgme_trust_item_get_int_attr( ti, GPGME_ATTR_TYPE, NULL, 0 );
    t = gpgme_trust_item_get_string_attr( ti, GPGME_ATTR_OTRUST, NULL, 0);
    strcpy( tp->otrust, t );
    t = gpgme_trust_item_get_string_attr( ti, GPGME_ATTR_VALIDITY, NULL, 0 );
    strcpy( tp->valid, t );
    t = gpgme_trust_item_get_string_attr( ti, GPGME_ATTR_KEYID, NULL, 0 );
    strcpy( tp->keyid, t );
    t = gpgme_trust_item_get_string_attr( ti, GPGME_ATTR_USERID, NULL, 0 );
    strcpy( tp->uid, t );
} /* copy_trust_item */


static HTREEITEM
treeview_insert_item( HWND tree, HTREEITEM parent, const char *text )
{
    TVINSERTSTRUCT ti;
    HTREEITEM node;
    
    memset( &ti, 0, sizeof ti );
    ti.hParent = parent;
    ti.hInsertAfter = TVI_LAST;
    ti.item.mask = TVIF_TEXT;
    ti.item.pszText = (char *)text;	
    node = TreeView_InsertItem( tree, &ti );
    return node;
} /* treeview_insert_item */


HTREEITEM
treeview_create_child_item( HWND tree, trust_path_s *tp, HTREEITEM parent )
{
    char info[1024];
    HTREEITEM node;
    
    if( tp->type == 0 ) /* root */
        _snprintf( info, sizeof info-1, "%s", tp->uid );
    else if( tp->type == 1 )/* key */
        _snprintf(info, sizeof info -1, "0x%s (otrust=%s, validity=%s)",
                  tp->keyid, tp->otrust, tp->valid );
    else if( tp->type == 2 ) /* userid */
        _snprintf( info, sizeof info -1, "%s (validity=%s)", tp->uid, tp->valid );    
    node = treeview_insert_item( tree, parent, info );
    return node;
} /* treeview_create_child_item */


void
treeview_add_trustpath(HWND tree, HTREEITEM node, trust_path_s c[], int n, int level)
{
    HTREEITEM _node;
    int i;

    for( i=0; i<n; i++ ) {
	if( c[i].level == level ) {
	    _node = treeview_create_child_item( tree, &c[i], node );
	    treeview_add_trustpath( tree, _node, c, n, i );
	}	
    }
} /* treeview_add_trustpath */


BOOL CALLBACK
keytrust_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    winpt_key_t k;
    HWND tree;	
    GpgmeTrustItem trust_item;
    gpgme_ctx_t ctx;
    gpgme_error_t ec;
    trust_path_s tp[256] = {0};
    int pos = 0;
    
    switch( msg ) {
    case WM_INITDIALOG:
        if( !lparam )
            dlg_fatal_error( dlg, "Could not get dialog param!" );
        k = (winpt_key_t )lparam;
#ifndef LANG_DE
        SetWindowText( dlg, _("List Trust Path") );
#endif
        tree = GetDlgItem( dlg, IDC_KEYTRUST_TREE );
        ec = gpgme_new( &ctx );
	if( ec )
	    BUG( NULL );
        ec = gpgme_op_trustlist_start( ctx, k->keyid, 6 );
        if( ec ) {
            msg_box( dlg, gpgme_strerror( err ), _("Trustlist"), MB_ERR );
            gpgme_release( ctx );
            return FALSE;
        }        
        memset( &tp[0], 0, sizeof tp[0] );
        tp[0].level = -1; pos++;
        strcpy( tp[0].uid, k->uid );
        strcpy( tp[0].keyid, k->keyid );
        
        while( !gpgme_op_trustlist_next( ctx, &trust_item ) ) {
            copy_trust_item( &tp[pos++], trust_item );
            if( pos > 256 )
                break;
            gpgme_trust_item_release( trust_item );
        }
        gpgme_release( ctx );
        treeview_add_trustpath( tree, NULL, tp, pos, -1 );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE )
            EndDialog( dlg, FALSE );
        return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD(wparam) ) {
        case IDOK:
            EndDialog( dlg, TRUE );
            return TRUE;
        }
    }
    
    return FALSE;
} /* keytrust_dlg_proc */
#else
#include <windows.h>
BOOL CALLBACK keytrust_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, 
				LPARAM lparam ) { return FALSE; }
/* GPG 1.2.x does not support this yet */
#endif
