/* wptInet.cpp - New INET code
 *	Copyright (C) 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_INET_H
#define WPT_INET_H

#ifdef __cplusplus
extern "C" {
#endif

#define s_close(fd) closesocket (fd)

enum http_types_t
{
    HTTP_NONE = 0,
    HTTP_GET,
    HTTP_POST,
};

enum http_statcode_t
{
    HTTP_STAT_NONE = 0,
    HTTP_STAT_200 = 200,  /* OK */
    HTTP_STAT_301 = 301,  /* Moved Permanently */
    HTTP_STAT_302 = 302,  /* Moved Temporarily */
    HTTP_STAT_400 = 400,  /* Bad Request */
    HTTP_STAT_403 = 403,  /* Forbidden */
    HTTP_STAT_404 = 404,  /* Not Found */
    HTTP_STAT_405 = 405,  /* Method Not Allowed */
};

enum http_err_t
{
    HTTP_ERR_SUCCESS = 0,
    HTTP_ERR_CONNECT,
    HTTP_ERR_INVADDR,
    HTTP_ERR_SOCK,
    HTTP_ERR_IO,
    HTTP_ERR_PROTO,
    HTTP_ERR_STAT,
};

struct http_head_s
{
    struct http_head_s * next;
    int flags;
    char d[1];
};
typedef struct http_head_s * http_head_t;

struct http_hd_s
{
    int fd;
    http_head_t head;  
};
typedef struct http_hd_s * http_hd_t;

struct http_req_s
{
    int type;
    http_head_t head;
    char * url;  
};
typedef struct http_req_s * http_req_t;

int http_send_request (const char * host, int port, const char* url,
                       http_hd_t * r_hd);
int http_send_request2 (const char * url, http_hd_t * r_hd);
int http_parse_response (http_hd_t hd, int * statcode);
int http_parse_data (http_hd_t hd, FILE * out);
const char * http_strerror (int rc);
int http_hd_new (http_hd_t * hd);
void http_hd_free (http_hd_t hd);
int http_req_new (http_req_t * ctx);
void http_req_free (http_req_t ctx);
int http_parse_request (http_hd_t hd, http_req_t * r_req);

#ifdef __cplusplus
}
#endif

#endif /* WPT_INET_H */
