/* wptKeyEditOwnertrustDlg.cpp - Key onwertrust dialog
 *	Copyright (C) 2000-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptErrors.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptTypes.h"
#include "wptNLS.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h" /* for passphrase_s */
#include "wptDlgs.h"


static int index_val = 0; /* fixme */


int
keyedit_ownertrust_get_val( void )
{
    return index_val;
} /* keyedit_ownertrust_get_val */


BOOL CALLBACK
keyedit_ownertrust_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static gpgme_editkey_t ctx;
    HWND lb;
    int index, id = 0;
    
    switch( msg ) {
    case WM_INITDIALOG:
        ctx = (gpgme_editkey_t)lparam;
        if( lparam == NULL )
            dlg_fatal_error( dlg, "Could not get dialog param!" );
#ifndef LANG_DE
        SetWindowText( dlg, _("Change Ownertrust") );
#endif
        lb = GetDlgItem( dlg, IDC_KEYTRUST_TRUST );
        listbox_add_string( lb, _("Don't know") );
        listbox_add_string( lb, _("I do NOT trust") );
        listbox_add_string( lb, _("I trust marginally") );
        listbox_add_string( lb, _("I trust fully") );            
	listbox_add_string( lb, _("I trust ultimately") );
	SetDlgItemText (dlg, IDC_KEYTRUST_INF, _("Please decide how far you trust this user to correctly verify other users' keys (by looking at passports, checking fingerprint from different source...)?"));
	center_window (dlg);
        SetForegroundWindow (dlg);
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE )
            EndDialog(dlg, TRUE);
        return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD( wparam ) ) {
        case IDCANCEL:
            gpgme_editkey_make_invalid( ctx );
            EndDialog( dlg, FALSE );
            return FALSE;
            
        case IDOK:			
            lb = GetDlgItem( dlg, IDC_KEYTRUST_TRUST );
            index = listbox_get_cursel( lb ) + 1;
            if( index < 1 || index > 5 ) {
                msg_box( dlg, _("Please choose one entry."),  _("Ownertrust"), MB_ERR );
                return FALSE;
            }
            if( index == 5 && !gpgme_editkey_is_secret( ctx, 0 ) ) {
                id = msg_box( dlg, _("Do you really want to set this key to ultimate trust?"),
                              _("Ownertrust"), MB_YESNO );
                if( id == IDNO )
                    return FALSE;
            }
            gpgme_editkey_trust_set( ctx, index );
	    index_val = index;
            EndDialog( dlg, TRUE );
            return TRUE;
        }
        break;
    }
    return FALSE;
} /* keyedit_ownertrust_dlg_proc */
