static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Mark Probst <mark.probst@gmail.com>                         \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"property_boolean (preserve_luminosity, _(\"Preserve luminosity\"), FALSE)     \n"
"                                                                              \n"
"property_double (red, _(\"Red Channel Multiplier\"), 0.333)                   \n"
"    value_range (-5.0, 5.0)                                                   \n"
"    ui_range    (-2.0, 2.0)                                                   \n"
"                                                                              \n"
"property_double (green, _(\"Green Channel Multiplier\"), 0.333)               \n"
"    value_range (-5.0, 5.0)                                                   \n"
"    ui_range    (-2.0, 2.0)                                                   \n"
"                                                                              \n"
"property_double (blue, _(\"Blue Channel Multiplier\"), 0.333)                 \n"
"    value_range (-5.0, 5.0)                                                   \n"
"    ui_range    (-2.0, 2.0)                                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     mono_mixer                                           \n"
"#define GEGL_OP_C_SOURCE mono-mixer.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"YA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o       = GEGL_PROPERTIES (op);                             \n"
"  gfloat      red         = o->red;                                           \n"
"  gfloat      green       = o->green;                                         \n"
"  gfloat      blue        = o->blue;                                          \n"
"  gboolean    normalize   = o->preserve_luminosity;                           \n"
"  gfloat      norm_factor = 1.0;                                              \n"
"  gfloat     * GEGL_ALIGNED in_pixel;                                         \n"
"  gfloat     * GEGL_ALIGNED out_pixel;                                        \n"
"  glong       i;                                                              \n"
"                                                                              \n"
"  in_pixel   = in_buf;                                                        \n"
"  out_pixel  = out_buf;                                                       \n"
"                                                                              \n"
"  if (normalize)                                                              \n"
"   {                                                                          \n"
"     gdouble sum = red + green + blue;                                        \n"
"                                                                              \n"
"     if (sum == 0.0)                                                          \n"
"       norm_factor = 1.0;                                                     \n"
"     else                                                                     \n"
"       norm_factor = fabs (1 / sum);                                          \n"
"   }                                                                          \n"
"                                                                              \n"
"  for (i=0; i<n_pixels; i++)                                                  \n"
"    {                                                                         \n"
"      out_pixel[0] = (in_pixel[0] * red +                                     \n"
"                      in_pixel[1] * green +                                   \n"
"                      in_pixel[2] * blue) * norm_factor;                      \n"
"      out_pixel[1] = in_pixel[3];                                             \n"
"      in_pixel  += 4;                                                         \n"
"      out_pixel += 2;                                                         \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/mono-mixer.cl.h\"                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare    = prepare;                                      \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:mono-mixer\",                                     \n"
"    \"title\",       _(\"Mono Mixer\"),                                       \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"Monochrome channel mixer\"),                         \n"
"    \"cl-source\",   mono_mixer_cl_source,                                    \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
