static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (ref, _(\"Reference\"), \"ID\")                               \n"
"    description (_(\"The reference ID used as input (for use in XML).\"))     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     clone                                                \n"
"#define GEGL_OP_C_SOURCE clone.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <string.h>                                                           \n"
"                                                                              \n"
"static GeglNode *                                                             \n"
"detect (GeglOperation *operation,                                             \n"
"        gint           x,                                                     \n"
"        gint           y)                                                     \n"
"{                                                                             \n"
"  GeglRectangle have_rect = gegl_node_get_bounding_box (operation->node);     \n"
"                                                                              \n"
"  if (x >= have_rect.x &&                                                     \n"
"      y >= have_rect.y &&                                                     \n"
"      x < have_rect.width &&                                                  \n"
"      y < have_rect.height)                                                   \n"
"    {                                                                         \n"
"      return operation->node;                                                 \n"
"    }                                                                         \n"
"  return NULL;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (in_rect)                                                                \n"
"    {                                                                         \n"
"      result = *in_rect;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation        *operation,                                     \n"
"         GeglOperationContext *context,                                       \n"
"         const gchar          *output_prop,                                   \n"
"         const GeglRectangle  *result,                                        \n"
"         gint                  level)                                         \n"
"{                                                                             \n"
"  GeglBuffer *input;                                                          \n"
"                                                                              \n"
"  if (strcmp (output_prop, \"output\"))                                       \n"
"    {                                                                         \n"
"      g_warning (\"requested processing of %s pad on a clone\", output_prop); \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  input  = gegl_operation_context_get_source (context, \"input\");            \n"
"  if (!input)                                                                 \n"
"    {                                                                         \n"
"      g_warning (\"clone received NULL input\");                              \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_context_take_object (context, \"output\", G_OBJECT (input)); \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->detect = detect;                                           \n"
"  operation_class->no_cache = TRUE;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"       \"name\",          \"gegl:clone\",                                     \n"
"       \"title\",         _(\"Clone\"),                                       \n"
"       \"description\",   _(\"Clone a buffer\"),                              \n"
"       \"categories\",    \"core\",                                           \n"
"       NULL);                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
