/* -*- Mode: C -*- */
/*======================================================================
 FILE: icalvalue_cxx.h
 CREATOR: fnguyen 12/13/01
 (C) COPYRIGHT 2001, Critical Path
======================================================================*/

#ifndef CP_ICALVALUE_H
#define CP_ICALVALUE_H

extern "C" {
#include "ical.h"
};
                          
#include "icptrholder.h"
                          
typedef	char* string; // Will use the string library from STL

class ICalValue {
public:
	ICalValue()                                  throw(icalerrorenum);
	ICalValue(const ICalValue&)                  throw(icalerrorenum);
	ICalValue& operator=(const ICalValue&)       throw(icalerrorenum);
	~ICalValue();

	ICalValue(icalvalue*)                        throw(icalerrorenum);
	ICalValue(icalvalue_kind kind)               throw(icalerrorenum);
	ICalValue(icalvalue_kind kind, string  str)  throw(icalerrorenum);

	operator icalvalue* () { return imp; }

	void detach() {
	    imp = NULL;
	}

public:
	string as_ical_string();
	bool is_valid();
	icalvalue_kind isa();
	int isa_value(void*);

	/* Special, non autogenerated value accessors */
	void set_recur(struct icalrecurrencetype v);
	struct icalrecurrencetype get_recur();

	void set_trigger(struct icaltriggertype v);
	struct icaltriggertype get_trigger();

	void set_datetimeperiod(struct icaldatetimeperiodtype v);
	struct icaldatetimeperiodtype get_datetimeperiod();

public:
	static icalparameter_xliccomparetype compare(ICalValue& a, ICalValue& b);

	/* Convert enumerations */
	static icalvalue_kind string_to_kind(string  str);
	string kind_to_string(icalvalue_kind kind);

public:
	/* BOOLEAN */ 
	int get_boolean(); 
	void set_boolean(int v);

	/* UTC-OFFSET */ 
	int get_utcoffset(); 
	void set_utcoffset(int v);

	/* METHOD */ 
	enum icalproperty_method get_method(); 
	void set_method(enum icalproperty_method v);

	/* CAL-ADDRESS */ 
	string get_caladdress(); 
	void set_caladdress(string  v);

	/* PERIOD */ 
	struct icalperiodtype get_period(); 
	void set_period(struct icalperiodtype v);

	/* STATUS */ 
	enum icalproperty_status get_status(); 
	void set_status(enum icalproperty_status v);

	/* BINARY */ 
	string get_binary(); 
	void set_binary(string  v);

	/* TEXT */ 
	string get_text(); 
	void set_text(string  v);

	/* DURATION */ 
	struct icaldurationtype get_duration(); 
	void set_duration(struct icaldurationtype v);

	/* INTEGER */ 
	int get_integer(); 
	void set_integer(int v);

	/* URI */ 
	string get_uri(); 
	void set_uri(string  v);

	/* ATTACH */ 
	icalattach *get_attach(); 
	void set_attach(icalattach *v);

	/* CLASS */ 
	enum icalproperty_class get_class(); 
	void set_class(enum icalproperty_class v);

	/* FLOAT */ 
	float get_float(); 
	void set_float(float v);

	/* QUERY */ 
	string get_query(); 
	void set_query(string  v);

	/* STRING */ 
	string get_string(); 
	void set_string(string  v);

	/* TRANSP */ 
	enum icalproperty_transp get_transp(); 
	void set_transp(enum icalproperty_transp v);

	/* DATE-TIME */ 
	struct icaltimetype get_datetime(); 
	void set_datetime(struct icaltimetype v);

	/* GEO */ 
	struct icalgeotype get_geo(); 
	void set_geo(struct icalgeotype v);

	/* DATE */ 
	struct icaltimetype get_date(); 
	void set_date(struct icaltimetype v);

	/* ACTION */ 
	enum icalproperty_action get_action(); 
	void set_action(enum icalproperty_action v);

private:
	icalvalue* imp;
};


typedef ICPointerHolder<ICalValue> ICalValueTmpPtr;    /* see icptrholder.h for comments */

#endif /*ICALVALUE_H*/
