/* vim: set sw=8: -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/**
 * ms-chart.h: MS Excel Chart support for Gnumeric
 *
 * Author:
 *    Jody Goldberg (jody@gnome.org)
 *
 * (C) 1999-2004 Jody Goldberg
 **/

#ifndef GNUMERIC_MS_CHART_H
#define GNUMERIC_MS_CHART_H

#include "ms-excel-read.h"
#include "ms-container.h"

gboolean ms_excel_chart_read     (BiffQuery *q, MSContainer *container,
				  MsBiffVersion ver, SheetObject *sog);
gboolean ms_excel_chart_read_BOF (BiffQuery *q, MSContainer *container,
				  SheetObject *sog);

void ms_excel_chart_write	   (ExcelWriteState *ewb, SheetObject *so);
void ms_excel_chart_extract_styles (ExcelWriteState *ewb, SheetObject *so);

#endif /* GNUMERIC_MS_CHART_H */
