/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome Team Members: Jean Van Wyk <jeanvanwyk@iname.com> Jeffrey S.
 * Morgan <jeffrey.morgan@bristolwest.com> Dan Bornstein <danfuzz@milk.com>
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */
package org.gnu.gconf;

import org.gnu.glib.Boxed;

/**
 */
public class ConfSchema extends Boxed {
	
	public ConfSchema() {
		handle = gconf_schema_new();
	}

	public ConfSchema(int handle) {
		this.handle = handle;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		gconf_schema_free(handle);
	}
	
	public String getLocale() {
		return gconf_schema_get_locale(handle);
	}
	
	public void setLocale(String locale) {
		gconf_schema_set_locale(handle, locale);
	}
	
	public String getShortDescription() {
		return gconf_schema_get_short_desc(handle);
	}
	
	public void setShortDescription(String desc) {
		gconf_schema_set_short_desc(handle, desc);
	}
	
	public String getLongDescription() {
		return gconf_schema_get_long_desc(handle);
	}
	
	public void setLongDescription(String desc) {
		gconf_schema_set_long_desc(handle, desc);
	}
	
	public String getOwner() {
		return gconf_schema_get_owner(handle);
	}
	
	public void setOwner(String owner) {
		gconf_schema_set_owner(handle, owner);
	}
	
	public ConfValueType getType() {
		int hndl = gconf_schema_get_type(handle);
		return ConfValueType.intern(hndl);
	}
	
	public void setType(ConfValueType type) {
		gconf_schema_set_type(handle, type.getValue());
	}
	
	public ConfValueType getListType() {
		int hndl = gconf_schema_get_list_type(handle);
		return ConfValueType.intern(hndl);
	}
	
	public void setListType(ConfValueType type) {
		gconf_schema_set_list_type(handle, type.getValue());
	}
	
	public ConfValueType getCarType() {
		int hndl = gconf_schema_get_car_type(handle);
		return ConfValueType.intern(hndl);
	}
	
	public void setCarType(ConfValueType type) {
		gconf_schema_set_car_type(handle, type.getValue());
	}
	
	public ConfValueType getCdrType() {
		int hndl = gconf_schema_get_cdr_type(handle);
		return ConfValueType.intern(hndl);
	}
	
	public void setCdrType(ConfValueType type) {
		gconf_schema_set_cdr_type(handle, type.getValue());
	}

	public ConfValue getDefaultValue() {
		int hndl = gconf_schema_get_default_value(handle);
		return new ConfValue(hndl);
	}
	
	public void setDefaultValue(ConfValue value) {
		gconf_schema_set_default_value(handle, value.getHandle());
	}
	
	/****************************************
	 * BEGINNING OF NATIVE CODE
	 ****************************************/
	native static final protected int gconf_schema_new();
	native static final protected void gconf_schema_free(int schema);
	native static final protected void gconf_schema_set_type(int schema, int type);
	native static final protected void gconf_schema_set_list_type(int schema, int type);
	native static final protected void gconf_schema_set_car_type(int schema, int type);
	native static final protected void gconf_schema_set_cdr_type(int schema, int type);
	native static final protected void gconf_schema_set_locale(int schema, String locale);
	native static final protected void gconf_schema_set_short_desc(int schema, String desc);
	native static final protected void gconf_schema_set_long_desc(int schema, String desc);
	native static final protected void gconf_schema_set_owner(int schema, String owner);
	native static final protected void gconf_schema_set_default_value(int schema, int value);
	native static final protected void gconf_schema_set_default_value_nocopy(int schema, int value);
	native static final protected int gconf_schema_get_type(int schema);
	native static final protected int gconf_schema_get_list_type(int schema);
	native static final protected int gconf_schema_get_car_type(int schema);
	native static final protected int gconf_schema_get_cdr_type(int schema);
	native static final protected String gconf_schema_get_locale(int schema);
	native static final protected String gconf_schema_get_short_desc(int schema);
	native static final protected String gconf_schema_get_long_desc(int schema);
	native static final protected String gconf_schema_get_owner(int schema);
	native static final protected int gconf_schema_get_default_value(int schema);
	/****************************************
	 * END OF NATIVE CODE
	 ****************************************/
}
