/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * @deprecated
 */
public class PixmapEntry extends FileEntry {
	/**
	 * Create a new Pixmap Entry.
	 */
	public PixmapEntry(String historyID, String browseDialogTitle, boolean doPreview) {
		super(gnome_pixmap_entry_new(historyID, browseDialogTitle, doPreview));
	}

	/**
	 * Construct a new PixmapEntry from a handle to a native resource.
	 */
	public PixmapEntry(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Set the directory for the lookup
	 */
	public void setDirectory(String directory) {
		gnome_pixmap_entry_set_pixmap_subdir(getHandle(), directory);
	}

	/**
	 * Retrun a file if it is possible to load it with gdk-pixbuf.
	 */
	public String getFilename() {
		return gnome_pixmap_entry_get_filename(getHandle());
	}
	
	/**
	 * Set if a preview should be displayed.
	 */
	public void setPreview(boolean doPreview) {
		gnome_pixmap_entry_set_preview(getHandle(), doPreview);
	}
	
	/**
	 * Set the size of the preview.
	 */
	public void setPreviewSize(int width, int height) {
		gnome_pixmap_entry_set_preview_size(getHandle(), width, height);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_pixmap_entry_get_type());
	}


	native static final protected int gnome_pixmap_entry_get_type();
	native static final protected Handle gnome_pixmap_entry_new(String historyId, String browseDialogTitle, boolean doPreview);
	native static final protected void gnome_pixmap_entry_set_pixmap_subdir(Handle pentry, String subdir);
	native static final protected Handle gnome_pixmap_entry_scrolled_window(Handle pentry);
	native static final protected Handle gnome_pixmap_entry_preview_widget(Handle pentry);
	native static final protected void gnome_pixmap_entry_set_preview(Handle pentry, boolean doPreview);
	native static final protected void gnome_pixmap_entry_set_preview_size(Handle pentry, int width, int height);
	native static final protected String gnome_pixmap_entry_get_filename(Handle pentry);

}
