/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Rectangle;
import org.gnu.glib.Boxed;

/**
 */
public class IconInfo extends Boxed {
	
	private IconInfo() {}
	
	IconInfo(int handle) {
		this.handle = handle;
	}
	
	public int getBaseSize() {
		return gtk_icon_info_get_base_size(handle);
	}
	
	public String getFilename(){
		return gtk_icon_info_get_filename(handle);
	}
	
	public Pixbuf getBuiltinPixbuf() {
		return new Pixbuf(gtk_icon_info_get_builtin_pixbuf(handle));
	}
	
	public Pixbuf loadIcon() {
		return new Pixbuf(gtk_icon_info_load_icon(handle, new int[] {}));
	}
	
	public String getDisplayName() {
		return gtk_icon_info_get_display_name(handle);
	}
	
	public boolean getEmbeddedRect(Rectangle rect) {
		return gtk_icon_info_get_embedded_rect(handle, rect.getHandle());
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_icon_info_get_type ();
	native static final protected int gtk_icon_info_copy(int info);
	native static final protected void gtk_icon_info_free(int info);
	native static final protected int gtk_icon_info_get_base_size(int info);
	native static final protected String gtk_icon_info_get_filename(int info);
	native static final protected int gtk_icon_info_get_builtin_pixbuf(int info);
	native static final protected int gtk_icon_info_load_icon(int info, int[] error);
	native static final protected void gtk_icon_info_set_raw_coordinates(int info, boolean rawCoordinates);
	native static final protected boolean gtk_icon_info_get_embedded_rect(int info, int rect);
	native static final protected boolean gtk_icon_info_get_attach_points(int info, int[] points, int numPoints);
	native static final protected String gtk_icon_info_get_display_name(int info);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
	
}
