/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.ui.JThreeDSideView;
import com.sun.electric.plugins.j3d.utils.J3DAppearance;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.dialogs.options.ThreeDTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.vecmath.Vector3f;

public class JThreeDTab
extends ThreeDTab {
    private boolean initial3DTextChanging = false;
    protected JList threeDLayerList;
    private DefaultListModel threeDLayerModel;
    public HashMap<Layer, GenMath.MutableDouble> threeDThicknessMap;
    public HashMap<Layer, GenMath.MutableDouble> threeDDistanceMap;
    public HashMap<Layer, J3DAppearance> transparencyMap;
    private JThreeDSideView threeDSideView;
    private static final HashMap<J3DTransparencyOption, J3DTransparencyOption> modeMap = new HashMap(5);
    private JTextField alphaField;
    private JLabel alphaLabel;
    private JCheckBox dirOneBox;
    private JPanel dirOnePanel;
    private JCheckBox dirTwoBox;
    private JPanel dirTwoPanel;
    private JPanel directionPanel;
    private JLabel distanceLabel;
    private JLabel initZoomLabel;
    private JPanel initialViewPanel;
    private JTextField maxNodeField;
    private JLabel maxNodeLabel;
    private JTextField scaleField;
    private JLabel scaleLabel;
    private JSeparator separator;
    private JLabel thickLabel;
    private JPanel threeD;
    private JCheckBox threeDAntialiasing;
    private JCheckBox threeDAxes;
    private JCheckBox threeDCellBnd;
    private JTextField threeDHeight;
    private JScrollPane threeDLayerPane;
    private JCheckBox threeDPerspective;
    private JLabel threeDTechnology;
    private JTextField threeDThickness;
    private JTextField threeDZoom;
    private JTextField transparancyField;
    private JLabel transparencyLabel;
    private JComboBox transparencyMode;
    private JLabel transparencyModeLabel;
    private JPanel transparencyPanel;
    private JLabel xDirOne;
    private JTextField xDirOneField;
    private JLabel xDirTwo;
    private JTextField xDirTwoField;
    private JTextField xRotField;
    private JLabel xRotLabel;
    private JLabel yDirOne;
    private JTextField yDirOneField;
    private JLabel yDirTwo;
    private JTextField yDirTwoField;
    private JTextField yRotField;
    private JLabel yRotLabel;
    private JLabel zDirOne;
    private JTextField zDirOneField;
    private JLabel zDirTwo;
    private JTextField zDirTwoField;
    private JTextField zRotField;
    private JLabel zRotLabel;

    public JThreeDTab(Frame parent, Boolean modal) {
        super(parent, (boolean)modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.threeD;
    }

    public void init() {
        this.threeDTechnology.setText("Layer cross section for technology '" + this.curTech.getTechName() + "'");
        this.threeDLayerModel = new DefaultListModel();
        this.threeDLayerList = new JList(this.threeDLayerModel);
        this.threeDLayerList.setSelectionMode(0);
        this.threeDLayerPane.setViewportView(this.threeDLayerList);
        this.threeDLayerList.clearSelection();
        this.threeDLayerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JThreeDTab.this.threeDValuesChanged(false);
            }
        });
        this.threeDThicknessMap = new HashMap();
        this.threeDDistanceMap = new HashMap();
        this.transparencyMap = new HashMap();
        for (Layer layer : this.curTech.getLayersSortedByHeight()) {
            if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
            this.threeDLayerModel.addElement(layer.getName());
            this.threeDThicknessMap.put(layer, new GenMath.MutableDouble(layer.getThickness()));
            this.threeDDistanceMap.put(layer, new GenMath.MutableDouble(layer.getDistance()));
            J3DAppearance app = J3DAppearance.getAppearance(layer.getGraphics());
            J3DAppearance newApp = new J3DAppearance(app);
            newApp.getRenderingAttributes().setVisible(true);
            this.transparencyMap.put(layer, newApp);
        }
        this.threeDLayerList.setSelectedIndex(0);
        this.threeDHeight.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.threeDThickness.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.transparancyField.getDocument().addDocumentListener(new ThreeDInfoDocumentListener(this));
        this.threeDSideView = new JThreeDSideView(this);
        this.threeDSideView.setMinimumSize(new Dimension(200, 450));
        this.threeDSideView.setPreferredSize(new Dimension(200, 450));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDSideView, gbc);
        this.scaleField.setText(TextUtils.formatDouble(J3DUtils.get3DFactor()));
        double[] rot = GenMath.transformVectorIntoValues(J3DUtils.get3DRotation());
        this.xRotField.setText(TextUtils.formatDouble(rot[0]));
        this.yRotField.setText(TextUtils.formatDouble(rot[1]));
        this.zRotField.setText(TextUtils.formatDouble(rot[2]));
        this.threeDPerspective.setSelected(J3DUtils.is3DPerspective());
        this.threeDAntialiasing.setSelected(J3DUtils.is3DAntialiasing());
        this.threeDZoom.setText(TextUtils.formatDouble(J3DUtils.get3DOrigZoom()));
        this.threeDCellBnd.setSelected(J3DUtils.is3DCellBndOn());
        this.threeDAxes.setSelected(J3DUtils.is3DAxesOn());
        this.maxNodeField.setText(String.valueOf(J3DUtils.get3DMaxNumNodes()));
        this.alphaField.setText(String.valueOf(J3DUtils.get3DAlpha()));
        for (J3DTransparencyOption op : modeMap.keySet()) {
            this.transparencyMode.addItem(op);
        }
        this.transparencyMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JThreeDTab.this.threeDValuesChanged(true);
            }
        });
        String lights = J3DUtils.get3DLightDirs();
        Vector3f[] dirs = J3DUtils.transformIntoVectors(lights);
        this.dirOneBox.setSelected(dirs[0] != null);
        if (this.dirOneBox.isSelected()) {
            this.xDirOneField.setText(String.valueOf(dirs[0].x));
            this.yDirOneField.setText(String.valueOf(dirs[0].y));
            this.zDirOneField.setText(String.valueOf(dirs[0].z));
        }
        this.dirTwoBox.setSelected(dirs[1] != null);
        if (this.dirTwoBox.isSelected()) {
            this.xDirTwoField.setText(String.valueOf(dirs[1].x));
            this.yDirTwoField.setText(String.valueOf(dirs[1].y));
            this.zDirTwoField.setText(String.valueOf(dirs[1].z));
        }
        this.threeDValuesChanged(false);
        this.dirOneBoxStateChanged(null);
        this.dirTwoBoxStateChanged(null);
    }

    private void threeDValuesChanged(boolean set) {
        String layerName = (String)this.threeDLayerList.getSelectedValue();
        Layer layer = this.curTech.findLayer(layerName);
        if (layer == null) {
            return;
        }
        this.processDataInFields(layer, set);
    }

    public void processDataInFields(Layer layer, boolean set) {
        if (!set) {
            this.initial3DTextChanging = true;
        } else if (this.initial3DTextChanging) {
            return;
        }
        GenMath.MutableDouble thickness = this.threeDThicknessMap.get(layer);
        GenMath.MutableDouble height = this.threeDDistanceMap.get(layer);
        J3DAppearance app = this.transparencyMap.get(layer);
        TransparencyAttributes ta = app.getTransparencyAttributes();
        if (set) {
            thickness.setValue(TextUtils.atof(this.threeDThickness.getText()));
            height.setValue(TextUtils.atof(this.threeDHeight.getText()));
            ta.setTransparency((float)TextUtils.atof(this.transparancyField.getText()));
            J3DTransparencyOption op = (J3DTransparencyOption)this.transparencyMode.getSelectedItem();
            ta.setTransparencyMode(op.mode);
            app.getRenderingAttributes().setDepthBufferEnable(op.mode != 4);
            this.threeDSideView.updateZValues(layer, thickness.doubleValue(), height.doubleValue());
        } else {
            this.threeDHeight.setText(TextUtils.formatDouble(height.doubleValue()));
            this.threeDThickness.setText(TextUtils.formatDouble(thickness.doubleValue()));
            this.transparancyField.setText(TextUtils.formatDouble(ta.getTransparency()));
            for (J3DTransparencyOption op : modeMap.keySet()) {
                if (op.mode != ta.getTransparencyMode()) continue;
                this.transparencyMode.setSelectedItem(op);
                break;
            }
            this.threeDSideView.showLayer(layer);
        }
        if (!set) {
            this.initial3DTextChanging = false;
        }
    }

    public void term() {
        int currentInt;
        String rotationValue;
        double currentValue;
        Iterator<Layer> it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if ((layer.getFunctionExtras() & 0x1000) != 0) continue;
            GenMath.MutableDouble thickness = this.threeDThicknessMap.get(layer);
            GenMath.MutableDouble height = this.threeDDistanceMap.get(layer);
            J3DAppearance newApp = this.transparencyMap.get(layer);
            J3DAppearance oldApp = (J3DAppearance)layer.getGraphics().get3DAppearance();
            oldApp.setTransparencyAndRenderingAttributes(newApp.getTransparencyAttributes(), newApp.getRenderingAttributes().getDepthBufferEnable());
            if (thickness.doubleValue() != layer.getThickness()) {
                layer.setThickness(thickness.doubleValue());
            }
            if (height.doubleValue() == layer.getDistance()) continue;
            layer.setDistance(height.doubleValue());
        }
        boolean currentBoolean = this.threeDPerspective.isSelected();
        if (currentBoolean != J3DUtils.is3DPerspective()) {
            J3DUtils.set3DPerspective(currentBoolean);
        }
        if ((currentBoolean = this.threeDAntialiasing.isSelected()) != J3DUtils.is3DAntialiasing()) {
            View3DWindow.setAntialiasing(currentBoolean);
            J3DUtils.set3DAntialiasing(currentBoolean);
        }
        if ((currentBoolean = this.threeDCellBnd.isSelected()) != J3DUtils.is3DCellBndOn()) {
            J3DAppearance.cellApp.getRenderingAttributes().setVisible(currentBoolean);
            J3DUtils.set3DCellBndOn(currentBoolean);
        }
        if ((currentBoolean = this.threeDAxes.isSelected()) != J3DUtils.is3DAxesOn()) {
            J3DAppearance.axisApps[0].getRenderingAttributes().setVisible(currentBoolean);
            J3DAppearance.axisApps[1].getRenderingAttributes().setVisible(currentBoolean);
            J3DAppearance.axisApps[2].getRenderingAttributes().setVisible(currentBoolean);
            J3DUtils.set3DAxesOn(currentBoolean);
        }
        if ((currentValue = TextUtils.atof(this.scaleField.getText())) != J3DUtils.get3DFactor()) {
            View3DWindow.setScaleFactor(currentValue);
            J3DUtils.set3DFactor(currentValue);
        }
        if (!(rotationValue = "(" + this.xRotField.getText() + " " + this.yRotField.getText() + " " + this.zRotField.getText() + ")").equals(J3DUtils.get3DRotation())) {
            J3DUtils.set3DRotation(rotationValue);
        }
        if (GenMath.doublesEqual(currentValue = TextUtils.atof(this.threeDZoom.getText()), 0.0)) {
            System.out.println(currentValue + " is an invalid zoom factor.");
        } else if (currentValue != J3DUtils.get3DOrigZoom()) {
            J3DUtils.set3DOrigZoom(currentValue);
        }
        StringBuffer dir = new StringBuffer();
        if (this.dirOneBox.isSelected()) {
            dir.append(GenMath.transformStringsIntoVector(TextUtils.atof(this.xDirOneField.getText()), TextUtils.atof(this.yDirOneField.getText()), TextUtils.atof(this.zDirOneField.getText())));
        } else {
            dir.append(GenMath.transformStringsIntoVector(0.0, 0.0, 0.0));
        }
        if (this.dirTwoBox.isSelected()) {
            dir.append(GenMath.transformStringsIntoVector(TextUtils.atof(this.xDirTwoField.getText()), TextUtils.atof(this.yDirTwoField.getText()), TextUtils.atof(this.zDirTwoField.getText())));
        } else {
            dir.append(GenMath.transformStringsIntoVector(0.0, 0.0, 0.0));
        }
        if (!dir.equals(J3DUtils.get3DLightDirs())) {
            J3DUtils.set3DLightDirs(dir.toString());
        }
        if ((currentInt = TextUtils.atoi(this.maxNodeField.getText())) != J3DUtils.get3DMaxNumNodes()) {
            J3DUtils.set3DMaxNumNodes(currentInt);
        }
        if ((currentInt = TextUtils.atoi(this.alphaField.getText())) != J3DUtils.get3DAlpha()) {
            J3DUtils.set3DAlpha(currentInt);
        }
    }

    private void initComponents() {
        this.threeD = new JPanel();
        this.threeDTechnology = new JLabel();
        this.threeDLayerPane = new JScrollPane();
        this.thickLabel = new JLabel();
        this.distanceLabel = new JLabel();
        this.threeDThickness = new JTextField();
        this.threeDHeight = new JTextField();
        this.threeDPerspective = new JCheckBox();
        this.threeDAntialiasing = new JCheckBox();
        this.transparencyPanel = new JPanel();
        this.transparencyMode = new JComboBox();
        this.transparancyField = new JTextField();
        this.transparencyLabel = new JLabel();
        this.transparencyModeLabel = new JLabel();
        this.separator = new JSeparator();
        this.directionPanel = new JPanel();
        this.dirOneBox = new JCheckBox();
        this.dirTwoBox = new JCheckBox();
        this.dirOnePanel = new JPanel();
        this.xDirOne = new JLabel();
        this.yDirOne = new JLabel();
        this.zDirOne = new JLabel();
        this.xDirOneField = new JTextField();
        this.yDirOneField = new JTextField();
        this.zDirOneField = new JTextField();
        this.dirTwoPanel = new JPanel();
        this.xDirTwo = new JLabel();
        this.yDirTwo = new JLabel();
        this.zDirTwo = new JLabel();
        this.xDirTwoField = new JTextField();
        this.yDirTwoField = new JTextField();
        this.zDirTwoField = new JTextField();
        this.threeDCellBnd = new JCheckBox();
        this.initialViewPanel = new JPanel();
        this.xRotLabel = new JLabel();
        this.xRotField = new JTextField();
        this.yRotField = new JTextField();
        this.yRotLabel = new JLabel();
        this.threeDZoom = new JTextField();
        this.initZoomLabel = new JLabel();
        this.zRotField = new JTextField();
        this.zRotLabel = new JLabel();
        this.scaleField = new JTextField();
        this.scaleLabel = new JLabel();
        this.threeDAxes = new JCheckBox();
        this.maxNodeLabel = new JLabel();
        this.maxNodeField = new JTextField();
        this.alphaLabel = new JLabel();
        this.alphaField = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JThreeDTab.this.closeDialog(evt);
            }
        });
        this.threeD.setLayout(new GridBagLayout());
        this.threeDTechnology.setText("Layer cross section for technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDTechnology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDLayerPane, gridBagConstraints);
        this.thickLabel.setText("Thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.thickLabel, gridBagConstraints);
        this.distanceLabel.setText("Distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.distanceLabel, gridBagConstraints);
        this.threeDThickness.setColumns(6);
        this.threeDThickness.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDThickness, gridBagConstraints);
        this.threeDHeight.setColumns(6);
        this.threeDHeight.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDHeight, gridBagConstraints);
        this.threeDPerspective.setText("Use Perspective");
        this.threeDPerspective.setToolTipText("Perspective or Parallel View");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDPerspective, gridBagConstraints);
        this.threeDAntialiasing.setText("Use Antialiasing");
        this.threeDAntialiasing.setToolTipText("Turn on Antialiasing if available");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDAntialiasing, gridBagConstraints);
        this.transparencyPanel.setLayout(new GridBagLayout());
        this.transparencyPanel.setBorder(BorderFactory.createTitledBorder("Transparency Options"));
        this.transparencyMode.setToolTipText("Java3D transparency model");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.transparencyPanel.add((Component)this.transparencyMode, gridBagConstraints);
        this.transparancyField.setToolTipText("Transparency alpha factor (0 is opaque)");
        this.transparancyField.setMinimumSize(new Dimension(20, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.transparencyPanel.add((Component)this.transparancyField, gridBagConstraints);
        this.transparencyLabel.setText("Factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.transparencyPanel.add((Component)this.transparencyLabel, gridBagConstraints);
        this.transparencyModeLabel.setText("Mode:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.transparencyPanel.add((Component)this.transparencyModeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        this.threeD.add((Component)this.transparencyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.threeD.add((Component)this.separator, gridBagConstraints);
        this.directionPanel.setLayout(new GridBagLayout());
        this.directionPanel.setBorder(BorderFactory.createTitledBorder("Light Information"));
        this.dirOneBox.setSelected(true);
        this.dirOneBox.setText("Enable Light 1");
        this.dirOneBox.setToolTipText("Direction of first environment light");
        this.dirOneBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JThreeDTab.this.dirOneBoxStateChanged(evt);
            }
        });
        this.directionPanel.add((Component)this.dirOneBox, new GridBagConstraints());
        this.dirTwoBox.setText("Enable Light 2");
        this.dirTwoBox.setToolTipText("Direction of second environment light");
        this.dirTwoBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JThreeDTab.this.dirTwoBoxStateChanged(evt);
            }
        });
        this.directionPanel.add((Component)this.dirTwoBox, new GridBagConstraints());
        this.dirOnePanel.setLayout(new GridBagLayout());
        this.xDirOne.setText("X:");
        this.dirOnePanel.add((Component)this.xDirOne, new GridBagConstraints());
        this.yDirOne.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.dirOnePanel.add((Component)this.yDirOne, gridBagConstraints);
        this.zDirOne.setText("Z:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.dirOnePanel.add((Component)this.zDirOne, gridBagConstraints);
        this.xDirOneField.setText(null);
        this.xDirOneField.setMinimumSize(new Dimension(50, 21));
        this.xDirOneField.setPreferredSize(new Dimension(50, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dirOnePanel.add((Component)this.xDirOneField, gridBagConstraints);
        this.yDirOneField.setText(null);
        this.yDirOneField.setMinimumSize(new Dimension(50, 21));
        this.yDirOneField.setPreferredSize(new Dimension(50, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dirOnePanel.add((Component)this.yDirOneField, gridBagConstraints);
        this.zDirOneField.setText(null);
        this.zDirOneField.setMinimumSize(new Dimension(50, 21));
        this.zDirOneField.setPreferredSize(new Dimension(50, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dirOnePanel.add((Component)this.zDirOneField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.directionPanel.add((Component)this.dirOnePanel, gridBagConstraints);
        this.dirTwoPanel.setLayout(new GridBagLayout());
        this.dirTwoPanel.setEnabled(false);
        this.xDirTwo.setText("X:");
        this.dirTwoPanel.add((Component)this.xDirTwo, new GridBagConstraints());
        this.yDirTwo.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.dirTwoPanel.add((Component)this.yDirTwo, gridBagConstraints);
        this.zDirTwo.setText("Z:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.dirTwoPanel.add((Component)this.zDirTwo, gridBagConstraints);
        this.xDirTwoField.setText(null);
        this.xDirTwoField.setMinimumSize(new Dimension(50, 21));
        this.xDirTwoField.setPreferredSize(new Dimension(50, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dirTwoPanel.add((Component)this.xDirTwoField, gridBagConstraints);
        this.yDirTwoField.setText(null);
        this.yDirTwoField.setMinimumSize(new Dimension(50, 21));
        this.yDirTwoField.setPreferredSize(new Dimension(50, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dirTwoPanel.add((Component)this.yDirTwoField, gridBagConstraints);
        this.zDirTwoField.setText(null);
        this.zDirTwoField.setMinimumSize(new Dimension(50, 21));
        this.zDirTwoField.setPreferredSize(new Dimension(50, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dirTwoPanel.add((Component)this.zDirTwoField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.directionPanel.add((Component)this.dirTwoPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.directionPanel, gridBagConstraints);
        this.threeDCellBnd.setText("Cell  Bounding Box");
        this.threeDCellBnd.setToolTipText("Display cell bounding box");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDCellBnd, gridBagConstraints);
        this.initialViewPanel.setLayout(new GridBagLayout());
        this.initialViewPanel.setBorder(BorderFactory.createTitledBorder("Initial Transformation"));
        this.xRotLabel.setText("Rotation X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.xRotLabel, gridBagConstraints);
        this.xRotField.setColumns(6);
        this.xRotField.setToolTipText("X component of rotation vector");
        this.xRotField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.xRotField, gridBagConstraints);
        this.yRotField.setColumns(6);
        this.yRotField.setToolTipText("Y component of rotation vector");
        this.yRotField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.yRotField, gridBagConstraints);
        this.yRotLabel.setText("Rotation Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.yRotLabel, gridBagConstraints);
        this.threeDZoom.setColumns(6);
        this.threeDZoom.setToolTipText("Initial zoom in case of JMouseZoom behavior");
        this.threeDZoom.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.threeDZoom, gridBagConstraints);
        this.initZoomLabel.setText("Initial Zoom:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.initZoomLabel, gridBagConstraints);
        this.zRotField.setColumns(6);
        this.zRotField.setToolTipText("Z component of rotation vector");
        this.zRotField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.zRotField, gridBagConstraints);
        this.zRotLabel.setText("Rotation Z:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.zRotLabel, gridBagConstraints);
        this.scaleField.setColumns(6);
        this.scaleField.setToolTipText("Scale along Z to shrink or expand elements");
        this.scaleField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.scaleField, gridBagConstraints);
        this.scaleLabel.setText("Z Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initialViewPanel.add((Component)this.scaleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.initialViewPanel, gridBagConstraints);
        this.threeDAxes.setSelected(true);
        this.threeDAxes.setText("Show Axes");
        this.threeDAxes.setToolTipText("Turn on Axes if Java3D plugin is available");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.threeDAxes, gridBagConstraints);
        this.maxNodeLabel.setText("Max. # Nodes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.maxNodeLabel, gridBagConstraints);
        this.maxNodeField.setColumns(6);
        this.maxNodeField.setToolTipText("Recommended maximum number of nodes in scene graph");
        this.maxNodeField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.maxNodeField, gridBagConstraints);
        this.alphaLabel.setText("Alpha:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.alphaLabel, gridBagConstraints);
        this.alphaField.setColumns(6);
        this.alphaField.setToolTipText("Alpha speed value for demos");
        this.alphaField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.threeD.add((Component)this.alphaField, gridBagConstraints);
        this.getContentPane().add((Component)this.threeD, new GridBagConstraints());
        this.pack();
    }

    private void dirTwoBoxStateChanged(ChangeEvent evt) {
        this.dirTwoPanel.setVisible(this.dirTwoBox.isSelected());
    }

    private void dirOneBoxStateChanged(ChangeEvent evt) {
        this.dirOnePanel.setVisible(this.dirOneBox.isSelected());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    static {
        J3DTransparencyOption option = new J3DTransparencyOption(0, "FASTEST");
        modeMap.put(option, option);
        option = new J3DTransparencyOption(1, "NICEST");
        modeMap.put(option, option);
        option = new J3DTransparencyOption(2, "BLENDED");
        modeMap.put(option, option);
        option = new J3DTransparencyOption(3, "SCREEN_DOOR");
        modeMap.put(option, option);
        option = new J3DTransparencyOption(4, "NONE");
        modeMap.put(option, option);
    }

    private static class ThreeDInfoDocumentListener
    implements DocumentListener {
        JThreeDTab dialog;

        ThreeDInfoDocumentListener(JThreeDTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged(true);
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged(true);
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.threeDValuesChanged(true);
        }
    }

    private static class J3DTransparencyOption {
        int mode;
        String name;

        J3DTransparencyOption(int mode, String name) {
            this.mode = mode;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.mode;
        }
    }
}

