/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.util.math.DBMath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class SizeOffset
implements Serializable {
    public static final SizeOffset ZERO_OFFSET = new SizeOffset(0.0, 0.0, 0.0, 0.0);
    private final double lx;
    private final double hx;
    private final double ly;
    private final double hy;
    private final int gridLx;
    private final int gridHx;
    private final int gridLy;
    private final int gridHy;

    public SizeOffset(double lx, double hx, double ly, double hy) {
        this.gridLx = (int)DBMath.lambdaToGrid(lx);
        this.gridHx = (int)DBMath.lambdaToGrid(hx);
        this.gridLy = (int)DBMath.lambdaToGrid(ly);
        this.gridHy = (int)DBMath.lambdaToGrid(hy);
        this.lx = DBMath.gridToLambda(this.gridLx);
        this.hx = DBMath.gridToLambda(this.gridHx);
        this.ly = DBMath.gridToLambda(this.gridLy);
        this.hy = DBMath.gridToLambda(this.gridHy);
    }

    public double getLowXOffset() {
        return this.lx;
    }

    public double getHighXOffset() {
        return this.hx;
    }

    public double getLowYOffset() {
        return this.ly;
    }

    public double getHighYOffset() {
        return this.hy;
    }

    public long getLowXGridOffset() {
        return this.gridLx;
    }

    public long getHighXGridOffset() {
        return this.gridHx;
    }

    public long getLowYGridOffset() {
        return this.gridLy;
    }

    public long getHighYGridOffset() {
        return this.gridHy;
    }

    public String toString() {
        return "SizeOffset {X:[" + this.lx + "," + this.hx + "] Y:[" + this.ly + "," + this.hy + "]}";
    }

    public Rectangle2D modifyBounds(Rectangle2D bounds) {
        return new Rectangle2D.Double(bounds.getX() + this.lx, bounds.getY() + this.ly, bounds.getWidth() - this.lx - this.hx, bounds.getHeight() - this.ly - this.hy);
    }
}

