/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import com.sun.electric.tool.user.ErrorLogger;

public class FillGenJob
extends Job {
    protected FillGenConfig fillGenConfig;
    protected Cell topCell;
    protected ErrorLogger log;
    private boolean doItNow;
    protected LayerCoverageTool.LayerCoveragePreferences lcp;

    public FillGenJob(Cell cell, FillGenConfig gen, boolean doItNow, LayerCoverageTool.LayerCoveragePreferences lcp) {
        super("Fill generator job", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.fillGenConfig = gen;
        this.topCell = cell;
        this.doItNow = doItNow;
        this.lcp = lcp;
        assert (this.fillGenConfig.evenLayersHorizontal);
        if (doItNow) {
            this.timer.start();
            try {
                if (this.doIt()) {
                    this.terminateOK();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.startJob();
        }
    }

    public ErrorLogger getLogger() {
        return this.log;
    }

    public Library getAutoFilLibrary() {
        return Library.findLibrary(this.fillGenConfig.fillLibName);
    }

    @Override
    public void terminateOK() {
        this.log.termLogging(false);
        this.timer.end();
        int errorCount = this.log.getNumErrors();
        int warnCount = this.log.getNumWarnings();
        System.out.println(errorCount + " errors and " + warnCount + " warnings found (took " + this.timer + ")");
    }

    protected FillGeneratorTool setUpJob() {
        FillGeneratorTool fillGen = FillGeneratorTool.getTool();
        fillGen.setConfig(this.fillGenConfig);
        this.log = ErrorLogger.newInstance("Fill");
        if (!this.doItNow) {
            this.fieldVariableChanged("log");
        }
        this.fillGenConfig.job = this;
        return fillGen;
    }

    @Override
    public boolean doIt() {
        FillGeneratorTool fillGen = this.setUpJob();
        return this.doTemplateFill(fillGen, this.getEditingPreferences());
    }

    public boolean doTemplateFill(FillGeneratorTool fillGen, EditingPreferences ep) {
        fillGen.standardMakeFillCell(this.fillGenConfig.firstLayer, this.fillGenConfig.lastLayer, this.fillGenConfig.getTechType(), ep, this.fillGenConfig.perim, this.fillGenConfig.cellTiles, false);
        fillGen.makeGallery(this.getEditingPreferences());
        return true;
    }
}

