/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class NCCAnnotations
extends EDialog {
    private List<Library> libList;
    private static Library curLib = null;
    private static List<JButton> editButtons;
    private static List<JButton> deleteButtons;
    private static List<JLabel> cellNames;
    private static List<JLabel> cellAnnotations;
    private static boolean lastOnlyShowAnnotated;
    private Frame parentFrame;
    private static final ImageIcon iconDelete;
    private static final ImageIcon iconEdit;
    private JPanel Top;
    private JScrollPane cells;
    private JButton done;
    private JLabel jLabel1;
    private JComboBox libraries;
    private JCheckBox onlyAnnotatedCells;

    public NCCAnnotations(Frame parent) {
        super(parent, true);
        this.parentFrame = parent;
        this.setPreferredSize(new Dimension(650, 400));
        this.initComponents();
        this.libList = Library.getVisibleLibraries();
        if (curLib == null) {
            curLib = Library.getCurrent();
        }
        Library saveLeft = curLib;
        for (Library lib : this.libList) {
            this.libraries.addItem(lib.getName());
        }
        int curIndex = this.libList.indexOf(saveLeft);
        if (curIndex >= 0) {
            this.libraries.setSelectedIndex(curIndex);
        }
        this.showCells();
        this.onlyAnnotatedCells.setSelected(lastOnlyShowAnnotated);
        this.onlyAnnotatedCells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NCCAnnotations.this.onlyAnnotatedCellsChanged();
            }
        });
        this.getRootPane().setDefaultButton(this.done);
        this.finishInitialization();
    }

    private void onlyAnnotatedCellsChanged() {
        lastOnlyShowAnnotated = this.onlyAnnotatedCells.isSelected();
        this.showCells();
    }

    private void showCells() {
        JPanel pan = new JPanel();
        pan.setLayout(new GridBagLayout());
        int rowIndex = 0;
        cellNames = new ArrayList<JLabel>();
        editButtons = new ArrayList<JButton>();
        deleteButtons = new ArrayList<JButton>();
        cellAnnotations = new ArrayList<JLabel>();
        Iterator<Cell> it = curLib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            Variable var = c.getVar(NccCellAnnotations.NCC_ANNOTATION_KEY);
            String ann = "";
            if (var != null) {
                ann = var.getPureValue(-1);
            } else if (lastOnlyShowAnnotated) continue;
            JLabel labCName = new JLabel(c.describe(false));
            cellNames.add(labCName);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = rowIndex;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            pan.add((Component)labCName, gbc);
            JSeparator sep1 = new JSeparator(1);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = rowIndex;
            gbc.weighty = 1.0;
            gbc.fill = 3;
            pan.add((Component)sep1, gbc);
            final JButton editBut = new JButton(iconEdit);
            editBut.setBorder(BorderFactory.createEmptyBorder());
            editBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NCCAnnotations.this.doEdit(editBut);
                }
            });
            editButtons.add(editBut);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = rowIndex;
            gbc.insets = new Insets(2, 6, 2, 4);
            pan.add((Component)editBut, gbc);
            final JButton deleteBut = new JButton(iconDelete);
            deleteBut.setBorder(BorderFactory.createEmptyBorder());
            deleteBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NCCAnnotations.this.doDelete(deleteBut);
                }
            });
            deleteButtons.add(deleteBut);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = rowIndex;
            gbc.insets = new Insets(2, 4, 2, 6);
            pan.add((Component)deleteBut, gbc);
            JSeparator sep2 = new JSeparator(1);
            gbc = new GridBagConstraints();
            gbc.gridx = 4;
            gbc.gridy = rowIndex;
            gbc.weighty = 1.0;
            gbc.fill = 3;
            pan.add((Component)sep2, gbc);
            JLabel labAnn = new JLabel(ann);
            cellAnnotations.add(labAnn);
            gbc = new GridBagConstraints();
            gbc.gridx = 5;
            gbc.gridy = rowIndex++;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            pan.add((Component)labAnn, gbc);
        }
        this.cells.setViewportView(pan);
    }

    public void doEdit(JButton but) {
        for (int i = 0; i < editButtons.size(); ++i) {
            String[] anns;
            if (editButtons.get(i) != but) continue;
            String cellName = cellNames.get(i).getText();
            Cell c = curLib.findNodeProto(cellName);
            if (c == null) {
                System.out.println("Error: can't find cell " + cellName + " in library " + curLib.getName());
                return;
            }
            Variable var = c.getVar(NccCellAnnotations.NCC_ANNOTATION_KEY);
            TextDescriptor td = null;
            if (var == null) {
                anns = new String[]{};
            } else {
                Object oldObj = var.getObject();
                anns = oldObj instanceof String ? new String[]{(String)oldObj} : (String[])oldObj;
                td = var.getTextDescriptor();
            }
            new EditAnnotationDialog(this.parentFrame, i, c, anns, td);
            return;
        }
    }

    public void doDelete(JButton but) {
        for (int i = 0; i < deleteButtons.size(); ++i) {
            if (deleteButtons.get(i) != but) continue;
            String cellName = cellNames.get(i).getText();
            Cell c = curLib.findNodeProto(cellName);
            if (c == null) {
                System.out.println("Error: can't find cell " + cellName + " in library " + curLib.getName());
                return;
            }
            new DeleteAnnotationJob(i, c);
            return;
        }
    }

    private void initComponents() {
        this.Top = new JPanel();
        this.libraries = new JComboBox();
        this.done = new JButton();
        this.cells = new JScrollPane();
        this.onlyAnnotatedCells = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setTitle("NCC Annotations");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NCCAnnotations.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.Top.setLayout(new GridBagLayout());
        this.libraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NCCAnnotations.this.librariesActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.libraries, gridBagConstraints);
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NCCAnnotations.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.done, gridBagConstraints);
        this.cells.setPreferredSize(new Dimension(200, 350));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.cells, gridBagConstraints);
        this.onlyAnnotatedCells.setText("Only show cells with annotations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.onlyAnnotatedCells, gridBagConstraints);
        this.jLabel1.setText("Libraries:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.jLabel1, gridBagConstraints);
        this.getContentPane().add((Component)this.Top, "Center");
        this.pack();
    }

    private void librariesActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int index = cb.getSelectedIndex();
        curLib = this.libList.get(index);
        this.showCells();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        lastOnlyShowAnnotated = this.onlyAnnotatedCells.isSelected();
        this.setVisible(false);
        this.dispose();
    }

    static {
        lastOnlyShowAnnotated = false;
        iconDelete = Resources.getResource(NCCAnnotations.class, "IconDelete.gif");
        iconEdit = Resources.getResource(NCCAnnotations.class, "IconDraw.gif");
    }

    public class EditAnnotationDialog
    extends EDialog {
        private int index;
        private Cell cell;
        private TextDescriptor td;
        private JTextArea ta;

        public EditAnnotationDialog(Frame parent, int i, Cell c, String[] ann, TextDescriptor t) {
            super(parent, true);
            this.index = i;
            this.cell = c;
            this.td = t;
            this.setTitle("Edit NCC Annotation");
            Dimension size = new Dimension(450, 200);
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setLayout(new GridBagLayout());
            JLabel labCName = new JLabel("Annotation for cell " + c.describe(false));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.add((Component)labCName, gbc);
            this.ta = new JTextArea();
            Object text = "";
            for (int j = 0; j < ann.length; ++j) {
                if (j > 0) {
                    text = (String)text + "\n";
                }
                text = (String)text + ann[j];
            }
            this.ta.setText((String)text);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.ta, gbc);
            JButton cancelBut = new JButton("Cancel");
            cancelBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditAnnotationDialog.this.closeDialog();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.add((Component)cancelBut, gbc);
            JButton okayBut = new JButton("OK");
            okayBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditAnnotationDialog.this.okayBut();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.add((Component)okayBut, gbc);
            this.getRootPane().setDefaultButton(okayBut);
            this.finishInitialization();
            this.pack();
            this.setVisible(true);
        }

        public void okayBut() {
            String anns = this.ta.getText().trim();
            String[] newAnns = anns.split("\n");
            new UpdateAnnotationJob(this.index, this.cell, newAnns, this.td);
            this.closeDialog();
        }
    }

    public static class DeleteAnnotationJob
    extends Job {
        private int index;
        private Cell cell;

        public DeleteAnnotationJob(int i, Cell c) {
            super("Delete NCC Annotation", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.index = i;
            this.cell = c;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.cell.delVar(NccCellAnnotations.NCC_ANNOTATION_KEY);
            return true;
        }

        @Override
        public void terminateOK() {
            cellAnnotations.get(this.index).setText("");
        }
    }

    public static class UpdateAnnotationJob
    extends Job {
        private int index;
        private Cell cell;
        private String[] ann;
        private TextDescriptor td;

        public UpdateAnnotationJob(int i, Cell c, String[] a, TextDescriptor t) {
            super("Change NCC Annotation", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.index = i;
            this.cell = c;
            this.ann = a;
            this.td = t;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.td == null) {
                this.td = ep.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            }
            this.cell.newVar(NccCellAnnotations.NCC_ANNOTATION_KEY, (Object)this.ann, this.td);
            return true;
        }

        @Override
        public void terminateOK() {
            Variable var = this.cell.getVar(NccCellAnnotations.NCC_ANNOTATION_KEY);
            String ann = "";
            if (var != null) {
                ann = var.getPureValue(-1);
            }
            cellAnnotations.get(this.index).setText(ann);
        }
    }
}

