/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2009-07-18
 * Description : setup Metadata tab.
 *
 * Copyright (C) 2009 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef SETUPMETADATA_H
#define SETUPMETADATA_H

// Qt includes

#include <QScrollArea>

namespace ShowFoto
{

class SetupMetadataPriv;

class SetupMetadata : public QScrollArea
{
    Q_OBJECT

public:

    SetupMetadata(QWidget* parent = 0);
    ~SetupMetadata();

    void applySettings();

private:

    void readSettings();

private Q_SLOTS:

    void slotProcessExiv2Url(const QString& url);

private:

    SetupMetadataPriv* const d;
};

}  // namespace ShowFoto

#endif // SETUPMETADATA_H 
