/*
 * This file is part of telepathy-presence-applet
 *
 * Copyright (C) 2011 Francesco Nwokeka <francesco.nwokeka@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: presenceIcon;

    height: 22;
    width: 22;

    property int presenceId;
    property string presenceStatusText;
    property string iconName;

    signal clicked();

    // get color from current plasma theme
    property QtObject theme: PlasmaCore.Theme {}

    Item {
        id: iconContainer;

        anchors.fill: parent;

        PlasmaWidgets.IconWidget {
            id: presencePlasmaIconWidget
            anchors.fill: parent;
            Component.onCompleted: {
                setPresenceIcon(iconName);
            }
        }

        MouseArea {
            anchors.fill: parent;
            onClicked: {
                // emit clicked signal
                presenceIcon.clicked();
            }
        }
    }

    Text {
        id: presenceText;
        text:  presenceStatusText;
        anchors.left: iconContainer.right;
        anchors.verticalCenter: iconContainer.verticalCenter
        anchors.leftMargin: 5;
        color: theme.textColor;

        MouseArea {
            anchors.fill: parent
            onClicked: {
                // emit clicked signal
                presenceIcon.clicked();
            }
        }
    }

    function setPresenceIcon(presenceType)
    {
        iconName = presenceType;

        // special case. DataEngine gives me "available" but kde icon is "user-online"
        if (iconName == "available") {
            presencePlasmaIconWidget.setIcon("user-online");
        } else {
            presencePlasmaIconWidget.setIcon("user-" + iconName);
        }
    }
}
