/*
 * Copyright 2010 Ben Herrenschmidt, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef __WSP_PCI_H
#define __WSP_PCI_H

/* Architected registers */
#define PCIE_REG_DMA_CHAN_STATUS	0x110
#define PCIE_REG_CPU_LOADSTORE_STATUS	0x120

#define PCIE_REG_CONFIG_DATA		0x130
#define PCIE_REG_LOCK0			0x138
#define PCIE_REG_CONFIG_ADDRESS		0x140
#define   PCIE_REG_CA_ENABLE			0x8000000000000000ull
#define	  PCIE_REG_CA_BUS_MASK			0x0ff0000000000000ull
#define   PCIE_REG_CA_BUS_SHIFT			(20+32)
#define   PCIE_REG_CA_DEV_MASK			0x000f800000000000ull
#define   PCIE_REG_CA_DEV_SHIFT			(15+32)
#define   PCIE_REG_CA_FUNC_MASK			0x0000700000000000ull
#define   PCIE_REG_CA_FUNC_SHIFT		(12+32)
#define   PCIE_REG_CA_REG_MASK			0x00000fff00000000ull
#define   PCIE_REG_CA_REG_SHIFT			( 0+32)
#define   PCIE_REG_CA_BE_MASK			0x00000000f0000000ull
#define   PCIE_REG_CA_BE_SHIFT			(   28)
#define PCIE_REG_LOCK1			0x148

#define PCIE_REG_PHB_CONFIG		0x160
#define   PCIE_REG_PHBC_64B_TCE_EN		0x2000000000000000ull
#define   PCIE_REG_PHBC_MMIO_DMA_FREEZE_EN	0x1000000000000000ull
#define   PCIE_REG_PHBC_32BIT_MSI_EN		0x0080000000000000ull
#define   PCIE_REG_PHBC_M64_EN			0x0040000000000000ull
#define   PCIE_REG_PHBC_IO_EN			0x0008000000000000ull
#define   PCIE_REG_PHBC_64BIT_MSI_EN		0x0002000000000000ull
#define   PCIE_REG_PHBC_M32A_EN			0x0000800000000000ull
#define   PCIE_REG_PHBC_M32B_EN			0x0000400000000000ull
#define   PCIE_REG_PHBC_MSI_PE_VALIDATE		0x0000200000000000ull
#define   PCIE_REG_PHBC_DMA_XLATE_BYPASS	0x0000100000000000ull

#define PCIE_REG_IO_BASE_ADDR		0x170
#define PCIE_REG_IO_BASE_MASK		0x178
#define PCIE_REG_IO_START_ADDR		0x180

#define PCIE_REG_M32A_BASE_ADDR		0x190
#define PCIE_REG_M32A_BASE_MASK		0x198
#define PCIE_REG_M32A_START_ADDR	0x1a0

#define PCIE_REG_M32B_BASE_ADDR		0x1b0
#define PCIE_REG_M32B_BASE_MASK		0x1b8
#define PCIE_REG_M32B_START_ADDR	0x1c0

#define PCIE_REG_M64_BASE_ADDR		0x1e0
#define PCIE_REG_M64_BASE_MASK		0x1e8
#define PCIE_REG_M64_START_ADDR		0x1f0

#define PCIE_REG_TCE_KILL		0x210
#define   PCIE_REG_TCEKILL_SINGLE	0x8000000000000000ull
#define   PCIE_REG_TCEKILL_ADDR_MASK	0x000003fffffffff8ull
#define   PCIE_REG_TCEKILL_PS_4K	0
#define   PCIE_REG_TCEKILL_PS_64K	1
#define   PCIE_REG_TCEKILL_PS_16M	2
#define   PCIE_REG_TCEKILL_PS_16G	3

#define PCIE_REG_IODA_ADDR		0x220
#define   PCIE_REG_IODA_AD_AUTOINC	0x8000000000000000ull
#define   PCIE_REG_IODA_AD_TBL_MVT	0x0005000000000000ull
#define   PCIE_REG_IODA_AD_TBL_PELT	0x0006000000000000ull
#define   PCIE_REG_IODA_AD_TBL_PESTA	0x0007000000000000ull
#define   PCIE_REG_IODA_AD_TBL_PESTB	0x0008000000000000ull
#define   PCIE_REG_IODA_AD_TBL_TVT	0x0009000000000000ull
#define   PCIE_REG_IODA_AD_TBL_TCE	0x000a000000000000ull
#define PCIE_REG_IODA_DATA0		0x228
#define PCIE_REG_IODA_DATA1		0x230

#define PCIE_REG_LOCK2			0x240

#define PCIE_REG_PHB_GEN_CAP		0x250
#define PCIE_REG_PHB_TCE_CAP		0x258
#define PCIE_REG_PHB_IRQ_CAP		0x260
#define PCIE_REG_PHB_EEH_CAP		0x268

#define PCIE_REG_PAPR_ERR_INJ_CONTROL	0x2b0
#define PCIE_REG_PAPR_ERR_INJ_ADDR	0x2b8
#define PCIE_REG_PAPR_ERR_INJ_MASK	0x2c0


#define PCIE_REG_SYS_CFG1		0x600
#define   PCIE_REG_SYS_CFG1_CLASS_CODE	0x0000000000ffffffull

#define IODA_TVT0_TTA_MASK		0x000fffffffff0000ull
#define IODA_TVT0_TTA_SHIFT		4
#define IODA_TVT0_BUSNUM_VALID_MASK	0x000000000000e000ull
#define IODA_TVT0_TCE_TABLE_SIZE_MASK	0x0000000000001f00ull
#define IODA_TVT0_TCE_TABLE_SIZE_SHIFT	8
#define IODA_TVT0_BUSNUM_VALUE_MASK	0x00000000000000ffull
#define IODA_TVT0_BUSNUM_VALID_SHIFT	0
#define IODA_TVT1_DEVNUM_VALID		0x2000000000000000ull
#define IODA_TVT1_DEVNUM_VALUE_MASK	0x1f00000000000000ull
#define IODA_TVT1_DEVNUM_VALUE_SHIFT	56
#define IODA_TVT1_FUNCNUM_VALID		0x0008000000000000ull
#define IODA_TVT1_FUNCNUM_VALUE_MASK	0x0007000000000000ull
#define IODA_TVT1_FUNCNUM_VALUE_SHIFT	48
#define IODA_TVT1_IO_PAGE_SIZE_MASK	0x00001f0000000000ull
#define IODA_TVT1_IO_PAGE_SIZE_SHIFT	40
#define IODA_TVT1_PE_NUMBER_MASK	0x000000000000003full
#define IODA_TVT1_PE_NUMBER_SHIFT	0

#define IODA_TVT_COUNT			64

/* UTL Core registers */
#define PCIE_UTL_SYS_BUS_CONTROL	0x400
#define PCIE_UTL_STATUS			0x408
#define PCIE_UTL_SYS_BUS_AGENT_STATUS	0x410
#define PCIE_UTL_SYS_BUS_AGENT_ERR_SEV	0x418
#define PCIE_UTL_SYS_BUS_AGENT_IRQ_EN	0x420
#define PCIE_UTL_SYS_BUS_BURST_SZ_CONF	0x440
#define PCIE_UTL_REVISION_ID		0x448

#define PCIE_UTL_OUT_POST_HDR_BUF_ALLOC	0x4c0
#define PCIE_UTL_OUT_POST_DAT_BUF_ALLOC	0x4d0
#define PCIE_UTL_IN_POST_HDR_BUF_ALLOC	0x4e0
#define PCIE_UTL_IN_POST_DAT_BUF_ALLOC	0x4f0
#define PCIE_UTL_OUT_NP_BUF_ALLOC	0x500
#define PCIE_UTL_IN_NP_BUF_ALLOC	0x510
#define PCIE_UTL_PCIE_TAGS_ALLOC	0x520
#define PCIE_UTL_GBIF_READ_TAGS_ALLOC	0x530

#define PCIE_UTL_PCIE_PORT_CONTROL	0x540
#define PCIE_UTL_PCIE_PORT_STATUS	0x548
#define PCIE_UTL_PCIE_PORT_ERROR_SEV	0x550
#define PCIE_UTL_PCIE_PORT_IRQ_EN	0x558
#define PCIE_UTL_RC_STATUS		0x560
#define PCIE_UTL_RC_ERR_SEVERITY	0x568
#define PCIE_UTL_RC_IRQ_EN		0x570
#define PCIE_UTL_EP_STATUS		0x578
#define PCIE_UTL_EP_ERR_SEVERITY	0x580
#define PCIE_UTL_EP_ERR_IRQ_EN		0x588

#define PCIE_UTL_PCI_PM_CTRL1		0x590
#define PCIE_UTL_PCI_PM_CTRL2		0x598

/* PCIe stack registers */
#define PCIE_REG_SYSTEM_CONFIG1		0x600
#define PCIE_REG_SYSTEM_CONFIG2		0x608
#define PCIE_REG_EP_SYSTEM_CONFIG	0x618
#define PCIE_REG_EP_FLR			0x620
#define PCIE_REG_EP_BAR_CONFIG		0x628
#define PCIE_REG_LINK_CONFIG		0x630
#define PCIE_REG_PM_CONFIG		0x640
#define PCIE_REG_DLP_CONTROL		0x650
#define PCIE_REG_DLP_STATUS		0x658
#define PCIE_REG_ERR_REPORT_CONTROL	0x660
#define PCIE_REG_SLOT_CONTROL1		0x670
#define PCIE_REG_SLOT_CONTROL2		0x678
#define PCIE_REG_UTL_CONFIG		0x680
#define PCIE_REG_BUFFERS_CONFIG		0x690
#define PCIE_REG_ERROR_INJECT		0x698
#define PCIE_REG_SRIOV_CONFIG		0x6a0
#define PCIE_REG_PF0_SRIOV_STATUS	0x6a8
#define PCIE_REG_PF1_SRIOV_STATUS	0x6b0
#define PCIE_REG_PORT_NUMBER		0x700
#define PCIE_REG_POR_SYSTEM_CONFIG	0x708

/* PHB internal logic registers */
#define PCIE_REG_PHB_VERSION		0x800
#define PCIE_REG_RESET			0x808
#define PCIE_REG_PHB_CONTROL		0x810
#define PCIE_REG_PHB_TIMEOUT_CONTROL1	0x878
#define PCIE_REG_PHB_QUIESCE_DMA	0x888
#define PCIE_REG_PHB_DMA_READ_TAG_ACTV	0x900
#define PCIE_REG_PHB_TCE_READ_TAG_ACTV	0x908

/* FIR registers */
#define PCIE_REG_LEM_FIR_ACCUM		0xc00
#define PCIE_REG_LEM_FIR_AND_MASK	0xc08
#define PCIE_REG_LEM_FIR_OR_MASK	0xc10
#define PCIE_REG_LEM_ACTION0		0xc18
#define PCIE_REG_LEM_ACTION1		0xc20
#define PCIE_REG_LEM_ERROR_MASK		0xc30
#define PCIE_REG_LEM_ERROR_AND_MASK	0xc38
#define PCIE_REG_LEM_ERROR_OR_MASK	0xc40

/* PHB Error registers */
#define PCIE_REG_PHB_ERR_STATUS		0xc80
#define PCIE_REG_PHB_ERR1_STATUS	0xc88
#define PCIE_REG_PHB_ERR_INJECT		0xc90
#define PCIE_REG_PHB_ERR_LEM_ENABLE	0xc98
#define PCIE_REG_PHB_ERR_IRQ_ENABLE	0xca0
#define PCIE_REG_PHB_ERR_FREEZE_ENABLE	0xca8
#define PCIE_REG_PHB_ERR_SIDE_ENABLE	0xcb8
#define PCIE_REG_PHB_ERR_LOG_0		0xcc0
#define PCIE_REG_PHB_ERR_LOG_1		0xcc8
#define PCIE_REG_PHB_ERR_STATUS_MASK	0xcd0
#define PCIE_REG_PHB_ERR1_STATUS_MASK	0xcd8

#define PCIE_REG_MMIO_ERR_STATUS	0xd00
#define PCIE_REG_MMIO_ERR1_STATUS	0xd08
#define PCIE_REG_MMIO_ERR_INJECT	0xd10
#define PCIE_REG_MMIO_ERR_LEM_ENABLE	0xd18
#define PCIE_REG_MMIO_ERR_IRQ_ENABLE	0xd20
#define PCIE_REG_MMIO_ERR_FREEZE_ENABLE	0xd28
#define PCIE_REG_MMIO_ERR_SIDE_ENABLE	0xd38
#define PCIE_REG_MMIO_ERR_LOG_0		0xd40
#define PCIE_REG_MMIO_ERR_LOG_1		0xd48
#define PCIE_REG_MMIO_ERR_STATUS_MASK	0xd50
#define PCIE_REG_MMIO_ERR1_STATUS_MASK	0xd58

#define PCIE_REG_DMA_ERR_STATUS		0xd80
#define PCIE_REG_DMA_ERR1_STATUS	0xd88
#define PCIE_REG_DMA_ERR_INJECT		0xd90
#define PCIE_REG_DMA_ERR_LEM_ENABLE	0xd98
#define PCIE_REG_DMA_ERR_IRQ_ENABLE	0xda0
#define PCIE_REG_DMA_ERR_FREEZE_ENABLE	0xda8
#define PCIE_REG_DMA_ERR_SIDE_ENABLE	0xdb8
#define PCIE_REG_DMA_ERR_LOG_0		0xdc0
#define PCIE_REG_DMA_ERR_LOG_1		0xdc8
#define PCIE_REG_DMA_ERR_STATUS_MASK	0xdd0
#define PCIE_REG_DMA_ERR1_STATUS_MASK	0xdd8

/* Shortcuts for access to the above using the PHB definitions
 * with an offset
 */
#define PCIE_REG_ERR_PHB_OFFSET		0x0
#define PCIE_REG_ERR_MMIO_OFFSET	0x80
#define PCIE_REG_ERR_DMA_OFFSET		0x100

/* Debug and Trace registers */
#define PCIE_REG_PHB_DEBUG_CONTROL0	0xe00
#define PCIE_REG_PHB_DEBUG_STATUS0	0xe08
#define PCIE_REG_PHB_DEBUG_CONTROL1	0xe10
#define PCIE_REG_PHB_DEBUG_STATUS1	0xe18
#define PCIE_REG_PHB_DEBUG_CONTROL2	0xe20
#define PCIE_REG_PHB_DEBUG_STATUS2	0xe28
#define PCIE_REG_PHB_DEBUG_CONTROL3	0xe30
#define PCIE_REG_PHB_DEBUG_STATUS3	0xe38
#define PCIE_REG_PHB_DEBUG_CONTROL4	0xe40
#define PCIE_REG_PHB_DEBUG_STATUS4	0xe48
#define PCIE_REG_PHB_DEBUG_CONTROL5	0xe50
#define PCIE_REG_PHB_DEBUG_STATUS5	0xe58
#define PCIE_REG_PHB_DEBUG_CONTROL6	0xe60
#define PCIE_REG_PHB_DEBUG_STATUS6	0xe68

/* Definition for PCIe errors */
struct wsp_pcie_err_log_data {
	__u64	phb_err;
	__u64	phb_err1;
	__u64	phb_log0;
	__u64	phb_log1;
	__u64	mmio_err;
	__u64	mmio_err1;
	__u64	mmio_log0;
	__u64	mmio_log1;
	__u64	dma_err;
	__u64	dma_err1;
	__u64	dma_log0;
	__u64	dma_log1;
	__u64	utl_sys_err;
	__u64	utl_port_err;
	__u64	utl_rc_err;
	__u64	unused;
};

#endif /* __WSP_PCI_H */
