/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.security.OAuthFlow;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedOAuthFlow
implements ComposedChanged {
    private OAuthFlow oldOAuthFlow;
    private OAuthFlow newOAuthFlow;
    private final DiffContext context;
    private boolean authorizationUrl;
    private boolean tokenUrl;
    private boolean refreshUrl;
    private ChangedExtensions extensions;

    public ChangedOAuthFlow(OAuthFlow oldOAuthFlow, OAuthFlow newOAuthFlow, DiffContext context) {
        this.oldOAuthFlow = oldOAuthFlow;
        this.newOAuthFlow = newOAuthFlow;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Collections.singletonList(this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (!(this.authorizationUrl || this.tokenUrl || this.refreshUrl)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.authorizationUrl && BackwardIncompatibleProp.SECURITY_SCHEME_OAUTH2_AUTH_URL_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.refreshUrl && BackwardIncompatibleProp.SECURITY_SCHEME_OAUTH2_REFRESH_URL_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.tokenUrl && BackwardIncompatibleProp.SECURITY_SCHEME_OAUTH2_TOKEN_URL_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public OAuthFlow getOldOAuthFlow() {
        return this.oldOAuthFlow;
    }

    public OAuthFlow getNewOAuthFlow() {
        return this.newOAuthFlow;
    }

    public boolean isAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public boolean isTokenUrl() {
        return this.tokenUrl;
    }

    public boolean isRefreshUrl() {
        return this.refreshUrl;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedOAuthFlow setOldOAuthFlow(OAuthFlow oldOAuthFlow) {
        this.oldOAuthFlow = oldOAuthFlow;
        return this;
    }

    public ChangedOAuthFlow setNewOAuthFlow(OAuthFlow newOAuthFlow) {
        this.newOAuthFlow = newOAuthFlow;
        return this;
    }

    public ChangedOAuthFlow setAuthorizationUrl(boolean authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public ChangedOAuthFlow setTokenUrl(boolean tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public ChangedOAuthFlow setRefreshUrl(boolean refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public ChangedOAuthFlow setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedOAuthFlow that = (ChangedOAuthFlow)o;
        return this.authorizationUrl == that.authorizationUrl && this.tokenUrl == that.tokenUrl && this.refreshUrl == that.refreshUrl && Objects.equals(this.oldOAuthFlow, that.oldOAuthFlow) && Objects.equals(this.newOAuthFlow, that.newOAuthFlow) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldOAuthFlow, this.newOAuthFlow, this.authorizationUrl, this.tokenUrl, this.refreshUrl, this.extensions);
    }

    public String toString() {
        return "ChangedOAuthFlow(oldOAuthFlow=" + this.getOldOAuthFlow() + ", newOAuthFlow=" + this.getNewOAuthFlow() + ", authorizationUrl=" + this.isAuthorizationUrl() + ", tokenUrl=" + this.isTokenUrl() + ", refreshUrl=" + this.isRefreshUrl() + ", extensions=" + this.getExtensions() + ")";
    }
}

