/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingBiFunction;
import org.springframework.util.function.ThrowingSupplier;

@FunctionalInterface
public interface InstanceSupplier<T>
extends ThrowingSupplier<T> {
    @Override
    default public T getWithException() {
        throw new IllegalStateException("No RegisteredBean parameter provided");
    }

    public T get(RegisteredBean var1) throws Exception;

    @Nullable
    default public Method getFactoryMethod() {
        return null;
    }

    default public <V> InstanceSupplier<V> andThen(final ThrowingBiFunction<RegisteredBean, ? super T, ? extends V> after) {
        Assert.notNull(after, "'after' function must not be null");
        return new InstanceSupplier<V>(){

            @Override
            public V get(RegisteredBean registeredBean) throws Exception {
                return after.applyWithException(registeredBean, InstanceSupplier.this.get(registeredBean));
            }

            @Override
            @Nullable
            public Method getFactoryMethod() {
                return InstanceSupplier.this.getFactoryMethod();
            }
        };
    }

    public static <T> InstanceSupplier<T> using(ThrowingSupplier<T> supplier) {
        Assert.notNull(supplier, "Supplier must not be null");
        if (supplier instanceof InstanceSupplier) {
            InstanceSupplier instanceSupplier = (InstanceSupplier)supplier;
            return instanceSupplier;
        }
        return registeredBean -> supplier.getWithException();
    }

    public static <T> InstanceSupplier<T> using(final @Nullable Method factoryMethod, final ThrowingSupplier<T> supplier) {
        InstanceSupplier instanceSupplier;
        Assert.notNull(supplier, "Supplier must not be null");
        if (supplier instanceof InstanceSupplier && (instanceSupplier = (InstanceSupplier)supplier).getFactoryMethod() == factoryMethod) {
            return instanceSupplier;
        }
        return new InstanceSupplier<T>(){

            @Override
            public T get(RegisteredBean registeredBean) throws Exception {
                return supplier.getWithException();
            }

            @Override
            @Nullable
            public Method getFactoryMethod() {
                return factoryMethod;
            }
        };
    }

    public static <T> InstanceSupplier<T> of(InstanceSupplier<T> instanceSupplier) {
        Assert.notNull(instanceSupplier, "InstanceSupplier must not be null");
        return instanceSupplier;
    }
}

