/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.OpenType;
import org.jolokia.service.serializer.object.ArrayTypeConverter;
import org.jolokia.service.serializer.object.CompositeTypeConverter;
import org.jolokia.service.serializer.object.Converter;
import org.jolokia.service.serializer.object.OpenTypeConverter;
import org.jolokia.service.serializer.object.SimpleTypeConverter;
import org.jolokia.service.serializer.object.TabularDataConverter;

public class ObjectToOpenTypeConverter
implements Converter<OpenType<?>> {
    protected final boolean forgiving;
    private final List<OpenTypeConverter<? extends OpenType<?>>> converters;

    public ObjectToOpenTypeConverter(Converter<String> pObjectToObjectConverter, boolean pForgiving) {
        this.converters = Arrays.asList(new SimpleTypeConverter(this, pObjectToObjectConverter), new ArrayTypeConverter(this), new CompositeTypeConverter(this), new TabularDataConverter(this));
        this.forgiving = pForgiving;
    }

    @Override
    public Object convert(OpenType<?> pOpenType, Object pValue) {
        if (pValue == null) {
            return null;
        }
        for (OpenTypeConverter<OpenType<?>> converter : this.converters) {
            if (!converter.canConvert(pOpenType)) continue;
            return this.invokeConverter(converter, pOpenType, pValue);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(pValue) + " to " + String.valueOf(pOpenType) + ": No converter could be found");
    }

    private <T extends OpenType<?>> Object invokeConverter(OpenTypeConverter<T> converter, OpenType<?> pOpenType, Object pValue) {
        OpenType<?> casted = pOpenType;
        return converter.convert(casted, pValue);
    }

    public boolean isForgiving() {
        return this.forgiving;
    }
}

