/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.brooklyn.api.location.MachineManagementMixins;
import org.apache.brooklyn.core.location.MachineLifecycleUtils;

public class BasicMachineMetadata
implements MachineManagementMixins.MachineMetadata,
MachineLifecycleUtils.GivesMachineStatus {
    final String id;
    final String name;
    final String primaryIp;
    final Boolean isRunning;
    final MachineLifecycleUtils.MachineStatus status;
    final Object originalMetadata;

    public BasicMachineMetadata(String id, String name, String primaryIp, MachineLifecycleUtils.MachineStatus status, Object originalMetadata) {
        this.id = id;
        this.name = name;
        this.primaryIp = primaryIp;
        this.status = status;
        this.isRunning = MachineLifecycleUtils.MachineStatus.RUNNING.equals((Object)status);
        this.originalMetadata = originalMetadata;
    }

    @Deprecated
    public BasicMachineMetadata(String id, String name, String primaryIp, Boolean isRunning, Object originalMetadata) {
        this.id = id;
        this.name = name;
        this.primaryIp = primaryIp;
        this.isRunning = isRunning;
        this.status = Boolean.TRUE.equals(isRunning) ? MachineLifecycleUtils.MachineStatus.RUNNING : MachineLifecycleUtils.MachineStatus.UNKNOWN;
        this.originalMetadata = originalMetadata;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryIp() {
        return this.primaryIp;
    }

    public Boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public MachineLifecycleUtils.MachineStatus getStatus() {
        if (this.status != null) {
            return this.status;
        }
        if (this.isRunning().booleanValue()) {
            return MachineLifecycleUtils.MachineStatus.RUNNING;
        }
        return MachineLifecycleUtils.MachineStatus.UNKNOWN;
    }

    public Object getOriginalMetadata() {
        return this.originalMetadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.isRunning, this.name, this.originalMetadata, this.primaryIp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicMachineMetadata other = (BasicMachineMetadata)obj;
        if (!Objects.equal((Object)this.id, (Object)other.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)other.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.primaryIp, (Object)other.primaryIp)) {
            return false;
        }
        if (!Objects.equal((Object)this.isRunning, (Object)other.isRunning)) {
            return false;
        }
        return Objects.equal((Object)this.originalMetadata, (Object)other.originalMetadata);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("originalMetadata", this.originalMetadata).toString();
    }
}

