/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.exceptions;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.CanSkipInContext;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.Strings;

public class Exceptions {
    private static final List<Class<? extends Throwable>> ALWAYS_BORING_MESSAGE_THROWABLE_SUPERTYPES = ImmutableList.of(ExecutionException.class, InvocationTargetException.class, UndeclaredThrowableException.class);
    private static final List<Class<? extends Throwable>> BORING_IF_NO_MESSAGE_THROWABLE_SUPERTYPES = ImmutableList.of(PropagatedRuntimeException.class, RuntimeInterruptedException.class);
    public static final int MAX_COLLAPSE_RECURSIVE_DEPTH = 100;
    private static final Predicate<Throwable> IS_THROWABLE_BORING_FOR_MESSAGE = new Predicate<Throwable>(){

        public boolean apply(Throwable input) {
            return Exceptions.isBoringForMessage(input);
        }
    };
    private static List<Class<? extends Throwable>> BORING_PREFIX_THROWABLE_EXACT_TYPES = ImmutableList.of(RuntimeException.class, Exception.class, Throwable.class, IllegalStateException.class, IllegalArgumentException.class);
    private static List<Class<? extends Throwable>> BORING_PREFIX_THROWABLE_SUPERTYPES = ImmutableList.of(ClassCastException.class, CompoundRuntimeException.class, PropagatedRuntimeException.class);

    private static boolean isBoringForMessage(Throwable t) {
        for (Class<? extends Throwable> type : ALWAYS_BORING_MESSAGE_THROWABLE_SUPERTYPES) {
            if (!type.isInstance(t)) continue;
            return true;
        }
        if (Strings.isBlank(t.getMessage()) || t.getCause() != null && t.getCause() != t && (t.getCause() instanceof PropagatedRuntimeException ? t.getMessage().equals(t.getCause().getMessage()) : t.getMessage().equals(t.getCause().toString()))) {
            for (Class<? extends Throwable> type : BORING_IF_NO_MESSAGE_THROWABLE_SUPERTYPES) {
                if (!type.isInstance(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPrefixBoring(Throwable t) {
        if (t == null) {
            return false;
        }
        if (Exceptions.isBoringForMessage(t)) {
            return true;
        }
        if (t instanceof UserFacingException) {
            return true;
        }
        for (Class<? extends Throwable> type : BORING_PREFIX_THROWABLE_EXACT_TYPES) {
            if (!t.getClass().equals(type)) continue;
            return true;
        }
        for (Class<? extends Throwable> type : BORING_PREFIX_THROWABLE_SUPERTYPES) {
            if (!type.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    static String stripBoringPrefixes(String s) {
        ArrayList prefixes = Lists.newArrayListWithCapacity((int)(2 + BORING_PREFIX_THROWABLE_EXACT_TYPES.size() * 3));
        for (Class<? extends Throwable> type : BORING_PREFIX_THROWABLE_EXACT_TYPES) {
            prefixes.add(type.getCanonicalName());
            prefixes.add(type.getName());
            prefixes.add(type.getSimpleName());
        }
        prefixes.add(":");
        prefixes.add(" ");
        String[] ps = prefixes.toArray(new String[prefixes.size()]);
        return Strings.removeAllFromStart(s, ps);
    }

    public static RuntimeException propagate(Throwable throwable) {
        Exceptions.propagateIfInterrupt(throwable);
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new PropagatedRuntimeException(throwable);
    }

    @Deprecated
    public static RuntimeException propagate(String msg, Throwable throwable) {
        return Exceptions.propagate(msg, throwable, false);
    }

    public static RuntimeException propagateAnnotateIfWrapping(String msg, Throwable throwable) {
        return Exceptions.propagate(msg, throwable, false);
    }

    public static RuntimeException propagateAnnotated(String msg, Throwable throwable) {
        return Exceptions.propagate(msg, throwable, true);
    }

    private static RuntimeException propagate(String msg, Throwable throwable, boolean alwaysAnnotate) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeInterruptedException(Exceptions.isCauseEmbedded(msg, throwable) ? msg : msg + ": " + Exceptions.collapseText(throwable), (InterruptedException)throwable);
        }
        if (throwable instanceof RuntimeInterruptedException) {
            Thread.currentThread().interrupt();
            if (alwaysAnnotate) {
                throw new RuntimeInterruptedException(Exceptions.isCauseEmbedded(msg, throwable) ? msg : msg + ": " + Exceptions.collapseText(throwable), (RuntimeInterruptedException)throwable);
            }
            throw (RuntimeInterruptedException)throwable;
        }
        if (throwable == null) {
            throw new PropagatedRuntimeException(msg, new NullPointerException("No throwable supplied."));
        }
        if (!alwaysAnnotate) {
            Throwables.propagateIfPossible((Throwable)((Throwable)Preconditions.checkNotNull((Object)throwable)));
        }
        throw new PropagatedRuntimeException(msg, throwable);
    }

    public static void propagateIfInterrupt(Throwable throwable) {
        if (throwable != null && Exceptions.isCausedByInterruptInThisThread(throwable)) {
            Exceptions.reinterruptIfNecessary(throwable);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeInterruptedException(throwable);
        }
    }

    static boolean reinterruptIfNecessary(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public static void propagateIfFatal(Throwable throwable) {
        Exceptions.propagateIfInterrupt(throwable);
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static boolean isFatal(Throwable throwable) {
        return throwable instanceof InterruptedException || throwable instanceof RuntimeInterruptedException || throwable instanceof Error;
    }

    public static Predicate<Throwable> isFatalPredicate() {
        return IsFatalPredicate.INSTANCE;
    }

    public static void handleRootCauseIsInterruption(Throwable e) {
        if (Exceptions.isCausedByInterruptInThisThread(e)) {
            Exceptions.reinterruptIfNecessary(e);
            throw new RuntimeInterruptedException(e);
        }
    }

    public static boolean isRootCauseIsInterruption(Throwable e) {
        Throwable root = Throwables.getRootCause((Throwable)e);
        return root instanceof InterruptedException || root instanceof RuntimeInterruptedException;
    }

    public static boolean isCausedByInterruptInAnyThread(Throwable e) {
        Throwable interrupt = Exceptions.getFirstThrowableMatching(e, (Predicate<? super Throwable>)((Predicate)t -> t instanceof InterruptedException || t instanceof RuntimeInterruptedException));
        return interrupt != null;
    }

    public static boolean isCausedByInterruptInThisThread(Throwable e) {
        Throwable interrupt = Exceptions.getFirstThrowableMatching(e, (Predicate<? super Throwable>)((Predicate)t -> t instanceof InterruptedException || t instanceof RuntimeInterruptedException));
        if (interrupt == null) {
            return false;
        }
        if (interrupt instanceof RuntimeInterruptedException) {
            return ((RuntimeInterruptedException)interrupt).isFromCurrentThread();
        }
        return true;
    }

    public static boolean isCauseEmbedded(String message, Throwable cause) {
        if (cause == null) {
            return true;
        }
        if (message == null) {
            return false;
        }
        String causalText = Exceptions.collapseText(cause);
        if (Strings.isBlank(causalText)) {
            return false;
        }
        return message.endsWith(causalText);
    }

    public static <T extends Throwable> T getFirstThrowableOfType(Throwable from, Class<T> clazz) {
        return (T)((Throwable)Iterables.tryFind(Exceptions.getCausalChain(from), (Predicate)Predicates.instanceOf(clazz)).orNull());
    }

    public static Throwable getFirstThrowableMatching(Throwable from, Predicate<? super Throwable> filter) {
        return (Throwable)Iterables.tryFind(Exceptions.getCausalChain(from), filter).orNull();
    }

    public static Throwable getFirstInteresting(Throwable throwable) {
        return (Throwable)Iterables.tryFind(Exceptions.getCausalChain(throwable), (Predicate)Predicates.not(IS_THROWABLE_BORING_FOR_MESSAGE)).or((Object)throwable);
    }

    public static Throwable collapse(Throwable source) {
        return Exceptions.collapse(source, true);
    }

    public static Throwable collapseIncludingAllCausalMessages(Throwable source) {
        return Exceptions.collapse(source, true, true, (Set<Throwable>)ImmutableSet.of(), new Object[0]);
    }

    public static Throwable collapse(Throwable source, boolean collapseCausalChain) {
        return Exceptions.collapse(source, collapseCausalChain, false, (Set<Throwable>)ImmutableSet.of(), new Object[0]);
    }

    public static List<Throwable> getCausalChain(Throwable t) {
        MutableSet result = MutableSet.of();
        while (t != null && result.add(t)) {
            t = t.getCause();
        }
        return ImmutableList.copyOf(result);
    }

    private static boolean isCausalChainDepthExceeding(Throwable t, int size) {
        if (size < 0) {
            return true;
        }
        if (t == null) {
            return false;
        }
        return Exceptions.isCausalChainDepthExceeding(t.getCause(), size - 1);
    }

    private static Throwable collapse(Throwable source, boolean collapseCausalChain, boolean includeAllCausalMessages, Set<Throwable> visited, Object[] contexts) {
        Throwable messagesCause;
        List<Throwable> chain;
        if (visited.isEmpty() && Exceptions.isCausalChainDepthExceeding(source, 100) && (chain = Exceptions.getCausalChain(source)).size() > 100) {
            String msg = chain.get(0).getMessage();
            if (msg != null && msg.length() > 512) {
                msg = msg.substring(0, 500) + "...";
            }
            return new PropagatedRuntimeException("Huge stack trace (size " + chain.size() + ", removing all but last few), starting: " + chain.get(0).getClass().getName() + ": " + msg + "; ultimately caused by: ", chain.get(chain.size() - 10));
        }
        visited = MutableSet.copyOf(visited);
        String message = "";
        Throwable collapsed = source;
        int collapseCount = 0;
        boolean messageIsFinal = false;
        while ((Exceptions.isBoringForMessage(collapsed) || Exceptions.isSkippableInContext(collapsed, contexts)) && !messageIsFinal) {
            ++collapseCount;
            Throwable cause = collapsed.getCause();
            if (cause == null) {
                return source;
            }
            if (!visited.add(collapsed)) break;
            String collapsedS = collapsed.getMessage();
            if (collapsed instanceof PropagatedRuntimeException && ((PropagatedRuntimeException)collapsed).isCauseEmbeddedInMessage()) {
                message = collapsedS;
                messageIsFinal = true;
            }
            collapsed = cause;
        }
        for (messagesCause = collapsed; messagesCause != null && Exceptions.isPrefixBoring(messagesCause) && Strings.isBlank(message); messagesCause = messagesCause.getCause()) {
            ++collapseCount;
            if (Strings.isNonBlank(messagesCause.getMessage())) {
                message = messagesCause.getMessage();
                messagesCause = messagesCause.getCause();
                break;
            }
            visited.add(messagesCause);
        }
        if (collapseCount == 0 && !includeAllCausalMessages) {
            return source;
        }
        if (collapseCount == 0 && messagesCause != null) {
            message = Exceptions.getMessageWithAppropriatePrefix(messagesCause);
            messagesCause = messagesCause.getCause();
        }
        if (messagesCause != null && !messageIsFinal) {
            String extraMessage = Exceptions.collapseText(messagesCause, includeAllCausalMessages, (Set<Throwable>)ImmutableSet.copyOf(visited), contexts);
            message = Exceptions.appendSeparator(message, extraMessage);
        }
        if (message == null) {
            message = "";
        }
        return new PropagatedRuntimeException(message, collapseCausalChain ? collapsed : source, Strings.isNonBlank(message));
    }

    public static boolean isSkippableInContext(Throwable e, Object ... contexts) {
        if (!(e instanceof CanSkipInContext)) {
            return false;
        }
        for (Object c : contexts) {
            if (!((CanSkipInContext)((Object)e)).canSkipInContext(c)) continue;
            return true;
        }
        return false;
    }

    static String appendSeparator(String message, String next) {
        if (Strings.isBlank(message)) {
            return next;
        }
        if (Strings.isBlank(next)) {
            return message;
        }
        if (message.endsWith(next)) {
            return message;
        }
        if (message.trim().endsWith(":") || message.trim().endsWith(";")) {
            return message.trim() + " " + next;
        }
        return message + ": " + next;
    }

    public static String collapseText(Throwable t) {
        return Exceptions.collapseText(t, false);
    }

    public static String collapseTextInContext(Throwable t, Object ... contexts) {
        return Exceptions.collapseText(t, false, (Set<Throwable>)ImmutableSet.of(), contexts);
    }

    public static String collapseTextIncludingAllCausalMessages(Throwable t) {
        return Exceptions.collapseText(t, true);
    }

    private static String collapseText(Throwable t, boolean includeAllCausalMessages) {
        return Exceptions.collapseText(t, includeAllCausalMessages, (Set<Throwable>)ImmutableSet.of(), new Object[0]);
    }

    private static String collapseText(Throwable t, boolean includeAllCausalMessages, Set<Throwable> visited, Object[] contexts) {
        if (t == null) {
            return null;
        }
        if (visited.contains(t)) {
            if (Strings.isNonBlank(t.getMessage())) {
                return t.getMessage();
            }
            if (t.getCause() != null) {
                return t.getCause().getClass().getName();
            }
            return t.getClass().getName();
        }
        Throwable t2 = Exceptions.collapse(t, true, includeAllCausalMessages, visited, contexts);
        visited = MutableSet.copyOf(visited);
        visited.add(t);
        visited.add(t2);
        if (t2 instanceof PropagatedRuntimeException) {
            if (((PropagatedRuntimeException)t2).isCauseEmbeddedInMessage()) {
                return t2.getMessage();
            }
            if (t2.getCause() != null) {
                return Exceptions.collapseText(t2.getCause(), includeAllCausalMessages, (Set<Throwable>)ImmutableSet.copyOf(visited), contexts);
            }
            return "" + t2.getClass();
        }
        String result = Exceptions.getMessageWithAppropriatePrefix(t2);
        if (!includeAllCausalMessages) {
            return result;
        }
        Throwable cause = t2.getCause();
        if (cause != null) {
            String causeResult = Exceptions.collapseTextInContext(new PropagatedRuntimeException(cause), contexts);
            if (result.indexOf(causeResult) >= 0) {
                return result;
            }
            return result + "; caused by " + causeResult;
        }
        return result;
    }

    public static RuntimeException propagate(Iterable<? extends Throwable> exceptions) {
        throw Exceptions.propagate(Exceptions.create(exceptions));
    }

    public static RuntimeException propagate(String prefix, Iterable<? extends Throwable> exceptions) {
        throw Exceptions.propagate(Exceptions.create(prefix, exceptions));
    }

    public static Throwable create(Iterable<? extends Throwable> exceptions) {
        return Exceptions.create(null, exceptions);
    }

    public static RuntimeException create(@Nullable String prefix, Iterable<? extends Throwable> exceptions) {
        if (Iterables.size(exceptions) == 1) {
            Throwable e = exceptions.iterator().next();
            if (Strings.isBlank(prefix)) {
                return new PropagatedRuntimeException(e);
            }
            return new PropagatedRuntimeException(prefix + ": " + Exceptions.collapseText(e), e);
        }
        if (Iterables.isEmpty(exceptions)) {
            if (Strings.isBlank(prefix)) {
                return new CompoundRuntimeException("(empty compound exception)", exceptions);
            }
            return new CompoundRuntimeException(prefix, exceptions);
        }
        if (Strings.isBlank(prefix)) {
            return new CompoundRuntimeException(Iterables.size(exceptions) + " errors, including: " + Exceptions.collapseText(exceptions.iterator().next()), exceptions);
        }
        return new CompoundRuntimeException(prefix + "; " + Iterables.size(exceptions) + " errors including: " + Exceptions.collapseText(exceptions.iterator().next()), exceptions);
    }

    @Beta
    public static boolean isPrefixRequiredForMessageToMakeSense(Throwable t) {
        return t instanceof NoClassDefFoundError;
    }

    private static String getPrefixText(Throwable t) {
        if (t instanceof NoClassDefFoundError) {
            return "Invalid java type";
        }
        if (Exceptions.isPrefixBoring(t)) {
            return "";
        }
        return JavaClassNames.cleanSimpleClassName(t);
    }

    public static String getMessageWithAppropriatePrefix(Throwable t) {
        return Exceptions.appendSeparator(Exceptions.getPrefixText(t), t.getMessage());
    }

    public static boolean isRootBoringClassNotFound(Exception e, String clazz) {
        Throwable root = Throwables.getRootCause((Throwable)e);
        if (!(root instanceof ClassNotFoundException)) {
            return false;
        }
        return clazz.equals(root.getMessage());
    }

    public static class CollapseTextSupplier
    implements Supplier<String> {
        final Throwable cause;

        public CollapseTextSupplier(Throwable cause) {
            this.cause = cause;
        }

        public String get() {
            return Exceptions.collapseText(this.cause);
        }

        public Throwable getOriginal() {
            return this.cause;
        }
    }

    private static class IsFatalPredicate
    implements Predicate<Throwable> {
        private static final IsFatalPredicate INSTANCE = new IsFatalPredicate();

        private IsFatalPredicate() {
        }

        public boolean apply(Throwable input) {
            return input != null && Exceptions.isFatal(input);
        }
    }
}

