/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_LoadBalancer;
import org.jclouds.profitbricks.domain.AutoValue_LoadBalancer_Request_CreatePayload;
import org.jclouds.profitbricks.domain.AutoValue_LoadBalancer_Request_DeregisterPayload;
import org.jclouds.profitbricks.domain.AutoValue_LoadBalancer_Request_RegisterPayload;
import org.jclouds.profitbricks.domain.AutoValue_LoadBalancer_Request_UpdatePayload;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.util.Preconditions;

public abstract class LoadBalancer {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract Algorithm algorithm();

    @Nullable
    public abstract DataCenter dataCenter();

    @Nullable
    public abstract Boolean internetAccess();

    @Nullable
    public abstract String ip();

    @Nullable
    public abstract Integer lanId();

    @Nullable
    public abstract ProvisioningState state();

    @Nullable
    public abstract Date creationTime();

    @Nullable
    public abstract Date lastModificationTime();

    @Nullable
    public abstract List<Server> balancedServers();

    @Nullable
    public abstract List<Firewall> firewalls();

    public static Builder builder() {
        return new AutoValue_LoadBalancer.Builder().balancedServers((List<Server>)ImmutableList.of()).firewalls((List<Firewall>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    public static final class Request {
        public static CreatePayload.Builder creatingBuilder() {
            return new AutoValue_LoadBalancer_Request_CreatePayload.Builder().serverIds((List<String>)ImmutableList.of()).algorithm(Algorithm.ROUND_ROBIN);
        }

        public static UpdatePayload.Builder updatingBuilder() {
            return new AutoValue_LoadBalancer_Request_UpdatePayload.Builder().algorithm(Algorithm.ROUND_ROBIN);
        }

        public static RegisterPayload createRegisteringPaylod(String loadBalancerId, List<String> serverIds) {
            return new AutoValue_LoadBalancer_Request_RegisterPayload(loadBalancerId, (List<String>)ImmutableList.copyOf(serverIds));
        }

        public static DeregisterPayload createDeregisteringPayload(String loadBalancerId, List<String> serverIds) {
            return new AutoValue_LoadBalancer_Request_DeregisterPayload(loadBalancerId, (List<String>)ImmutableList.copyOf(serverIds));
        }

        public static abstract class UpdatePayload {
            public abstract String id();

            @Nullable
            public abstract String name();

            public abstract Algorithm algorithm();

            @Nullable
            public abstract String ip();

            public static abstract class Builder {
                public abstract Builder id(String var1);

                public abstract Builder name(String var1);

                public abstract Builder algorithm(Algorithm var1);

                public abstract Builder ip(String var1);

                abstract UpdatePayload autoBuild();

                public UpdatePayload build() {
                    UpdatePayload payload = this.autoBuild();
                    if (payload.ip() != null) {
                        Preconditions.checkIp(payload.ip());
                    }
                    return payload;
                }
            }
        }

        public static abstract class DeregisterPayload {
            public abstract String id();

            public abstract List<String> serverIds();
        }

        public static abstract class RegisterPayload {
            public abstract String id();

            public abstract List<String> serverIds();
        }

        public static abstract class CreatePayload {
            public abstract String dataCenterId();

            @Nullable
            public abstract String name();

            public abstract Algorithm algorithm();

            @Nullable
            public abstract String ip();

            @Nullable
            public abstract Integer lanId();

            public abstract List<String> serverIds();

            public abstract Builder toBuilder();

            public static abstract class Builder {
                public abstract Builder dataCenterId(String var1);

                public abstract Builder name(String var1);

                public abstract Builder algorithm(Algorithm var1);

                public abstract Builder ip(String var1);

                public abstract Builder lanId(Integer var1);

                public abstract Builder serverIds(List<String> var1);

                abstract CreatePayload autoBuild();

                public CreatePayload build() {
                    CreatePayload payload = this.autoBuild();
                    if (payload.ip() != null) {
                        Preconditions.checkIp(payload.ip());
                    }
                    if (payload.lanId() != null) {
                        Preconditions.checkLanId(payload.lanId());
                    }
                    return payload.toBuilder().serverIds((List<String>)ImmutableList.copyOf(payload.serverIds())).autoBuild();
                }
            }
        }
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder algorithm(Algorithm var1);

        public abstract Builder dataCenter(DataCenter var1);

        public abstract Builder internetAccess(Boolean var1);

        public abstract Builder ip(String var1);

        public abstract Builder lanId(Integer var1);

        public abstract Builder creationTime(Date var1);

        public abstract Builder state(ProvisioningState var1);

        public abstract Builder lastModificationTime(Date var1);

        public abstract Builder balancedServers(List<Server> var1);

        public abstract Builder firewalls(List<Firewall> var1);

        abstract LoadBalancer autoBuild();

        public LoadBalancer build() {
            LoadBalancer loadBalancer = this.autoBuild();
            if (loadBalancer.ip() != null) {
                Preconditions.checkIp(loadBalancer.ip());
            }
            if (loadBalancer.lanId() != null) {
                Preconditions.checkLanId(loadBalancer.lanId());
            }
            return loadBalancer.toBuilder().balancedServers((List<Server>)ImmutableList.copyOf(loadBalancer.balancedServers())).firewalls((List<Firewall>)ImmutableList.copyOf(loadBalancer.firewalls())).autoBuild();
        }
    }

    public static enum Algorithm {
        ROUND_ROBIN,
        UNRECOGNIZED;


        public static Algorithm fromValue(String value) {
            return (Algorithm)((Object)Enums.getIfPresent(Algorithm.class, (String)value).or((Object)UNRECOGNIZED));
        }
    }
}

