/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.WorkflowSoftwareProcessImpl;

@Catalog(name="Vanilla Software Process", description="A software process configured with workflow, e.g. for launch, check-running and stop")
@ImplementedBy(value=WorkflowSoftwareProcessImpl.class)
public interface WorkflowSoftwareProcess
extends SoftwareProcess {
    public static final ConfigKey<SoftwareProcess.ChildStartableMode> CHILDREN_STARTABLE_MODE = ConfigKeys.newConfigKeyWithDefault(SoftwareProcess.CHILDREN_STARTABLE_MODE, (Object)((Object)SoftwareProcess.ChildStartableMode.FOREGROUND_LATE));
    @CatalogConfig(label="Install Workflow", priority=5.0)
    public static final ConfigKey<CustomWorkflowStep> INSTALL_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, (String)"install.workflow").description("workflow to run during the software install phase").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Customize Workflow", priority=4.0)
    public static final ConfigKey<CustomWorkflowStep> CUSTOMIZE_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, (String)"customize.workflow").description("workflow to run during the software customization phase").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Launch Workflow", priority=3.0)
    public static final ConfigKey<CustomWorkflowStep> LAUNCH_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, (String)"launch.workflow").description("workflow to run to launch the software process").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Check-running Workflow", priority=2.0)
    public static final ConfigKey<CustomWorkflowStep> CHECK_RUNNING_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, (String)"checkRunning.workflow").description("workflow to determine whether the software process is running").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Stop Workflow", priority=1.0)
    public static final ConfigKey<CustomWorkflowStep> STOP_WORKFLOW = ConfigKeys.builder(CustomWorkflowStep.class, (String)"stop.workflow").description("workflow to run to stop the software process").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<Boolean> USE_SSH_MONITORING = ConfigKeys.newConfigKey((String)"sshMonitoring.enabled", (String)"SSH monitoring enabled", (Object)Boolean.TRUE);
    public static final ConfigKey<Boolean> USE_PID_FILE = ConfigKeys.newConfigKey((String)"usePidFile", (String)"Use a PID file to check running", (Object)Boolean.FALSE);
}

